/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AlgorithmRestriction;
import de.trustable.ca3s.core.repository.AlgorithmRestrictionRepository;
import de.trustable.ca3s.core.service.AlgorithmRestrictionService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AlgorithmRestrictionResource {
    private final Logger log = LoggerFactory.getLogger(AlgorithmRestrictionResource.class);
    private static final String ENTITY_NAME = "algorithmRestriction";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AlgorithmRestrictionService algorithmRestrictionService;
    private final AlgorithmRestrictionRepository algorithmRestrictionRepository;

    public AlgorithmRestrictionResource(AlgorithmRestrictionService algorithmRestrictionService, AlgorithmRestrictionRepository algorithmRestrictionRepository) {
        this.algorithmRestrictionService = algorithmRestrictionService;
        this.algorithmRestrictionRepository = algorithmRestrictionRepository;
    }

    @PostMapping(value={"/algorithm-restrictions"})
    public ResponseEntity<AlgorithmRestriction> createAlgorithmRestriction(@Valid @RequestBody AlgorithmRestriction algorithmRestriction) throws URISyntaxException {
        this.log.debug("REST request to save AlgorithmRestriction : {}", (Object)algorithmRestriction);
        if (algorithmRestriction.getId() != null) {
            throw new BadRequestAlertException("A new algorithmRestriction cannot already have an ID", ENTITY_NAME, "idexists");
        }
        AlgorithmRestriction result = this.algorithmRestrictionService.save(algorithmRestriction);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/algorithm-restrictions/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/algorithm-restrictions/{id}"})
    public ResponseEntity<AlgorithmRestriction> updateAlgorithmRestriction(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody AlgorithmRestriction algorithmRestriction) throws URISyntaxException {
        this.log.debug("REST request to update AlgorithmRestriction : {}, {}", (Object)id, (Object)algorithmRestriction);
        if (algorithmRestriction.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, algorithmRestriction.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.algorithmRestrictionRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        AlgorithmRestriction result = this.algorithmRestrictionService.save(algorithmRestriction);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)algorithmRestriction.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/algorithm-restrictions"})
    public List<AlgorithmRestriction> getAllAlgorithmRestrictions() {
        this.log.debug("REST request to get all AlgorithmRestrictions");
        return this.algorithmRestrictionService.findAll();
    }

    @GetMapping(value={"/algorithm-restrictions/{id}"})
    public ResponseEntity<AlgorithmRestriction> getAlgorithmRestriction(@PathVariable Long id) {
        this.log.debug("REST request to get AlgorithmRestriction : {}", (Object)id);
        Optional algorithmRestriction = this.algorithmRestrictionService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)algorithmRestriction);
    }

    @DeleteMapping(value={"/algorithm-restrictions/{id}"})
    public ResponseEntity<Void> deleteAlgorithmRestriction(@PathVariable Long id) {
        this.log.debug("REST request to delete AlgorithmRestriction : {}", (Object)id);
        this.algorithmRestrictionService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

