/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.PipelineAttribute;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.service.PipelineAttributeService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class PipelineAttributeResource {
    private final Logger log = LoggerFactory.getLogger(PipelineAttributeResource.class);
    private static final String ENTITY_NAME = "pipelineAttribute";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final PipelineAttributeService pipelineAttributeService;

    public PipelineAttributeResource(PipelineAttributeService pipelineAttributeService) {
        this.pipelineAttributeService = pipelineAttributeService;
    }

    @PostMapping(value={"/pipeline-attributes"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<PipelineAttribute> createPipelineAttribute(@Valid @RequestBody PipelineAttribute pipelineAttribute) throws URISyntaxException {
        this.log.debug("REST request to save PipelineAttribute : {}", (Object)pipelineAttribute);
        if (pipelineAttribute.getId() != null) {
            throw new BadRequestAlertException("A new pipelineAttribute cannot already have an ID", ENTITY_NAME, "idexists");
        }
        PipelineAttribute result = this.pipelineAttributeService.save(pipelineAttribute);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/pipeline-attributes/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/pipeline-attributes"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<PipelineAttribute> updatePipelineAttribute(@Valid @RequestBody PipelineAttribute pipelineAttribute) throws URISyntaxException {
        this.log.debug("REST request to update PipelineAttribute : {}", (Object)pipelineAttribute);
        if (pipelineAttribute.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        PipelineAttribute result = this.pipelineAttributeService.save(pipelineAttribute);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)pipelineAttribute.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/pipeline-attributes"})
    public List<PipelineAttribute> getAllPipelineAttributes() {
        this.log.debug("REST request to get all PipelineAttributes");
        return this.pipelineAttributeService.findAll();
    }

    @GetMapping(value={"/pipeline-attributes/{id}"})
    public ResponseEntity<PipelineAttribute> getPipelineAttribute(@PathVariable Long id) {
        this.log.debug("REST request to get PipelineAttribute : {}", (Object)id);
        Optional pipelineAttribute = this.pipelineAttributeService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)pipelineAttribute);
    }

    @DeleteMapping(value={"/pipeline-attributes/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Void> deletePipelineAttribute(@PathVariable Long id) {
        this.log.debug("REST request to delete PipelineAttribute : {}", (Object)id);
        this.pipelineAttributeService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

