/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import com.nimbusds.jose.JOSEException;
import de.trustable.ca3s.core.domain.RequestProxyConfig;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.service.RequestProxyConfigService;
import de.trustable.ca3s.core.service.dto.RemoteRequestProxyConfigView;
import de.trustable.ca3s.core.service.util.JWSService;
import io.swagger.v3.oas.annotations.Parameter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class RequestProxyConfigResource {
    private final Logger log = LoggerFactory.getLogger(RequestProxyConfigResource.class);
    private static final String ENTITY_NAME = "requestProxyConfig";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final RequestProxyConfigService requestProxyConfigService;
    private final JWSService jwsService;

    public RequestProxyConfigResource(RequestProxyConfigService requestProxyConfigService, JWSService jwsService) {
        this.requestProxyConfigService = requestProxyConfigService;
        this.jwsService = jwsService;
    }

    @PostMapping(value={"/request-proxy-configs"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    @Transactional
    public ResponseEntity<RequestProxyConfig> createRequestProxyConfig(@Valid @RequestBody RequestProxyConfig requestProxyConfig) throws URISyntaxException {
        this.log.debug("REST request to save RequestProxyConfig : {}", (Object)requestProxyConfig);
        if (requestProxyConfig.getId() != null) {
            throw new BadRequestAlertException("A new requestProxyConfig cannot already have an ID", ENTITY_NAME, "idexists");
        }
        RequestProxyConfig result = this.requestProxyConfigService.save(requestProxyConfig);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/request-proxy-configs/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/request-proxy-configs"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    @Transactional
    public ResponseEntity<RequestProxyConfig> updateRequestProxyConfig(@Valid @RequestBody RequestProxyConfig requestProxyConfig) throws URISyntaxException {
        this.log.debug("REST request to update RequestProxyConfig : {}", (Object)requestProxyConfig);
        if (requestProxyConfig.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        RequestProxyConfig result = this.requestProxyConfigService.save(requestProxyConfig);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)requestProxyConfig.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/request-proxy-configs"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public List<RequestProxyConfig> getAllRequestProxyConfigs() {
        this.log.debug("REST request to get all RequestProxyConfigs");
        return this.requestProxyConfigService.findAll();
    }

    @GetMapping(value={"/request-proxy-configs/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<RequestProxyConfig> getRequestProxyConfig(@PathVariable Long id) {
        this.log.debug("REST request to get RequestProxyConfig : {}", (Object)id);
        Optional requestProxyConfig = this.requestProxyConfigService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)requestProxyConfig);
    }

    @PostMapping(value={"/request-proxy-configs/remote-config/{requestProxyId}"})
    @Transactional
    public ResponseEntity<RemoteRequestProxyConfigView> postRequestProxyConfig(@Parameter(description="AcmeChallengeValidation wrapped in a JWS") @Valid @RequestBody String body, @RequestHeader(value="Accept", required=false) String accept, @PathVariable Long requestProxyId) {
        this.log.debug("REST request to get RequestProxyConfig : {}", (Object)requestProxyId);
        if (accept != null && accept.contains("application/json")) {
            try {
                this.log.debug("incoming JWT " + body);
                this.jwsService.checkJWT(body, requestProxyId.intValue());
                Optional requestProxyConfigOptional = this.requestProxyConfigService.findOne(requestProxyId);
                Optional<Object> remoteRequestProxyConfigViewOptional = Optional.empty();
                if (requestProxyConfigOptional.isPresent()) {
                    remoteRequestProxyConfigViewOptional = Optional.of(new RemoteRequestProxyConfigView((RequestProxyConfig)requestProxyConfigOptional.get()));
                }
                return ResponseUtil.wrapOrNotFound(remoteRequestProxyConfigViewOptional);
            }
            catch (GeneralSecurityException e) {
                this.log.error("Couldn't process request", (Throwable)e);
                return ResponseEntity.internalServerError().build();
            }
            catch (JOSEException | ParseException e) {
                this.log.error("Couldn't process JOSE element", e);
                return ResponseEntity.badRequest().build();
            }
        }
        return new ResponseEntity(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    @DeleteMapping(value={"/request-proxy-configs/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    @Transactional
    public ResponseEntity<Void> deleteRequestProxyConfig(@PathVariable Long id) {
        this.log.debug("REST request to delete RequestProxyConfig : {}", (Object)id);
        this.requestProxyConfigService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

