/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.AcmeNonce;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.CacheControl;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/acme/{realm}/newNonce"})
public class NewNonceController
extends AcmeController {
    private static final Logger LOG = LoggerFactory.getLogger(NewNonceController.class);

    @RequestMapping(method={RequestMethod.HEAD})
    public ResponseEntity<String> viaHead() {
        LOG.info("New NONCE requested using Head");
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.buildNonceHeader())).cacheControl(CacheControl.noStore())).build();
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<String> viaGet() {
        LOG.info("New NONCE requested");
        return ResponseEntity.noContent().headers(this.buildNonceHeader()).cacheControl(CacheControl.noStore()).build();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void cleanupNonces() {
        long startTime = System.currentTimeMillis();
        List expiredNonceList = this.nonceRepository.findByNonceExpiryDate(new Date());
        if (expiredNonceList.isEmpty()) {
            return;
        }
        LOG.debug("CleanupScheduler.cleanupNonce called ...");
        for (AcmeNonce nonce : expiredNonceList) {
            LOG.debug("cleanupNonce {} deleting", (Object)nonce.getNonceValue());
            this.nonceRepository.delete((Object)nonce);
        }
        LOG.debug("CleanupScheduler.cleanupNonce finishes in {} ms", (Object)(System.currentTimeMillis() - startTime));
    }
}

