/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.config.CryptoConfiguration;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Tenant;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.security.SecurityUtils;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import de.trustable.ca3s.core.web.rest.support.NotFoundException;
import de.trustable.ca3s.core.web.rest.support.UnauthorizedException;
import de.trustable.ca3s.core.web.rest.util.UserUtil;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.HttpClientErrorException;

@Controller
@RequestMapping(value={"/publicapi"})
public class CertificateDownloadController {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateDownloadController.class);
    private boolean chainIncludeRoot = true;
    private final CryptoConfiguration cryptoConfiguration;
    private final CertificateRepository certificateRepository;
    private final CertificateUtil certUtil;
    private final ProtectedContentUtil protContentUtil;
    private final UserUtil userUtil;
    private final AuditService auditService;
    private final String certificateStoreIsolation;
    private final boolean pkcs12LogDownload;

    public CertificateDownloadController(CryptoConfiguration cryptoConfiguration, CertificateRepository certificateRepository, CertificateUtil certUtil, ProtectedContentUtil protContentUtil, UserUtil userUtil, AuditService auditService, @Value(value="${ca3s.ui.certificate-store.isolation:none}") String certificateStoreIsolation, @Value(value="${ca3s.ui.pkcs12.log.download:true}") boolean pkcs12LogDownload) {
        this.cryptoConfiguration = cryptoConfiguration;
        this.certificateRepository = certificateRepository;
        this.certUtil = certUtil;
        this.protContentUtil = protContentUtil;
        this.userUtil = userUtil;
        this.auditService = auditService;
        this.certificateStoreIsolation = certificateStoreIsolation;
        this.pkcs12LogDownload = pkcs12LogDownload;
    }

    @RequestMapping(value={"/certPKIX/{certId}/{filename}"}, method={RequestMethod.GET}, produces={"application/pkix-cert"})
    public ResponseEntity<byte[]> getCertificatePKIX(@PathVariable long certId, @PathVariable String filename) throws NotFoundException {
        LOG.info("Received certificate download request (PKIX) for id {} as file '{}' ", (Object)certId, (Object)filename);
        if (SecurityContextHolder.getContext() == null) {
            throw new NotFoundException("Authentication required");
        }
        try {
            return this.buildByteArrayResponseForId(certId, "application/pkix-cert", "", filename);
        }
        catch (AcmeProblemException | GeneralSecurityException | HttpClientErrorException e) {
            throw new NotFoundException(e.getMessage());
        }
    }

    @RequestMapping(value={"/certPEMChain/{certId}/{filename}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCertificatePEMChain(@PathVariable long certId, @PathVariable String filename) {
        LOG.info("Received certificate download request (PEM with chain) for id {} as file '{}'", (Object)certId, (Object)filename);
        return this.buildCertResponseForId(certId, "application/pem-certificate-chain", filename);
    }

    @RequestMapping(value={"/certPEMPart/{certId}/{filename}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCertificatePEMPart(@PathVariable long certId, @PathVariable String filename) {
        LOG.info("Received certificate download request (PEM with partial chain) for id {} as file '{}'", (Object)certId, (Object)filename);
        return this.buildCertResponseForId(certId, "application/x-pem-certificate-chain", filename);
    }

    @RequestMapping(value={"/certPEMFull/{certId}/{filename}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCertificatePEMFull(@PathVariable long certId, @PathVariable String filename) {
        LOG.info("Received certificate download request (PEM with full chain) for id {} as file '{}'", (Object)certId, (Object)filename);
        return this.buildCertResponseForId(certId, "application/pem-certificate-chain", filename);
    }

    @RequestMapping(value={"/certPEM/{certId}/{filename}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCertificatePEM(@PathVariable long certId, @PathVariable String filename) {
        LOG.info("Received certificate download request (PEM) for id {} as file '{}'", (Object)certId, (Object)filename);
        return this.buildCertResponseForId(certId, "application/pem-certificate", filename);
    }

    @RequestMapping(value={"/cert/{certId}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCertificate(@PathVariable long certId, @RequestHeader(name="Accept", defaultValue="application/pkix-cert") String accept) {
        LOG.info("Received certificate request for id {}", (Object)certId);
        return this.buildCertResponseForId(certId, accept, "cert_" + certId + ".cer");
    }

    @RequestMapping(value={"/keystore/{certId}/{filename}/{alias}"}, method={RequestMethod.GET}, produces={"application/x-pkcs12"})
    public ResponseEntity<byte[]> getKeystore(@PathVariable long certId, @PathVariable String filename, @PathVariable String alias, @RequestHeader(name="Accept", defaultValue="application/x-pkcs12") String accept) throws NotFoundException, UnauthorizedException {
        LOG.info("Received keystore request for id '{}' for filename '{}' with alias '{}'", new Object[]{certId, filename, alias});
        try {
            return this.buildByteArrayResponseForId(certId, accept, alias, filename);
        }
        catch (AccessControlException ace) {
            throw new UnauthorizedException(ace.getMessage());
        }
        catch (AcmeProblemException | GeneralSecurityException | HttpClientErrorException e) {
            throw new NotFoundException(e.getMessage());
        }
    }

    public ResponseEntity<?> buildCertResponseForId(long certId, String accept, String filename) throws HttpClientErrorException, AcmeProblemException {
        Optional certOpt = this.certificateRepository.findById((Object)certId);
        if (!certOpt.isPresent()) {
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND);
        }
        Certificate certDao = (Certificate)certOpt.get();
        this.checkTenant(certDao);
        HttpHeaders headers = new HttpHeaders();
        headers.set("content-disposition", "inline; filename=\"" + filename + "\"");
        ResponseEntity resp = this.buildCertifcateResponse(accept, certDao, headers);
        if (resp == null) {
            String msg = "problem returning certificate with accepting type " + accept;
            LOG.info(msg);
            return ResponseEntity.badRequest().build();
        }
        return resp;
    }

    public ResponseEntity<byte[]> buildByteArrayResponseForId(long certId, String accept, String alias, String filename) throws HttpClientErrorException, AcmeProblemException, GeneralSecurityException {
        Optional certOpt = this.certificateRepository.findById((Object)certId);
        if (!certOpt.isPresent()) {
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND);
        }
        Certificate certDao = (Certificate)certOpt.get();
        this.checkTenant(certDao);
        HttpHeaders headers = new HttpHeaders();
        headers.set("content-disposition", "inline; filename=\"" + filename + "\"");
        if ("application/pkix-cert".equalsIgnoreCase(accept)) {
            return this.buildPkixCertResponse(certDao, headers);
        }
        if ("application/x-pkcs12".equalsIgnoreCase(accept)) {
            return this.buildPKCS12Response(certDao, alias, headers);
        }
        throw new HttpClientErrorException(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    private void checkTenant(Certificate cert) {
        User currentUser;
        Tenant tenant;
        if ("none".equalsIgnoreCase(this.certificateStoreIsolation)) {
            return;
        }
        if (!this.userUtil.isAdministrativeUser() && (tenant = (currentUser = this.userUtil.getCurrentUser()).getTenant()) != null && !tenant.equals((Object)cert.getTenant()) && cert.isEndEntity()) {
            LOG.info("user [{}] tried to download EE certificate [{}] of tenant [{}]", new Object[]{currentUser.getLogin(), cert.getId(), tenant.getLongname()});
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND);
        }
    }

    public ResponseEntity<?> buildCertifcateResponse(String accept, Certificate certDao, HttpHeaders headers) {
        if ("*/*".equalsIgnoreCase(accept)) {
            return this.buildPEMResponse(certDao, headers, AcmeController.APPLICATION_PEM_CERT_CHAIN, true, false);
        }
        if ("application/x-pem-certificate-chain".equalsIgnoreCase(accept)) {
            return this.buildPEMResponse(certDao, headers, AcmeController.APPLICATION_PEM_CERT_CHAIN, true, false);
        }
        if ("application/pem-certificate-chain".equalsIgnoreCase(accept)) {
            return this.buildPEMResponse(certDao, headers, AcmeController.APPLICATION_PEM_CERT_CHAIN, true, true);
        }
        if ("application/pem-certificate".equalsIgnoreCase(accept)) {
            return this.buildPEMResponse(certDao, headers, AcmeController.APPLICATION_PEM_CERT, false, false);
        }
        LOG.info("unexpected accept type {}", (Object)accept);
        return null;
    }

    private ResponseEntity<?> buildPEMResponse(Certificate certDao, HttpHeaders headers, MediaType mediaType, boolean includeChain, boolean includeRoot) {
        LOG.info("building PEM certificate response");
        try {
            Object resultPem = "";
            if (includeChain) {
                List chain = this.certUtil.getCertificateChain(certDao);
                boolean isFirst = true;
                Iterator it = chain.iterator();
                while (it.hasNext()) {
                    Certificate chainCertDao = (Certificate)it.next();
                    if (!it.hasNext() && !includeRoot) continue;
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        resultPem = (String)resultPem + "# issued by\n";
                    }
                    resultPem = (String)resultPem + "# Subject: " + chainCertDao.getSubject() + "\n";
                    resultPem = (String)resultPem + "# Issuer: " + chainCertDao.getIssuer() + "\n";
                    resultPem = (String)resultPem + "# Serial: " + chainCertDao.getSerial() + "\n";
                    resultPem = (String)resultPem + "# valid from : " + chainCertDao.getValidFrom() + " to " + chainCertDao.getValidTo() + "\n";
                    resultPem = (String)resultPem + "#\n";
                    resultPem = (String)resultPem + chainCertDao.getContent();
                }
            } else {
                resultPem = (String)resultPem + certDao.getContent();
            }
            LOG.debug("returning cert and issuer : \n" + (String)resultPem);
            headers.set("content-length", String.valueOf(((String)resultPem).getBytes().length));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(mediaType).headers(headers)).body((Object)((String)resultPem).getBytes());
        }
        catch (GeneralSecurityException ge) {
            String msg = "problem building certificate chain";
            LOG.info(msg, (Throwable)ge);
            return ResponseEntity.badRequest().build();
        }
    }

    private ResponseEntity<byte[]> buildPkixCertResponse(Certificate certDao, HttpHeaders headers) throws GeneralSecurityException {
        LOG.info("building PKIX certificate response");
        try {
            X509Certificate x509Cert = CryptoService.convertPemToCertificate((String)certDao.getContent());
            byte[] contentBytes = x509Cert.getEncoded();
            headers.set("content-length", String.valueOf(contentBytes.length));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(AcmeController.APPLICATION_PKIX_CERT).headers(headers)).body((Object)contentBytes);
        }
        catch (GeneralSecurityException gse) {
            LOG.info("problem downloading certificate content for cert id " + certDao.getId(), (Throwable)gse);
            throw gse;
        }
    }

    private ResponseEntity<byte[]> buildPKCS12Response(Certificate certDao, String alias, HttpHeaders headers) throws GeneralSecurityException {
        CSR csr;
        LOG.info("building PKCS12 container response");
        String entryAlias = "entry";
        if (alias != null && !alias.trim().isEmpty()) {
            entryAlias = alias;
        }
        if ((csr = certDao.getCsr()) == null) {
            throw new GeneralSecurityException("problem downloading keystore content for cert id " + certDao.getId() + ": no csr object available ");
        }
        if (SecurityUtils.isCurrentUserInRole((String)"ROLE_ADMIN") || SecurityUtils.isCurrentUserInRole((String)"ROLE_RA")) {
            LOG.debug("Admins and RA Officers are allowed to download P12 files");
        } else if (SecurityUtils.isCurrentUserInRole((String)"ROLE_RA_DOMAIN")) {
            LOG.debug("Admins and RA Officers are allowed to download P12 files");
        } else {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            String userName = auth.getName();
            if (userName == null) {
                throw new GeneralSecurityException("problem downloading keystore content for csr id " + csr.getId() + ":  user name not available");
            }
            if (!userName.equals(csr.getRequestedBy())) {
                throw new AccessControlException("problem downloading keystore content for csr id " + csr.getId() + ": user does not match initial requestor");
            }
        }
        boolean keyEx = false;
        List keyExHeaderList = headers.get((Object)"X_keyEx");
        if (keyExHeaderList != null && !keyExHeaderList.isEmpty()) {
            keyEx = Boolean.parseBoolean((String)keyExHeaderList.get(0));
        }
        LOG.info("PKCS12: keyEx flag: {} ", (Object)keyEx);
        String passwordProtectionAlgo = this.cryptoConfiguration.getDefaultPBEAlgo();
        List algoHeaderList = headers.get((Object)"X_pbeAlgo");
        if (algoHeaderList != null && !algoHeaderList.isEmpty()) {
            String reqAlgo = ((String)algoHeaderList.get(0)).trim();
            if (this.cryptoConfiguration.isPBEAlgoAllowed(reqAlgo)) {
                passwordProtectionAlgo = reqAlgo;
            } else {
                LOG.info("requested PKCS12 pbe algo '{}' not in list of valid algos, using default '{}' ", (Object)reqAlgo, (Object)passwordProtectionAlgo);
            }
        }
        LOG.info("PKCS12: using algo {} ", (Object)passwordProtectionAlgo);
        try {
            byte[] contentBytes = this.certUtil.getContainerBytes(certDao, entryAlias, csr, passwordProtectionAlgo);
            headers.set("content-length", String.valueOf(contentBytes.length));
            if (this.pkcs12LogDownload) {
                this.auditService.saveAuditTrace(this.auditService.createAuditTracePKCS12CertificateDownload(certDao));
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(AcmeController.APPLICATION_PKCS12).headers(headers)).body((Object)contentBytes);
        }
        catch (IOException gse) {
            throw new GeneralSecurityException("problem downloading keystore content for cert id " + certDao.getId());
        }
    }
}

