/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.util;

import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.AcmeUtil;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.local.LocalBucket;
import io.github.bucket4j.local.LocalBucketBuilder;
import java.time.Duration;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class RateLimiter {
    Logger LOG = LoggerFactory.getLogger(RateLimiter.class);
    int maxEntries = 100;
    private int rateSec = 0;
    private int rateMin = 20;
    private int rateHour = 0;
    LinkedHashMap<Long, Bucket> lruMapOrder;
    private final String endpointName;

    public RateLimiter(String endpointName) {
        this.endpointName = endpointName;
        this.lruMapOrder = new /* Unavailable Anonymous Inner Class!! */;
    }

    public RateLimiter(String endpointName, int rateSec, int rateMin, int rateHour) {
        this(endpointName);
        this.rateSec = rateSec;
        this.rateMin = rateMin;
        this.rateHour = rateHour;
    }

    public void checkRateLimit(long id, String realm) {
        Bucket bucket = this.getBucket(id);
        this.LOG.debug("Current bucket : {} ", (Object)bucket);
        if (!bucket.tryConsume(1L)) {
            this.LOG.warn("rate limit applies to '{}/{}/{}'", new Object[]{realm, this.endpointName, id});
            ProblemDetail problem = new ProblemDetail(AcmeUtil.RATE_LIMITED, "Rate limit applies", HttpStatus.BAD_REQUEST, "Too many requests for ACME object", AcmeController.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
        this.LOG.debug("rate limitation bucket has {} tokens left", (Object)bucket.getAvailableTokens());
    }

    private Bucket getBucket(long id) {
        if (this.lruMapOrder.containsKey(id)) {
            return (Bucket)this.lruMapOrder.get(id);
        }
        this.LOG.info("creating new bucket for '{}' '{}'", (Object)this.endpointName, (Object)id);
        LocalBucketBuilder bucketBuilder = Bucket.builder();
        if (this.rateSec > 0) {
            bucketBuilder.addLimit(Bandwidth.simple((long)this.rateSec, (Duration)Duration.ofSeconds(1L)));
        }
        if (this.rateMin > 0) {
            bucketBuilder.addLimit(Bandwidth.simple((long)this.rateMin, (Duration)Duration.ofMinutes(1L)));
        }
        if (this.rateHour > 0) {
            bucketBuilder.addLimit(Bandwidth.simple((long)this.rateHour, (Duration)Duration.ofHours(1L)));
        }
        LocalBucket bucket = bucketBuilder.build();
        this.lruMapOrder.put(id, bucket);
        return bucket;
    }
}

