/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.util;

import de.trustable.ca3s.core.domain.Authority;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.exception.UserNotFoundException;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.dto.CSRView;
import de.trustable.ca3s.core.service.dto.CertificateView;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UserUtil {
    private final Logger LOG = LoggerFactory.getLogger(UserUtil.class);
    private final UserRepository userRepository;

    public UserUtil(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public User getCurrentUser() {
        this.LOG.debug("getCurrentUser of a web session");
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String userName = auth.getName();
        if (userName == null) {
            String msg = "Current user == null!";
            this.LOG.warn(msg);
            throw new UserNotFoundException(msg);
        }
        Optional optCurrentUser = this.userRepository.findOneByLogin(userName);
        if (!optCurrentUser.isPresent()) {
            String msg = "Name of ra officer '" + userName + "' not found as user";
            this.LOG.warn(msg);
            throw new UserNotFoundException(msg);
        }
        return (User)optCurrentUser.get();
    }

    public boolean isAdministrativeUser() {
        return UserUtil.isAdministrativeUser((User)this.getCurrentUser());
    }

    public static boolean isAdministrativeUser(User user) {
        for (Authority authority : user.getAuthorities()) {
            String authorityName = authority.getName();
            if (!authorityName.equals("ROLE_ADMIN") && !authorityName.equals("ROLE_RA") && !authorityName.equals("ROLE_RA_DOMAIN")) continue;
            return true;
        }
        return false;
    }

    public void addUserDetails(CertificateView certificateView) {
        Optional optionalUser;
        if (this.isAdministrativeUser() && (optionalUser = this.userRepository.findOneByLogin(certificateView.getRequestedBy())).isPresent()) {
            User user = (User)optionalUser.get();
            certificateView.setFirstName(user.getFirstName());
            certificateView.setLastName(user.getLastName());
            certificateView.setEmail(user.getEmail());
        }
    }

    public void addUserDetails(CSRView csrView) {
        Optional optionalUser;
        if (this.isAdministrativeUser() && (optionalUser = this.userRepository.findOneByLogin(csrView.getRequestedBy())).isPresent()) {
            User user = (User)optionalUser.get();
            csrView.setFirstName(user.getFirstName());
            csrView.setLastName(user.getLastName());
            csrView.setEmail(user.getEmail());
        }
    }
}

