/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.AuditTrace;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.repository.AcmeAccountRepository;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.repository.AuditTraceRepository;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.CsrAttributeRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class SchemaUpdateScheduler {
    transient Logger LOG = LoggerFactory.getLogger(SchemaUpdateScheduler.class);
    private final int maxRecordsPerTransaction;
    private final CertificateRepository certificateRepo;
    private final CertificateUtil certUtil;
    private final CSRRepository csrRepository;
    private final CsrAttributeRepository csrAttributeRepository;
    private final CSRUtil csrUtil;
    private final AcmeOrderRepository acmeOrderRepository;
    private final AcmeAccountRepository acmeAccountRepository;
    private final PipelineRepository pipelineRepository;
    private final AuditService auditService;
    private final AuditTraceRepository auditServiceRepository;

    public SchemaUpdateScheduler(@Value(value="${ca3s.batch.maxRecordsPerTransaction:1000}") int maxRecordsPerTransaction, CertificateRepository certificateRepo, CertificateUtil certUtil, CSRRepository csrRepository, CsrAttributeRepository csrAttributeRepository, CSRUtil csrUtil, AcmeOrderRepository acmeOrderRepository, AcmeAccountRepository acmeAccountRepository, PipelineRepository pipelineRepository, AuditService auditService, AuditTraceRepository auditServiceRepository) {
        this.maxRecordsPerTransaction = maxRecordsPerTransaction;
        this.certificateRepo = certificateRepo;
        this.certUtil = certUtil;
        this.csrRepository = csrRepository;
        this.csrAttributeRepository = csrAttributeRepository;
        this.csrUtil = csrUtil;
        this.acmeOrderRepository = acmeOrderRepository;
        this.acmeAccountRepository = acmeAccountRepository;
        this.pipelineRepository = pipelineRepository;
        this.auditService = auditService;
        this.auditServiceRepository = auditServiceRepository;
    }

    @Scheduled(fixedDelay=600000L)
    public void performSchemaUpdates() {
        Instant now = Instant.now();
        this.updateCertificateAttributes();
        this.LOG.info("updateCertificateAttributes took {} ms", (Object)Duration.between(now, Instant.now()));
        now = Instant.now();
        this.updateCSRAttributes();
        this.LOG.info("updateCSRAttributes took {} ms", (Object)Duration.between(now, Instant.now()));
        now = Instant.now();
        this.updateAcmeOrder();
        this.LOG.info("updateAcmeOrder took {} ms", (Object)Duration.between(now, Instant.now()));
        now = Instant.now();
        this.updateACMEAccount();
        this.LOG.info("updateACMEAccount took {} ms", (Object)Duration.between(now, Instant.now()));
    }

    public void updateCertificateAttributes() {
        Page updateCertificateList = this.certificateRepo.findByAttributeValueLowerThan((Pageable)PageRequest.of((int)0, (int)this.maxRecordsPerTransaction), "ATTRIBUTES_VERSION", "5");
        this.LOG.info("{} certificates selected for schema update", (Object)updateCertificateList.getNumberOfElements());
        int count = 0;
        for (Certificate cert : updateCertificateList) {
            try {
                int currentVersion = Integer.parseInt(this.certUtil.getCertAttribute(cert, "ATTRIBUTES_VERSION"));
                X509Certificate x509Cert = CryptoService.convertPemToCertificate((String)cert.getContent());
                if (currentVersion < 4) {
                    this.certUtil.interpretBasicConstraint(x509Cert, cert);
                }
                this.certUtil.addAdditionalCertificateAttributes(x509Cert, cert);
                this.certificateRepo.save((Object)cert);
                this.LOG.info("attribute schema updated for certificate id {} ", (Object)cert.getId());
            }
            catch (IOException | GeneralSecurityException e) {
                this.LOG.error("problem with attribute schema update for certificate id " + cert.getId(), (Throwable)e);
            }
            if (count++ <= this.maxRecordsPerTransaction) continue;
            this.LOG.info("limited certificate validity processing to {} per call", (Object)this.maxRecordsPerTransaction);
            break;
        }
        if (count > 0) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificateSchemaUpdated(count, 5));
        }
    }

    public void updateCSRAttributes() {
        Page updateCSRList = this.csrRepository.findWithoutAttribute((Pageable)PageRequest.of((int)0, (int)this.maxRecordsPerTransaction), "ATTRIBUTES_VERSION");
        this.LOG.info("{} CSRs without version attribute selected for schema update", (Object)updateCSRList.getNumberOfElements());
        int count = 0;
        for (CSR csr : updateCSRList) {
            try {
                this.fixIPSan(csr);
                this.csrUtil.setCSRAttributeVersion(csr, "1");
                this.csrAttributeRepository.saveAll((Iterable)csr.getCsrAttributes());
                this.csrRepository.save((Object)csr);
                this.LOG.info("attribute schema updated for csr id {} ", (Object)csr.getId());
            }
            catch (UnknownHostException e) {
                this.LOG.error("problem with attribute schema update for csr id " + csr.getId(), (Throwable)e);
            }
            if (count++ <= this.maxRecordsPerTransaction) continue;
            this.LOG.info("limited CSR schema processing to {} per call", (Object)this.maxRecordsPerTransaction);
            break;
        }
        if (count > 0) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificateSchemaUpdated(count, 2));
        }
        List version1CSRList = this.csrRepository.findByAttributeValue("ATTRIBUTES_VERSION", "1");
        count = 0;
        for (CSR csr : version1CSRList) {
            this.LOG.info("checking audit for csr id {}", (Object)csr.getId());
            this.csrUtil.setCSRAttributeVersion(csr, "2");
            List auditTraceList = this.auditServiceRepository.findByCsrAndTemplate(csr, "CSR_ACCEPTED");
            if (!auditTraceList.isEmpty()) {
                csr.setAcceptedBy(((AuditTrace)auditTraceList.get(0)).getActorName());
                this.LOG.info("csr id {} accepted by '{}'", (Object)csr.getId(), (Object)csr.getAcceptedBy());
            }
            this.csrRepository.save((Object)csr);
            if (count++ <= this.maxRecordsPerTransaction) continue;
            this.LOG.info("limited CSR 'accepted by' processing to {} per call", (Object)this.maxRecordsPerTransaction);
            break;
        }
    }

    private void fixIPSan(CSR csr) throws UnknownHostException {
        for (CsrAttribute attr : csr.getCsrAttributes()) {
            String value = null;
            if (attr.getName().equals("SAN") && attr.getValue().startsWith("#")) {
                value = attr.getValue().substring(1);
            }
            if (attr.getName().equals("TYPED_SAN") && attr.getValue().startsWith("IP:#")) {
                value = attr.getValue().substring(4);
            }
            if (value == null) continue;
            try {
                InetAddress inetAddress = InetAddress.getByAddress(Hex.decode((String)value));
                if (attr.getName().equals("TYPED_SAN")) {
                    attr.setValue("IP:" + inetAddress.getHostAddress());
                    this.LOG.debug("update TYPED_SAN attribute #{} to {}", (Object)attr.getId(), (Object)attr.getValue());
                    continue;
                }
                attr.setValue(inetAddress.getHostAddress());
                this.LOG.debug("update SAN attribute #{} to {}", (Object)attr.getId(), (Object)attr.getValue());
            }
            catch (DecoderException de) {
                this.LOG.info("SAN attribute #{} contains invalid IP address {}, ignoring ...", (Object)attr.getId(), (Object)value);
            }
        }
    }

    public void updateAcmeOrder() {
        Page acmeOrderList = this.acmeOrderRepository.findPipelineIsNull((Pageable)PageRequest.of((int)0, (int)this.maxRecordsPerTransaction));
        this.LOG.info("{} ACME Order without pipeline reference selected for schema update", (Object)acmeOrderList.getNumberOfElements());
        int count = 0;
        for (AcmeOrder acmeOrder : acmeOrderList) {
            if (acmeOrder.getAccount() != null) {
                String realm = acmeOrder.getAccount().getRealm();
                List pipelineList = this.pipelineRepository.findByTypeUrl(PipelineType.ACME, realm);
                if (!pipelineList.isEmpty()) {
                    acmeOrder.setPipeline((Pipeline)pipelineList.get(0));
                    acmeOrder.setRealm(realm);
                    this.acmeOrderRepository.save((Object)acmeOrder);
                    this.LOG.info("realm and pipeline updated for acme order {} ", (Object)acmeOrder);
                }
                if (count++ <= this.maxRecordsPerTransaction) continue;
                this.LOG.info("limited AcmeOrder processing to {} per call", (Object)this.maxRecordsPerTransaction);
                break;
            }
            this.LOG.info("acme order {} has no account!", (Object)acmeOrder.getId());
        }
        if (count > 0) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeOrderPipelineUpdated(count));
            this.LOG.info("AcmeOrder pipeline / realm processing of {} orders", (Object)count);
        }
    }

    public void updateACMEAccount() {
        Instant now = Instant.now();
        Page acmeAccountList = this.acmeAccountRepository.findByCreatedOnIsNull((Pageable)PageRequest.of((int)0, (int)this.maxRecordsPerTransaction));
        this.LOG.info("{} ACME account without 'createdOn'' selected for schema update", (Object)acmeAccountList.getNumberOfElements());
        int count = 0;
        for (AcmeAccount acmeAccount : acmeAccountList) {
            Instant oldestOrder = now;
            for (AcmeOrder acmeOrder : acmeAccount.getOrders()) {
                if (!acmeOrder.getNotBefore().isBefore(oldestOrder)) continue;
                oldestOrder = acmeOrder.getNotBefore();
            }
            acmeAccount.setCreatedOn(oldestOrder);
            this.acmeAccountRepository.save((Object)acmeAccount);
            this.LOG.info("CreatedOn date updated for acme account {} ", (Object)acmeAccount.getAccountId());
            if (count++ <= this.maxRecordsPerTransaction) continue;
            this.LOG.info("limited AcmeAccount processing to {} per call", (Object)this.maxRecordsPerTransaction);
            break;
        }
        if (count > 0) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeAcountCreatedOnUpdated(count));
            this.LOG.info("AcmeAccount createdOn update of {} accounts", (Object)count);
        }
    }
}

