/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class DaoAuthenticationProviderWrapper
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DaoAuthenticationProviderWrapper.class);
    private final DaoAuthenticationProvider daoAuthenticationProvider;

    public DaoAuthenticationProviderWrapper(DaoAuthenticationProvider daoAuthenticationProvider) {
        this.daoAuthenticationProvider = daoAuthenticationProvider;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        LOG.debug("DaoAuthenticationProviderWrapper.authenticate got {}", (Object)authentication);
        Authentication auth = this.daoAuthenticationProvider.authenticate(authentication);
        LOG.debug("DaoAuthenticationProviderWrapper.authenticate returns {}", (Object)auth);
        return auth;
    }

    public boolean supports(Class<?> authentication) {
        boolean isSuported = this.daoAuthenticationProvider.supports(authentication);
        LOG.debug("DaoAuthenticationProviderWrapper.supports returns {} for {}", (Object)isSuported, authentication);
        return isSuported;
    }
}

