/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.RDN;
import de.trustable.ca3s.core.repository.RDNRepository;
import de.trustable.ca3s.core.service.RDNService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RDNServiceImpl
implements RDNService {
    private final Logger log = LoggerFactory.getLogger(RDNServiceImpl.class);
    private final RDNRepository rDNRepository;

    public RDNServiceImpl(RDNRepository rDNRepository) {
        this.rDNRepository = rDNRepository;
    }

    public RDN save(RDN rDN) {
        this.log.debug("Request to save RDN : {}", (Object)rDN);
        return (RDN)this.rDNRepository.save((Object)rDN);
    }

    @Transactional(readOnly=true)
    public List<RDN> findAll() {
        this.log.debug("Request to get all RDNS");
        return this.rDNRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<RDN> findOne(Long id) {
        this.log.debug("Request to get RDN : {}", (Object)id);
        return this.rDNRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete RDN : {}", (Object)id);
        this.rDNRepository.deleteById((Object)id);
    }
}

