/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.enumeration.ChallengeStatus;
import de.trustable.ca3s.core.repository.AcmeChallengeRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.acme.ChallengeResponse;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.AcmeOrderUtil;
import de.trustable.ca3s.core.service.util.AcmeUtil;
import de.trustable.ca3s.core.service.util.PreferenceUtil;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import de.trustable.ca3s.core.web.rest.data.AcmeChallengeValidation;
import de.trustable.ca3s.core.web.rest.util.RateLimiter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.transaction.Transactional;
import javax.validation.constraints.NotNull;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.bouncycastle.asn1.ASN1OctetString;
import org.jose4j.jwt.consumer.JwtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

/*
 * Exception performing whole class analysis ignored.
 */
@Transactional(dontRollbackOn={AcmeProblemException.class})
@RestController
@RequestMapping(value={"/acme/{realm}/challenge"})
public class ChallengeController
extends AcmeController {
    private static final Logger LOG = LoggerFactory.getLogger(ChallengeController.class);
    public static final Name ACME_CHALLENGE_PREFIX = Name.fromConstantString((String)"_acme-challenge");
    public static final String ACME_VALIDATION_OID = "1.3.6.1.5.5.7.1.31";
    public static final String ACME_TLS_1_PROTOCOL = "acme-tls/1";
    @Value(value="${ca3s.acme.reject.get:true}")
    boolean rejectGet;
    private final AcmeChallengeRepository challengeRepository;
    private final PreferenceUtil preferenceUtil;
    private final SimpleResolver dnsResolver;
    private final AuditService auditService;
    private final AcmeOrderUtil acmeOrderUtil;
    private final RateLimiter rateLimiter;

    public ChallengeController(AcmeChallengeRepository challengeRepository, PreferenceUtil preferenceUtil, AuditService auditService, @Value(value="${ca3s.dns.server:}") String resolverHost, @Value(value="${ca3s.dns.port:53}") int resolverPort, AcmeOrderUtil acmeOrderUtil, @Value(value="${ca3s.acme.ratelimit.second:0}") int rateSec, @Value(value="${ca3s.acme.ratelimit.minute:20}") int rateMin, @Value(value="${ca3s.acme.ratelimit.hour:0}") int rateHour) throws UnknownHostException {
        this.challengeRepository = challengeRepository;
        this.preferenceUtil = preferenceUtil;
        this.auditService = auditService;
        this.acmeOrderUtil = acmeOrderUtil;
        this.dnsResolver = new SimpleResolver(resolverHost);
        this.dnsResolver.setPort(resolverPort);
        LOG.info("Applying default DNS resolver {}", (Object)this.dnsResolver.getAddress());
        this.rateLimiter = new RateLimiter("Challenge", rateSec, rateMin, rateHour);
    }

    @RequestMapping(value={"/{challengeId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<?> getChallenge(@PathVariable long challengeId, @PathVariable String realm, @RequestHeader(value="X-CA3S-Forwarded-Host", required=false) String forwardedHost) {
        LOG.debug("Received Challenge request ");
        this.rateLimiter.checkRateLimit(challengeId, realm);
        HttpHeaders additionalHeaders = this.buildNonceHeader();
        if (this.rejectGet) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).headers(additionalHeaders)).build();
        }
        Optional challengeOpt = this.challengeRepository.findById((Object)challengeId);
        if (!challengeOpt.isPresent()) {
            return ResponseEntity.notFound().headers(additionalHeaders).build();
        }
        AcmeChallenge challengeDao = (AcmeChallenge)challengeOpt.get();
        LOG.debug("returning challenge {}", (Object)challengeDao.getId());
        ChallengeResponse challenge = this.buildChallengeResponse(challengeDao, this.getEffectiveUriComponentsBuilder(realm, forwardedHost));
        if (challengeDao.getStatus() == ChallengeStatus.VALID) {
            URI authUri = this.locationUriOfAuthorization(challengeDao.getAcmeAuthorization().getAcmeAuthorizationId().longValue(), this.getEffectiveUriComponentsBuilder(realm, forwardedHost));
            additionalHeaders.set("Link", "<" + authUri.toASCIIString() + ">;rel=\"up\"");
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)challenge);
    }

    @RequestMapping(value={"/{challengeId}"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/jose+json"})
    public ResponseEntity<?> postChallenge(@RequestBody String requestBody, @PathVariable long challengeId, @PathVariable String realm, @RequestHeader(value="X-CA3S-Forwarded-Host", required=false) String forwardedHost) {
        LOG.debug("Received Challenge request ");
        this.rateLimiter.checkRateLimit(challengeId, realm);
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            AcmeAccount acctDao = this.checkJWTSignatureForAccount(context, realm);
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            Optional challengeOpt = this.challengeRepository.findById((Object)challengeId);
            if (!challengeOpt.isPresent()) {
                return ResponseEntity.notFound().headers(additionalHeaders).build();
            }
            AcmeChallenge challengeDao = (AcmeChallenge)challengeOpt.get();
            AcmeOrder order = challengeDao.getAcmeAuthorization().getOrder();
            if (!order.getAccount().getAccountId().equals(acctDao.getAccountId())) {
                LOG.warn("Account of signing key {} does not match account id {} associated to given challenge{}", new Object[]{acctDao.getAccountId(), challengeDao.getAcmeAuthorization().getOrder().getAccount().getAccountId(), challengeId});
                ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "Account / Auth mismatch", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            if (Instant.now().isAfter(order.getExpires())) {
                LOG.debug("order of this challenge {} already expired", (Object)challengeId);
            } else {
                this.isChallengeSolved(challengeDao);
            }
            ChallengeResponse challengeResponse = this.buildChallengeResponse(challengeDao, this.getEffectiveUriComponentsBuilder(realm, forwardedHost));
            URI authUri = this.locationUriOfAuthorization(challengeDao.getAcmeAuthorization().getAcmeAuthorizationId().longValue(), this.getEffectiveUriComponentsBuilder(realm, forwardedHost));
            additionalHeaders.set("Link", "<" + authUri.toASCIIString() + ">;rel=\"up\"");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)challengeResponse);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }

    public boolean isChallengeSolved(AcmeChallenge challengeDao) {
        boolean useProxy = challengeDao.getAcmeAuthorization().getOrder().getAttributes().stream().anyMatch(att -> "REQUEST_PROXY_ID_USED".equals(att.getName()));
        LOG.debug("useProxy: {}", (Object)useProxy);
        if (useProxy) {
            LOG.debug("challenge {} may be validated by proxy", (Object)challengeDao.getId());
            return false;
        }
        boolean solved = this.checkChallenge(challengeDao);
        if (solved) {
            LOG.debug("validation of challenge {} of type '{}' succeeded", (Object)challengeDao.getId(), (Object)challengeDao.getType());
        } else {
            LOG.warn("validation of challenge {} of type '{}' failed", (Object)challengeDao.getId(), (Object)challengeDao.getType());
        }
        return solved;
    }

    public boolean checkChallenge(AcmeChallenge challengeDao) {
        ChallengeStatus oldChallengeState;
        LOG.debug("checking challenge {}", (Object)challengeDao.getId());
        boolean solved = false;
        String lastError = challengeDao.getLastError();
        ChallengeStatus newChallengeState = null;
        if ("http-01".equals(challengeDao.getType())) {
            if (this.checkChallengeHttp(challengeDao)) {
                newChallengeState = ChallengeStatus.VALID;
                solved = true;
            } else {
                newChallengeState = ChallengeStatus.PENDING;
            }
        } else if ("dns-01".equals(challengeDao.getType())) {
            if (this.checkChallengeDNS(challengeDao)) {
                newChallengeState = ChallengeStatus.VALID;
                solved = true;
            } else {
                newChallengeState = ChallengeStatus.PENDING;
            }
        } else if ("tls-alpn-01".equals(challengeDao.getType())) {
            if (this.checkChallengeALPN(challengeDao)) {
                newChallengeState = ChallengeStatus.VALID;
                solved = true;
            } else {
                newChallengeState = ChallengeStatus.PENDING;
            }
        } else {
            LOG.warn("Unexpected type '{}' of challenge{}", (Object)challengeDao.getType(), (Object)challengeDao.getId());
        }
        if (newChallengeState != null && !(oldChallengeState = challengeDao.getStatus()).equals((Object)newChallengeState)) {
            challengeDao.setStatus(newChallengeState);
            challengeDao.setValidated(Instant.now());
            this.challengeRepository.save((Object)challengeDao);
            LOG.debug("{} challengeDao set to '{}' at {}", new Object[]{challengeDao.getType(), challengeDao.getStatus().toString(), challengeDao.getValidated()});
        }
        if (!Objects.equals(lastError, challengeDao.getLastError())) {
            this.challengeRepository.save((Object)challengeDao);
            LOG.debug("challenge's  #{}' last error set to '{}'", (Object)challengeDao.getId(), (Object)challengeDao.getLastError());
        }
        this.acmeOrderUtil.alignOrderState(challengeDao.getAcmeAuthorization().getOrder());
        return solved;
    }

    private boolean checkChallengeDNS(AcmeChallenge challengeDao) {
        Name nameToLookup;
        String identifierValue = challengeDao.getValue();
        String expectedContent = this.buildKeyAuthorizationHashBase64(challengeDao);
        LOG.info("DNS lookup: expectedContent '{}'", (Object)expectedContent);
        try {
            Name nameOfIdentifier = Name.fromString((String)identifierValue, (Name)Name.root);
            nameToLookup = Name.concatenate((Name)ACME_CHALLENGE_PREFIX, (Name)nameOfIdentifier);
        }
        catch (NameTooLongException | TextParseException e) {
            throw new RuntimeException(identifierValue + " invalid", e);
        }
        Lookup lookupOperation = new Lookup(nameToLookup, 16);
        lookupOperation.setResolver((Resolver)this.dnsResolver);
        lookupOperation.setCache(null);
        LOG.info("DNS lookup: {} records of '{}' (via resolver '{}')", new Object[]{Type.string((int)16), nameToLookup, this.dnsResolver.getAddress()});
        Instant startedAt = Instant.now();
        Object[] lookupResult = lookupOperation.run();
        Duration lookupDuration = Duration.between(startedAt, Instant.now());
        LOG.info("DNS lookup yields: {} (took {})", (Object)Arrays.toString(lookupResult), (Object)lookupDuration);
        List retrievedToken = this.extractTokenFrom((Record[])lookupResult);
        if (retrievedToken.isEmpty()) {
            String msg = "Found no DNS entry solving '" + identifierValue + "'";
            LOG.info(msg);
            challengeDao.setLastError(msg);
            return false;
        }
        boolean matchingDnsEntryFound = retrievedToken.stream().anyMatch(expectedContent::equals);
        this.logChallengeValidationOutcome(matchingDnsEntryFound, challengeDao, "dns challenge response matches for host '" + identifierValue + "'", "dns challenge response mismatch for host '" + identifierValue + "'");
        if (matchingDnsEntryFound) {
            return true;
        }
        String msg = "Did not find matching token '" + expectedContent + "' in TXT record DNS response";
        LOG.info(msg);
        challengeDao.setLastError(msg);
        return false;
    }

    private void logChallengeValidationOutcome(boolean matches, AcmeChallenge challengeDao, String matchMsg, String mismatchMsg) {
        AcmeOrder acmeOrder = challengeDao.getAcmeAuthorization().getOrder();
        if (matches) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeChallengeSucceeded(acmeOrder.getAccount(), acmeOrder, matchMsg));
        } else {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeChallengeFailed(acmeOrder.getAccount(), acmeOrder, mismatchMsg));
            LOG.info(mismatchMsg);
            challengeDao.setLastError(mismatchMsg);
        }
    }

    @NotNull
    private List<String> extractTokenFrom(Record[] lookupResult) {
        ArrayList<String> tokenList = new ArrayList<String>();
        if (lookupResult != null) {
            for (Record record : lookupResult) {
                LOG.debug("Found DNS entry solving '{}'", (Object)record);
                tokenList.addAll(((TXTRecord)record).getStrings());
            }
        }
        return tokenList;
    }

    private boolean checkChallengeHttp(AcmeChallenge challengeDao) {
        int[] ports = new int[]{80, 5544, 8800};
        long timeoutMilliSec = this.preferenceUtil.getAcmeHTTP01TimeoutMilliSec();
        String portList = this.preferenceUtil.getAcmeHTTP01CallbackPorts();
        if (portList != null && !portList.trim().isEmpty()) {
            String[] parts = portList.split(",");
            ports = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                ports[i] = -1;
                try {
                    ports[i] = Integer.parseInt(parts[i].trim());
                    LOG.debug("checkChallengeHttp port number '" + ports[i] + "' configured for HTTP callback");
                    continue;
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("checkChallengeHttp port number parsing fails for '" + ports[i] + "', ignoring", (Throwable)nfe);
                }
            }
        }
        AcmeOrder acmeOrder = challengeDao.getAcmeAuthorization().getOrder();
        String token = challengeDao.getToken();
        String expectedContent = this.buildKeyAuthorization(challengeDao);
        String fileNamePath = "/.well-known/acme-challenge/" + token;
        String host = challengeDao.getAcmeAuthorization().getValue();
        for (int port : ports) {
            String msg;
            try {
                URL url = new URL("http", host, port, fileNamePath);
                LOG.debug("Opening connection to  : " + url);
                CloseableHttpClient instance = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
                HttpGet request = new HttpGet(url.toString());
                request.addHeader("User-Agent", "CA3S_ACME");
                RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((int)timeoutMilliSec).setConnectTimeout((int)timeoutMilliSec).setSocketTimeout((int)timeoutMilliSec).build();
                request.setConfig(requestConfig);
                HttpResponse response = instance.execute((HttpUriRequest)request);
                int responseCode = response.getStatusLine().getStatusCode();
                LOG.debug("\nSending 'GET' request to URL : " + url);
                LOG.debug("Response Code : " + responseCode);
                if (responseCode == 200) {
                    String actualContent = this.readChallengeResponse(response.getEntity().getContent());
                    LOG.debug("expected content: '{}'", (Object)expectedContent);
                    boolean matches = expectedContent.equals(actualContent);
                    this.logChallengeValidationOutcome(matches, challengeDao, "http challenge response matches at host '" + host + ":" + port + "'", "http challenge response mismatch at host '" + host + ":" + port + "'");
                    return matches;
                }
                String msg2 = "read challenge responded with unexpected code : " + responseCode;
                LOG.info(msg2);
                challengeDao.setLastError(msg2);
            }
            catch (UnknownHostException uhe) {
                msg = "unable to resolve hostname: '" + host + "'";
                LOG.info(msg);
                challengeDao.setLastError(msg);
                return false;
            }
            catch (SocketTimeoutException | ConnectTimeoutException ste) {
                msg = "timeout connecting to " + host + ":" + port + " for challenge id " + challengeDao.getId();
                LOG.info(msg);
                challengeDao.setLastError(msg);
            }
            catch (IOException ioe) {
                msg = "problem reading challenge response on " + host + ":" + port + " for challenge id " + challengeDao.getId() + " : " + ioe.getMessage();
                LOG.info(msg);
                challengeDao.setLastError(msg);
                LOG.debug("exception occurred reading challenge response", (Throwable)ioe);
            }
        }
        return false;
    }

    private String readChallengeResponse(HttpURLConnection con) throws IOException {
        return this.readChallengeResponse(con.getInputStream());
    }

    private String readChallengeResponse(InputStream is) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
            if (response.length() <= 1000) continue;
            LOG.debug("limiting read of challenge response to 1000 characters.");
            break;
        }
        in.close();
        String actualContent = response.toString().trim();
        if (actualContent.length() > 100) {
            LOG.debug("read challenge response (truncated): " + actualContent.substring(0, 100) + " ...");
        } else {
            LOG.debug("read challenge response: " + actualContent);
        }
        return actualContent;
    }

    private boolean checkChallengeALPN(AcmeChallenge challengeDao) {
        int[] ports = new int[]{443, 8443};
        AcmeOrder acmeOrder = challengeDao.getAcmeAuthorization().getOrder();
        String expectedContent = this.buildKeyAuthorizationHashBase64(challengeDao);
        String host = challengeDao.getAcmeAuthorization().getValue();
        TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
        for (int port : ports) {
            String msg;
            try {
                if (!this.validateALPNChallenge(challengeDao, expectedContent, host, trustAllCerts, port)) continue;
                LOG.debug("alpn challenge validation successful on '" + host + ":" + port + "' ");
                return true;
            }
            catch (UnknownHostException uhe) {
                msg = "unable to resolve hostname: '" + host + "'";
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeChallengeFailed(acmeOrder.getAccount(), acmeOrder, msg));
                LOG.info(msg);
                challengeDao.setLastError(msg);
                return false;
            }
            catch (IOException ioe) {
                msg = "problem reading alpn certificate on " + host + ":" + port + " for challenge id " + challengeDao.getId() + " : " + ioe.getMessage();
                LOG.info(msg);
                challengeDao.setLastError(msg);
                LOG.debug("exception occurred reading challenge response", (Throwable)ioe);
            }
            catch (CertificateException ce) {
                msg = "problem reading alpn challenge response in certificate provided by " + host + ":" + port + " for challenge id " + challengeDao.getId() + " : " + ce.getMessage();
                LOG.info(msg);
                challengeDao.setLastError(msg);
                LOG.debug("exception occurred reading alpn challenge response certificate", (Throwable)ce);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateALPNChallenge(AcmeChallenge challengeDao, String expectedContent, String host, TrustManager[] trustAllCerts, int port) throws IOException, CertificateException {
        ByteArrayInputStream in;
        String msg;
        Certificate[] serverCerts;
        LOG.debug("Opening ALPN connection to {}:{} ", (Object)host, (Object)port);
        try (Socket sslSocket = null;){
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslsf = sslContext.getSocketFactory();
            sslSocket = (SSLSocket)sslsf.createSocket(host, port);
            SSLParameters sslp = ((SSLSocket)sslSocket).getSSLParameters();
            SNIHostName serverName = new SNIHostName(host);
            sslp.setServerNames(Collections.singletonList(serverName));
            String[] clientAPs = new String[]{"acme-tls/1"};
            sslp.setApplicationProtocols(clientAPs);
            ((SSLSocket)sslSocket).setSSLParameters(sslp);
            ((SSLSocket)sslSocket).startHandshake();
            String ap = ((SSLSocket)sslSocket).getApplicationProtocol();
            LOG.debug("Application Protocol server side: \"" + ap + "\"");
            serverCerts = ((SSLSocket)sslSocket).getSession().getPeerCertificates();
        }
        if (serverCerts.length == 0) {
            msg = "no certificate available after connection with " + host + ":" + port;
            LOG.info(msg);
            challengeDao.setLastError(msg);
            return false;
        }
        if (serverCerts.length > 1) {
            msg = "more than one (#" + serverCerts.length + ") certificate returned " + host + ":" + port + ", expecting a single selfsigned certificate";
            LOG.info(msg);
            challengeDao.setLastError(msg);
            return false;
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(in = new ByteArrayInputStream(serverCerts[0].getEncoded()));
        if (!ChallengeController.validateALPNCertificate((AcmeChallenge)challengeDao, (String)host, (int)port, (X509Certificate)cert)) {
            return false;
        }
        byte[] acmeValidationExtBytes = cert.getExtensionValue("1.3.6.1.5.5.7.1.31");
        ASN1OctetString octetString = (ASN1OctetString)ASN1OctetString.fromByteArray((byte[])acmeValidationExtBytes);
        ASN1OctetString rfc8737OctetString = (ASN1OctetString)ASN1OctetString.fromByteArray((byte[])octetString.getOctets());
        String actualContent = Base64.getEncoder().encodeToString(rfc8737OctetString.getOctets());
        if (rfc8737OctetString.getOctets().length > 32) {
            String msg2 = "actualContent has unexpected length of rfc8737OctetString : " + rfc8737OctetString.getOctets().length;
            LOG.info(msg2);
            challengeDao.setLastError(msg2);
            return false;
        }
        LOG.debug("read challenge response: " + actualContent);
        LOG.debug("expected content: '{}'", (Object)expectedContent);
        boolean matches = expectedContent.equals(actualContent);
        this.logChallengeValidationOutcome(matches, challengeDao, "alpn challenge response matches at host '" + host + ":" + port + "'", "alpn challenge response mismatch at host '" + host + ":" + port + "'");
        return matches;
    }

    public static boolean validateALPNCertificate(AcmeChallenge challengeDao, String host, int port, X509Certificate cert) throws CertificateParsingException {
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("alpn certificate : {}", (Object)Base64.getEncoder().encodeToString(cert.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                String msg = "Encoding problem parsing ALPN certificate";
                LOG.info(msg);
                challengeDao.setLastError(msg);
                e.printStackTrace();
                return false;
            }
        }
        if (cert.getSubjectAlternativeNames() == null || cert.getSubjectAlternativeNames().isEmpty()) {
            String msg = "no SAN entry available in certificate provided by " + host + ":" + port;
            LOG.info(msg);
            challengeDao.setLastError(msg);
            return false;
        }
        if (cert.getSubjectAlternativeNames().size() > 1) {
            String msg = "more than one SAN entry (#" + cert.getSubjectAlternativeNames().size() + ") included in certificate provided by " + host + ":" + port;
            LOG.info(msg);
            challengeDao.setLastError(msg);
            return false;
        }
        Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
        if (altNames != null) {
            for (List<?> altName : altNames) {
                int altNameType = (Integer)altName.get(0);
                if (2 == altNameType) {
                    String sanValue = "";
                    if (altName.get(1) instanceof String) {
                        sanValue = ((String)altName.get(1)).toLowerCase();
                    } else if (altName.get(1) instanceof byte[]) {
                        sanValue = new String((byte[])altName.get(1)).toLowerCase();
                    }
                    if (host.equalsIgnoreCase(sanValue)) {
                        LOG.debug("SAN entry '{}' machtes expected host '{}'", (Object)sanValue, (Object)host);
                        continue;
                    }
                    String msg = "SAN entry value (" + sanValue + ") in alpn certificate provided by '" + host + ":" + port + "', does not match expected host '" + host + "'";
                    LOG.info(msg);
                    challengeDao.setLastError(msg);
                    return false;
                }
                String msg = "unexpected SAN entry type (" + altNameType + ") in alpn certificate provided by '" + host + ":" + port + "', 'DNS' (2) expected.";
                LOG.info(msg);
                challengeDao.setLastError(msg);
                return false;
            }
        }
        if (!cert.getCriticalExtensionOIDs().contains("1.3.6.1.5.5.7.1.31")) {
            String msg = "ACME validation oid is NOT present and NOT marked as critical in certificate provided by '" + host + ":" + port + "'";
            LOG.info(msg);
            challengeDao.setLastError(msg);
            return false;
        }
        LOG.debug("ACME validation oid is present and marked as critical!");
        return true;
    }

    private String buildKeyAuthorizationHashBase64(AcmeChallenge challengeDao) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.buildKeyAuthorizationHash(challengeDao));
    }

    private byte[] buildKeyAuthorizationHash(AcmeChallenge challengeDao) {
        try {
            return this.cryptoUtil.getSHA256Digest(this.buildKeyAuthorization(challengeDao).getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Hashing challenge data failed", (Throwable)e);
            return new byte[0];
        }
    }

    private String buildKeyAuthorization(AcmeChallenge challengeDao) {
        String token = challengeDao.getToken();
        String pkThumbprint = challengeDao.getAcmeAuthorization().getOrder().getAccount().getPublicKeyHash();
        String authorization = token + "." + pkThumbprint;
        LOG.debug("authorization: {}", (Object)authorization);
        return authorization;
    }

    ChallengeResponse buildChallengeResponse(AcmeChallenge challengeDao, UriComponentsBuilder uriBuilder) {
        return new ChallengeResponse(challengeDao, this.locationUriOfChallenge(challengeDao.getId().longValue(), uriBuilder).toString());
    }

    private URI locationUriOfChallenge(long challengeId, UriComponentsBuilder uriBuilder) {
        return this.challengeResourceUriBuilderFrom(uriBuilder.path("../..")).path("/").path(Long.toString(challengeId)).build().normalize().toUri();
    }

    private URI locationUriOfAuthorization(long authorizationId, UriComponentsBuilder uriBuilder) {
        return this.authorizationResourceUriBuilderFrom(uriBuilder.path("../..")).path("/").path("..").path("/").path(Long.toString(authorizationId)).build().normalize().toUri();
    }

    public ResponseEntity<Void> checkChallengeValidation(AcmeChallengeValidation acmeChallengeValidation) {
        Long challengeId = acmeChallengeValidation.getChallengeId();
        Optional challengeOpt = this.challengeRepository.findByChallengeId(challengeId);
        if (!challengeOpt.isPresent()) {
            LOG.info("challenge validation for unknown challenge id: {}", (Object)challengeId);
            return ResponseEntity.notFound().build();
        }
        AcmeChallenge challengeDao = (AcmeChallenge)challengeOpt.get();
        AcmeOrder order = challengeDao.getAcmeAuthorization().getOrder();
        if (Instant.now().isAfter(order.getExpires())) {
            LOG.info("order of this challenge {} already expired", (Object)challengeId);
            return ResponseEntity.badRequest().build();
        }
        if (!ChallengeStatus.PENDING.equals((Object)challengeDao.getStatus())) {
            LOG.info("challenge has unexpected status '{}' != PENDING", (Object)challengeDao.getStatus());
            return ResponseEntity.badRequest().build();
        }
        if (ChallengeStatus.INVALID.equals((Object)acmeChallengeValidation.getStatus())) {
            challengeDao.setValidated(Instant.now());
            challengeDao.setLastError(acmeChallengeValidation.getError());
            challengeDao.setStatus(ChallengeStatus.INVALID);
            this.challengeRepository.save((Object)challengeDao);
        } else if (ChallengeStatus.VALID.equals((Object)acmeChallengeValidation.getStatus())) {
            challengeDao.setValidated(Instant.now());
            if ("http-01".equals(challengeDao.getType())) {
                String expectedContent = this.buildKeyAuthorization(challengeDao);
                if (Arrays.stream(acmeChallengeValidation.getResponses()).anyMatch(expectedContent::equals)) {
                    LOG.info("proxy validated http-01 challenge id '{}' successfully", (Object)challengeDao.getId());
                    challengeDao.setStatus(ChallengeStatus.VALID);
                } else {
                    LOG.info("proxy failed validation of http-01 challenge id '{}'", (Object)challengeDao.getId());
                }
            } else if ("dns-01".equals(challengeDao.getType())) {
                String expectedContent = this.buildKeyAuthorizationHashBase64(challengeDao);
                if (Arrays.stream(acmeChallengeValidation.getResponses()).anyMatch(expectedContent::equals)) {
                    LOG.info("proxy validated dns-01 challenge id '{}' successfully", (Object)challengeDao.getId());
                    challengeDao.setStatus(ChallengeStatus.VALID);
                } else {
                    LOG.info("proxy failed validation of http-01 challenge id '{}'", (Object)challengeDao.getId());
                }
            } else if ("tls-alpn-01".equals(challengeDao.getType())) {
                String expectedContent = this.buildKeyAuthorizationHashBase64(challengeDao);
                if (Arrays.stream(acmeChallengeValidation.getResponses()).anyMatch(expectedContent::equals)) {
                    LOG.info("proxy validated alpn-01 challenge id '{}' successfully", (Object)challengeDao.getId());
                    challengeDao.setStatus(ChallengeStatus.VALID);
                } else {
                    LOG.info("proxy failed validation of http-01 challenge id '{}'", (Object)challengeDao.getId());
                }
            } else {
                LOG.warn("Unexpected type '{}' of challenge{}", (Object)challengeDao.getType(), (Object)challengeDao.getId());
            }
            this.challengeRepository.save((Object)challengeDao);
            this.acmeOrderUtil.alignOrderState(order);
        }
        return ResponseEntity.ok().build();
    }
}

