/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.config;

import de.trustable.ca3s.core.config.saml.CustomSAMLBootstrap;
import de.trustable.ca3s.core.security.AuthenticationProviderWrapper;
import de.trustable.ca3s.core.security.DomainUserDetailsService;
import de.trustable.ca3s.core.security.apikey.APIKeyAuthFilter;
import de.trustable.ca3s.core.security.apikey.APIKeyAuthenticationManager;
import de.trustable.ca3s.core.security.apikey.NullAuthFilter;
import de.trustable.ca3s.core.security.jwt.JWTConfigurer;
import de.trustable.ca3s.core.security.jwt.TokenProvider;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.saml.SAMLAuthenticationProvider;
import org.springframework.security.saml.SAMLBootstrap;
import org.springframework.security.saml.SAMLDiscovery;
import org.springframework.security.saml.SAMLEntryPoint;
import org.springframework.security.saml.SAMLLogoutFilter;
import org.springframework.security.saml.SAMLLogoutProcessingFilter;
import org.springframework.security.saml.SAMLProcessingFilter;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.metadata.MetadataGeneratorFilter;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.CorsFilter;
import org.zalando.problem.spring.web.advice.security.SecurityProblemSupport;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
@Import(value={SecurityProblemSupport.class})
@Order(value=2)
public class SecurityConfiguration {
    private final Logger LOG = LoggerFactory.getLogger(SecurityConfiguration.class);
    @Value(value="${server.port:8080}")
    int httpPort;
    @Value(value="${ca3s.tlsAccess.port:0}")
    int tlsPort;
    @Value(value="${ca3s.adminAccess.port:0}")
    int adminPort;
    @Value(value="${ca3s.raAccess.port:0}")
    int raPort;
    @Value(value="${ca3s.acmeAccess.port:0}")
    int acmePort;
    @Value(value="${ca3s.scepAccess.port:0}")
    int scepPort;
    @Value(value="${ca3s.saml.activate:true}")
    private boolean samlActivate;
    @Value(value="${ca3s.saml.sp}")
    private String samlAudience;
    @Autowired
    @Qualifier(value="saml")
    private SavedRequestAwareAuthenticationSuccessHandler samlAuthSuccessHandler;
    @Autowired
    @Qualifier(value="saml")
    private SimpleUrlAuthenticationFailureHandler samlAuthFailureHandler;
    @Autowired
    @Lazy
    private SAMLEntryPoint samlEntryPoint;
    @Autowired
    private SAMLLogoutFilter samlLogoutFilter;
    @Autowired
    private SAMLLogoutProcessingFilter samlLogoutProcessingFilter;
    @Autowired
    private SAMLAuthenticationProvider samlAuthenticationProvider;
    @Autowired
    private ExtendedMetadata extendedMetadata;
    @Autowired
    private KeyManager keyManager;
    @Autowired
    private AuthenticationConfiguration configuration;
    private final TokenProvider tokenProvider;
    private final CorsFilter corsFilter;
    private final SecurityProblemSupport problemSupport;
    private final DomainUserDetailsService userDetailsService;
    private final boolean apiKeyEnabled;
    private final String apiKeyRequestHeader;
    private final String apiKeyAdminValue;

    public SecurityConfiguration(TokenProvider tokenProvider, CorsFilter corsFilter, SecurityProblemSupport problemSupport, DomainUserDetailsService userDetailsService, @Value(value="${ca3s.auth.api-key.enabled:false}") boolean apiKeyEnabled, @Value(value="${ca3s.auth.api-key.auth-token-header-name:X-API-KEY}") String apiKeyRequestHeader, @Value(value="${ca3s.auth.api-key.auth-token-admin:}") String apiKeyAdminValue) {
        this.tokenProvider = tokenProvider;
        this.corsFilter = corsFilter;
        this.problemSupport = problemSupport;
        this.userDetailsService = userDetailsService;
        this.apiKeyEnabled = apiKeyEnabled;
        this.apiKeyRequestHeader = apiKeyRequestHeader;
        this.apiKeyAdminValue = apiKeyAdminValue;
        if (apiKeyAdminValue != null && apiKeyAdminValue.trim().isEmpty()) {
            apiKeyAdminValue = null;
        }
        if (apiKeyAdminValue != null && apiKeyAdminValue.trim().length() < 100) {
            throw new InvalidConfigurationPropertyValueException("ca3s.auth.api-key.auth-token-admin", (Object)apiKeyAdminValue, "API Key too short, at least 100 character required");
        }
    }

    @Bean
    public SAMLDiscovery samlDiscovery() {
        SAMLDiscovery idpDiscovery = new SAMLDiscovery();
        return idpDiscovery;
    }

    public MetadataGenerator metadataGenerator() {
        MetadataGenerator metadataGenerator = new MetadataGenerator();
        metadataGenerator.setEntityId(this.samlAudience);
        metadataGenerator.setExtendedMetadata(this.extendedMetadata);
        metadataGenerator.setIncludeDiscoveryExtension(false);
        metadataGenerator.setKeyManager(this.keyManager);
        return metadataGenerator;
    }

    @Bean
    public static SAMLBootstrap SAMLBootstrap() {
        return new CustomSAMLBootstrap();
    }

    @Bean
    public SAMLProcessingFilter samlWebSSOProcessingFilter(AuthenticationManager authenticationManager) throws Exception {
        SAMLProcessingFilter samlWebSSOProcessingFilter = new SAMLProcessingFilter();
        samlWebSSOProcessingFilter.setAuthenticationManager(authenticationManager);
        samlWebSSOProcessingFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.samlAuthSuccessHandler);
        samlWebSSOProcessingFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.samlAuthFailureHandler);
        return samlWebSSOProcessingFilter;
    }

    @Bean
    public MetadataGeneratorFilter metadataGeneratorFilter() {
        return new MetadataGeneratorFilter(this.metadataGenerator());
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public AuthenticationProvider daoAuthenticationProvider() {
        this.LOG.info("SecurityConfiguration daoAuthenticationProvider()");
        DaoAuthenticationProvider daoAuthenticationProvider = new DaoAuthenticationProvider();
        daoAuthenticationProvider.setPasswordEncoder(this.passwordEncoder());
        daoAuthenticationProvider.setUserDetailsService((UserDetailsService)this.userDetailsService);
        return new AuthenticationProviderWrapper((AuthenticationProvider)daoAuthenticationProvider);
    }

    @Bean
    public AuthenticationManager authManager(HttpSecurity http) throws Exception {
        AuthenticationManagerBuilder authenticationManagerBuilder = (AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class);
        authenticationManagerBuilder.authenticationProvider((AuthenticationProvider)this.samlAuthenticationProvider).authenticationProvider(this.daoAuthenticationProvider());
        return (AuthenticationManager)authenticationManagerBuilder.build();
    }

    @Bean
    public FilterChainProxy samlFilter(AuthenticationManager authenticationManager) throws Exception {
        ArrayList<DefaultSecurityFilterChain> chains = new ArrayList<DefaultSecurityFilterChain>();
        if (this.samlActivate) {
            chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/SSO/**"), new Filter[]{this.samlWebSSOProcessingFilter(authenticationManager)}));
            chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/discovery/**"), new Filter[]{this.samlDiscovery()}));
            chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/login/**"), new Filter[]{this.samlEntryPoint}));
            chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/logout/**"), new Filter[]{this.samlLogoutFilter}));
            chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/SingleLogout/**"), new Filter[]{this.samlLogoutProcessingFilter}));
        }
        return new FilterChainProxy(chains);
    }

    @Bean
    public WebSecurityCustomizer configure() {
        return web -> ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{"/app/**/*.{js,html}"})).antMatchers(new String[]{"/images/*.{jpg,png}"})).antMatchers(new String[]{"/css/*.css"})).antMatchers(new String[]{"/i18n/**"})).antMatchers(new String[]{"/content/**"})).antMatchers(new String[]{"/h2-console/**"})).antMatchers(new String[]{"/swagger-ui/index.html"})).antMatchers(new String[]{"/test/**"});
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        this.LOG.info("SecurityConfiguration.filterChain ");
        if (this.scepPort == 0) {
            this.scepPort = this.httpPort;
        }
        if (this.adminPort == 0) {
            this.adminPort = this.tlsPort;
        }
        if (this.raPort == 0) {
            this.raPort = this.tlsPort;
        }
        if (this.acmePort == 0) {
            this.acmePort = this.tlsPort;
        }
        AuthenticationManager authenticationManager = this.authManager(http);
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).addFilterBefore((Filter)this.corsFilter, UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.apiKeyAuthFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.metadataGeneratorFilter(), ChannelProcessingFilter.class).addFilterAfter((Filter)this.samlFilter(authenticationManager), BasicAuthenticationFilter.class).addFilterBefore((Filter)this.samlFilter(authenticationManager), CsrfFilter.class).exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.problemSupport).and()).headers().contentSecurityPolicy("default-src 'self'; frame-src 'self' data:; script-src 'self' 'unsafe-inline' 'unsafe-eval' https://storage.googleapis.com; style-src 'self' 'unsafe-inline'; img-src 'self' data:; font-src 'self' data:; connect-src 'self' blob: data:").and().referrerPolicy(ReferrerPolicyHeaderWriter.ReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN).and().featurePolicy("geolocation 'none'; midi 'none'; sync-xhr 'none'; microphone 'none'; camera 'none'; magnetometer 'none'; gyroscope 'none'; speaker 'none'; fullscreen 'self'; payment 'none'").and().frameOptions().deny().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{"/api/languages"})).permitAll().antMatchers(new String[]{"/api/account"})).permitAll().antMatchers(new String[]{"/api/saml/jwt"})).permitAll().antMatchers(new String[]{"/api/authenticate"})).permitAll().antMatchers(new String[]{"/api/register"})).permitAll().antMatchers(new String[]{"/api/activate"})).permitAll().antMatchers(new String[]{"/api/authorities"})).permitAll().antMatchers(new String[]{"/api/account/reset-password/init"})).permitAll().antMatchers(new String[]{"/api/account/reset-password/finish"})).permitAll().antMatchers(new String[]{"/api/profile-info"})).permitAll().antMatchers(new String[]{"/api/ui/config"})).permitAll().antMatchers(new String[]{"/api/certificateSelectionAttributes"})).permitAll().antMatchers(new String[]{"/api/pipelineViews"})).permitAll().antMatchers(new String[]{"/api/pipeline-attributes"})).permitAll().antMatchers(new String[]{"/api/pipeline/activeWeb"})).permitAll().antMatchers(new String[]{"/auth"})).permitAll().antMatchers(new String[]{"/saml/SSO"})).permitAll().antMatchers(new String[]{"/saml/**"})).permitAll().antMatchers(new String[]{"/publicapi/**"})).permitAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.raPort, "/api/administerRequest")})).hasAnyAuthority(new String[]{"ROLE_RA", "ROLE_RA_DOMAIN"}).requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/administerRequest")})).hasAnyAuthority(new String[]{"ROLE_ADMIN"}).antMatchers(new String[]{"/api/administerRequest"})).denyAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.raPort, "/api/administerCertificate")})).hasAnyAuthority(new String[]{"ROLE_RA", "ROLE_RA_DOMAIN"}).requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/administerCertificate")})).hasAnyAuthority(new String[]{"ROLE_ADMIN"}).antMatchers(new String[]{"/api/administerCertificate"})).denyAll().antMatchers(new String[]{"/api/cockpit/**"})).permitAll().antMatchers(new String[]{"/api/tasklist/**"})).permitAll().antMatchers(new String[]{"/api/engine/**"})).permitAll().antMatchers(new String[]{"/api/executeProcess/**"})).permitAll().antMatchers(new String[]{"/api/request-proxy-configs/remote-config/*"})).permitAll().antMatchers(new String[]{"/api/acme-challenges/pending/request-proxy-configs/*"})).permitAll().antMatchers(new String[]{"/api/acme-challenges/validation"})).permitAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/acme-accounts")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/acme-authorizations")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/acme-challenges")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/acme-contacts")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/acme-nonces")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/acme-orders")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/certificate-attributes")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/certificates")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/crl-expiration-notifications")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/csr-attributes")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/csrs")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/pipeline-attributes")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/pipelines")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/rdn-attributes")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/rdns")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/request-attributes")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/request-attribute-values")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/timed-element-notifications")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/tenants")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/tenants/*")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/timed-element-notifications")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/timed-element-notifications/*")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/request-proxy-configs")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/crl-expiration-notifications/*")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/bpmn-process-infos")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/audit-traces")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/algorithm-restrictions")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/algorithm-restrictions/*")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/ca-connector-configs")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/ca-connector-configs/*")})).hasAuthority("ROLE_ADMIN").antMatchers(new String[]{"/api/acme-accounts"})).denyAll().antMatchers(new String[]{"/api/acme-authorizations"})).denyAll().antMatchers(new String[]{"/api/acme-challenges"})).denyAll().antMatchers(new String[]{"/api/acme-contacts"})).denyAll().antMatchers(new String[]{"/api/acme-identifiers"})).denyAll().antMatchers(new String[]{"/api/acme-nonces"})).denyAll().antMatchers(new String[]{"/api/acme-orders"})).denyAll().antMatchers(new String[]{"/api/certificate-attributes"})).denyAll().antMatchers(new String[]{"/api/certificates"})).denyAll().antMatchers(new String[]{"/api/crl-expiration-notifications"})).denyAll().antMatchers(new String[]{"/api/csr-attributes"})).denyAll().antMatchers(new String[]{"/api/csrs"})).denyAll().antMatchers(new String[]{"/api/imported-urls"})).denyAll().antMatchers(new String[]{"/api/pipeline-attributes"})).denyAll().antMatchers(new String[]{"/api/pipelines"})).denyAll().antMatchers(new String[]{"/api/rdn-attributes"})).denyAll().antMatchers(new String[]{"/api/rdns"})).denyAll().antMatchers(new String[]{"/api/request-attributes"})).denyAll().antMatchers(new String[]{"/api/request-attribute-values"})).denyAll().antMatchers(new String[]{"/api/timed-element-notifications"})).denyAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.acmePort, "/acme/**")})).permitAll().antMatchers(new String[]{"/acme/**"})).denyAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.scepPort, "/scep/**")})).permitAll().antMatchers(new String[]{"/scep/**"})).denyAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.scepPort, "/ca3sScep/**")})).permitAll().antMatchers(new String[]{"/ca3sScep/**"})).denyAll().antMatchers(new String[]{"/websocket/tracker"})).hasAuthority("ROLE_ADMIN").antMatchers(new String[]{"/websocket/**"})).permitAll().antMatchers(new String[]{"/management/loggers"})).permitAll().antMatchers(new String[]{"/management/audits"})).permitAll().antMatchers(new String[]{"/management/health"})).permitAll().antMatchers(new String[]{"/management/info"})).permitAll().antMatchers(new String[]{"/management/prometheus"})).permitAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/notification/**")})).hasAuthority("ROLE_ADMIN").requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/schedule/**")})).hasAuthority("ROLE_ADMIN").antMatchers(new String[]{"/api/notification/**"})).denyAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/management/**")})).hasAuthority("ROLE_ADMIN").antMatchers(new String[]{"/management/**"})).denyAll().antMatchers(new String[]{"/api/**"})).authenticated().and()).httpBasic().and()).authenticationManager(authenticationManager).apply((SecurityConfigurerAdapter)this.securityConfigurerAdapter());
        this.LOG.info("registered JWT-based configuration ");
        return (SecurityFilterChain)http.build();
    }

    private JWTConfigurer securityConfigurerAdapter() {
        return new JWTConfigurer(this.tokenProvider);
    }

    private AbstractPreAuthenticatedProcessingFilter apiKeyAuthFilter() {
        if (this.apiKeyEnabled) {
            APIKeyAuthFilter filter = new APIKeyAuthFilter(this.apiKeyRequestHeader);
            filter.setAuthenticationManager((AuthenticationManager)new APIKeyAuthenticationManager(this.apiKeyAdminValue));
            this.LOG.info("registered authentication by APIKey");
            return filter;
        }
        this.LOG.info("authentication by APIKey disabled");
        return new NullAuthFilter();
    }

    private RequestMatcher forPortAndPath(int port, @Nonnull String pathPattern) {
        return new AndRequestMatcher(new RequestMatcher[]{this.forPort(port), new AntPathRequestMatcher(pathPattern)});
    }

    private RequestMatcher forPort(int port) {
        return request -> {
            boolean result = port == 0 || port == request.getLocalPort();
            this.LOG.debug("checking local port {} against target port {} evaluates to {}", new Object[]{request.getLocalPort(), port, result});
            return result;
        };
    }
}

