/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service;

import de.trustable.ca3s.core.domain.Authority;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.MailService;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.mail.MessagingException;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;

@Service
public class NotificationService {
    private final Logger LOG = LoggerFactory.getLogger(NotificationService.class);
    private final CertificateRepository certificateRepo;
    private final CSRRepository csrRepo;
    private final UserRepository userRepository;
    private final PipelineUtil pipelineUtil;
    private final CertificateUtil certificateUtil;
    private final MailService mailService;
    private final AuditService auditService;
    private final int nDaysExpiryEE;
    private final int nDaysExpiryCA;
    private final int nDaysPending;
    private final List<Integer> notificationDayList;
    private final List<String> notificationARAAttributes;
    private final boolean notifyUserOnly;

    @Autowired
    public NotificationService(CertificateRepository certificateRepo, CSRRepository csrRepo, UserRepository userRepository, PipelineUtil pipelineUtil, CertificateUtil certificateUtil, MailService mailService, AuditService auditService, @Value(value="${ca3s.schedule.ra-officer-notification.days-before-expiry.ee:30}") int nDaysExpiryEE, @Value(value="${ca3s.schedule.ra-officer-notification.days-before-expiry.ca:90}") int nDaysExpiryCA, @Value(value="${ca3s.schedule.ra-officer-notification.days-pending:30}") int nDaysPending, @Value(value="${ca3s.schedule.requestor.notification.days:30,14,7,6,5,4,3,2,1}") String notificationDays, @Value(value="${ca3s.schedule.requestor.notification.attributes:}") String notificationARAAttributesString, @Value(value="${ca3s.schedule.requestor.notification.user-only:false}") boolean notifyUserOnly) {
        String[] parts;
        this.certificateRepo = certificateRepo;
        this.csrRepo = csrRepo;
        this.userRepository = userRepository;
        this.pipelineUtil = pipelineUtil;
        this.certificateUtil = certificateUtil;
        this.mailService = mailService;
        this.auditService = auditService;
        this.nDaysExpiryEE = nDaysExpiryEE;
        this.nDaysExpiryCA = nDaysExpiryCA;
        this.nDaysPending = nDaysPending;
        this.notifyUserOnly = notifyUserOnly;
        this.notificationDayList = new ArrayList();
        for (String part : parts = notificationDays.split(",")) {
            try {
                this.notificationDayList.add(Integer.parseInt(part));
            }
            catch (NumberFormatException nfe) {
                this.LOG.info("Unexpected value '{}' in 'ca3s.schedule.requestor.notification.days': {}", (Object)part, (Object)nfe.getMessage());
            }
        }
        String[] araParts = notificationARAAttributesString.split(",");
        this.notificationARAAttributes = Arrays.asList(araParts);
    }

    @Transactional
    public int notifyRAOfficerHolderOnExpiry() throws MessagingException {
        return this.notifyRAOfficerHolderOnExpiry(this.findAllRAOfficer("ROLE_RA"), this.findAllRAOfficer("ROLE_RA_DOMAIN"), true);
    }

    @Transactional
    public int notifyRAOfficerHolderOnExpiry(List<User> raOfficerList, List<User> domainOfficerList, boolean logNotification) {
        Instant now;
        Instant after = now = Instant.now();
        Instant beforeCA = now.plus((long)this.nDaysExpiryCA, ChronoUnit.DAYS);
        List expiringCAList = this.certificateRepo.findNonRevokedByTypeAndValidTo(false, after, beforeCA);
        Instant beforeEE = now.plus((long)this.nDaysExpiryEE, ChronoUnit.DAYS);
        List expiringEECertList = this.certificateRepo.findNonRevokedByTypeAndValidTo(true, after, beforeEE);
        Instant relevantPendingStart = now.minus(this.nDaysPending, ChronoUnit.DAYS);
        List pendingCsrList = this.csrRepo.findPendingByDay(relevantPendingStart, now);
        if (expiringEECertList.isEmpty() && pendingCsrList.isEmpty()) {
            this.LOG.info("No expiring certificates in the next {} days / no pending requests requested in the last {} days. No need to send a notification eMail to RA officers", (Object)this.nDaysExpiryEE, (Object)this.nDaysPending);
        } else {
            this.LOG.info("#{} expiring certificate in the next {} days, #{} pending requests issued in the last {} days.", new Object[]{expiringEECertList.size(), this.nDaysExpiryEE, pendingCsrList.size(), this.nDaysPending});
            for (User raOfficer : raOfficerList) {
                Locale locale = Locale.forLanguageTag(raOfficer.getLangKey());
                Context context = new Context(locale);
                context.setVariable("expiringCAList", (Object)expiringCAList);
                context.setVariable("expiringEECertList", (Object)expiringEECertList);
                context.setVariable("pendingCsrList", (Object)pendingCsrList);
                context.setVariable("nDaysPending", (Object)this.nDaysPending);
                context.setVariable("nDaysExpiryEE", (Object)this.nDaysExpiryEE);
                context.setVariable("nDaysExpiryCA", (Object)this.nDaysExpiryCA);
                try {
                    this.mailService.sendEmailFromTemplate(context, raOfficer, null, "mail/pendingReqExpiringCertificateEmail", "email.allExpiringCertificate.subject");
                }
                catch (Throwable throwable) {
                    this.LOG.warn("Problem occurred while sending a notification eMail to RA officer address '" + raOfficer.getEmail() + "'", throwable);
                    if (!logNotification) continue;
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(raOfficer.getEmail()));
                }
            }
            for (User domainOfficer : domainOfficerList) {
                ArrayList<CSR> pendingDomainCsrList = new ArrayList<CSR>();
                for (CSR csr : pendingCsrList) {
                    if (!this.pipelineUtil.isUserValidAsRA(csr.getPipeline(), domainOfficer)) continue;
                    pendingDomainCsrList.add(csr);
                }
                Locale locale = Locale.forLanguageTag(domainOfficer.getLangKey());
                Context context = new Context(locale);
                context.setVariable("expiringCAList", (Object)expiringCAList);
                context.setVariable("expiringEECertList", (Object)expiringEECertList);
                context.setVariable("pendingCsrList", (Object)pendingCsrList);
                context.setVariable("nDaysPending", (Object)this.nDaysPending);
                context.setVariable("nDaysExpiryEE", (Object)this.nDaysExpiryEE);
                context.setVariable("nDaysExpiryCA", (Object)this.nDaysExpiryCA);
                try {
                    this.mailService.sendEmailFromTemplate(context, domainOfficer, null, "mail/pendingReqExpiringCertificateEmail", "email.allExpiringCertificate.subject");
                }
                catch (Throwable throwable) {
                    this.LOG.warn("Problem occurred while sending a notification eMail to RA officer address '" + domainOfficer.getEmail() + "'", throwable);
                    if (!logNotification) continue;
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(domainOfficer.getEmail()));
                }
            }
            if (logNotification) {
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceExpiryNotificationSent(expiringEECertList.size()));
            }
        }
        return expiringEECertList.size();
    }

    @Transactional
    public int notifyRequestorOnExpiry(User testUser, boolean logNotification) {
        int maxExpiry;
        Instant beforeEE;
        Instant now = Instant.now();
        Instant after = now;
        List expiringEECertList = this.certificateRepo.findNonRevokedByTypeAndValidTo(true, after, beforeEE = now.plus((long)(maxExpiry = ((Integer)this.notificationDayList.stream().max(Integer::compareTo).get()).intValue()), ChronoUnit.DAYS));
        if (expiringEECertList.isEmpty()) {
            this.LOG.info("No expiring certificates in the next {} days / no pending requests requested in the last {} days. No need to send a notification eMail to RA officers", (Object)this.nDaysExpiryEE, (Object)this.nDaysPending);
        } else {
            this.LOG.info("#{} expiring certificate in the next {} days.", (Object)expiringEECertList.size(), (Object)maxExpiry);
            HashMap certListGroupedByUser = new HashMap();
            for (Certificate cert : expiringEECertList) {
                int diffDays = (int)ChronoUnit.DAYS.between(now, cert.getValidTo());
                if (!this.notificationDayList.contains(diffDays)) {
                    this.LOG.debug("#{} days until expiry are NOT in the list of notification days.", (Object)diffDays);
                    continue;
                }
                this.LOG.debug("#{} days until expiry are in the list of notification days.", (Object)diffDays);
                if (cert.getCsr() == null || cert.getCsr().getRequestedBy() == null || cert.getCsr().getPipeline() == null) continue;
                if (!PipelineType.WEB.equals((Object)cert.getCsr().getPipeline().getType())) {
                    this.LOG.debug("Non-Web Pipelines will be ignored for notification.");
                    continue;
                }
                this.LOG.debug("Web Pipelines will be processed for notification.");
                Optional optionalUser = this.userRepository.findOneByLogin(cert.getCsr().getRequestedBy());
                if (!optionalUser.isPresent()) continue;
                User user = testUser;
                if (user == null) {
                    user = (User)optionalUser.get();
                }
                if (certListGroupedByUser.containsKey(user)) {
                    ((List)certListGroupedByUser.get(user)).add(cert);
                    continue;
                }
                ArrayList<Certificate> certificateList = new ArrayList<Certificate>();
                certificateList.add(cert);
                certListGroupedByUser.put(user, certificateList);
            }
            for (User requestor : certListGroupedByUser.keySet()) {
                this.LOG.info("#{} expiring certificates for requestor {}.", (Object)((List)certListGroupedByUser.get(requestor)).size(), (Object)requestor.getId());
                Locale locale = Locale.forLanguageTag(requestor.getLangKey());
                Context context = new Context(locale);
                context.setVariable("now", (Object)now);
                context.setVariable("user", (Object)requestor);
                if (this.notifyUserOnly) {
                    this.sentExpiryNotificationUserOnly(logNotification, certListGroupedByUser, requestor, context);
                    continue;
                }
                this.sentExpiryNotificationAllParticipants(logNotification, certListGroupedByUser, requestor, context);
            }
            if (logNotification) {
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceExpiryNotificationSent(expiringEECertList.size()));
            }
        }
        return expiringEECertList.size();
    }

    private void sentExpiryNotificationUserOnly(boolean logNotification, Map<User, List<Certificate>> certListGroupedByUser, User requestor, Context context) {
        block2: {
            context.setVariable("expiringCertList", certListGroupedByUser.get(requestor));
            try {
                this.mailService.sendEmailFromTemplate(context, requestor, null, "mail/expiringUserCertificateEmail", "email.allExpiringCertificate.subject");
            }
            catch (Throwable throwable) {
                this.LOG.warn("Problem occurred while sending a notification eMail to requestor address '" + requestor.getEmail() + "'", throwable);
                if (!logNotification) break block2;
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(requestor.getEmail()));
            }
        }
    }

    private void sentExpiryNotificationAllParticipants(boolean logNotification, Map<User, List<Certificate>> certListGroupedByUser, User requestor, Context context) {
        for (Certificate cert : certListGroupedByUser.get(requestor)) {
            this.LOG.info("sending notification for expiring certificate {} to requestor {}.", (Object)cert.getId(), (Object)requestor.getId());
            ArrayList ccList = new ArrayList();
            if (cert.getCsr() != null && cert.getCsr().getPipeline() != null) {
                Pipeline pipeline = cert.getCsr().getPipeline();
                String additionalEmailRecipients = this.pipelineUtil.getPipelineAttribute(pipeline, "ADDITIONAL_EMAIL_RECIPIENTS", "");
                this.addSplittedString(ccList, additionalEmailRecipients);
                for (String araAttribute : this.notificationARAAttributes) {
                    String emailAttribute = this.certificateUtil.getCertAttribute(cert, "_ARA_" + araAttribute, "");
                    this.addSplittedString(ccList, emailAttribute);
                }
            }
            context.setVariable("expiringCertList", Collections.singletonList(cert));
            try {
                this.mailService.sendEmailFromTemplate(context, requestor, ccList.toArray(new String[0]), "mail/expiringUserCertificateEmail", "email.allExpiringCertificate.subject");
            }
            catch (Throwable throwable) {
                this.LOG.warn("Problem occurred while sending a notification eMail to requestor address '" + requestor.getEmail() + "'", throwable);
                if (!logNotification) continue;
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(requestor.getEmail()));
            }
        }
    }

    private void addSplittedString(List<String> ccList, String additionalEmailRecipients) {
        if (!additionalEmailRecipients.isEmpty()) {
            String[] parts = additionalEmailRecipients.split(", ");
            this.LOG.debug("#{} parts selected from additionalEmailRecipients '{}'.", (Object)parts.length, (Object)additionalEmailRecipients);
            ccList.addAll(Arrays.asList(parts));
        }
    }

    @Transactional
    public void notifyRAOfficerOnUserRevocation(Certificate certificate) {
        this.notifyRAOfficerOnUserRevocation(certificate, this.findAllRAOfficer("ROLE_RA"), this.findAllRAOfficer("ROLE_RA_DOMAIN"), true);
    }

    public void notifyRAOfficerOnUserRevocation(Certificate certificate, List<User> raOfficerList, List<User> domainOfficerList, boolean logNotification) {
        this.LOG.info("certificate revoked by user (certificate # {})", (Object)certificate.getId());
        String revokedByUser = this.certificateUtil.getCertAttribute(certificate, "REVOKED_BY");
        for (User raOfficer : raOfficerList) {
            Locale locale = Locale.forLanguageTag(raOfficer.getLangKey());
            Context context = new Context(locale);
            context.setVariable("cert", (Object)certificate);
            context.setVariable("revokedByUser", (Object)revokedByUser);
            try {
                this.mailService.sendEmailFromTemplate(context, raOfficer, null, "mail/userRevokedCertificateEmail", "email.userRevokedCertificateEmail.subject");
            }
            catch (Throwable throwable) {
                this.LOG.warn("Problem occurred while sending a notification eMail to RA officer address '" + raOfficer.getEmail() + "'", throwable);
            }
        }
        if (certificate.getCsr() != null && certificate.getCsr().getPipeline() != null) {
            Pipeline pipeline = certificate.getCsr().getPipeline();
            for (User domainOfficer : domainOfficerList) {
                if (!this.pipelineUtil.isUserValidAsRA(pipeline, domainOfficer)) continue;
                Locale locale = Locale.forLanguageTag(domainOfficer.getLangKey());
                Context context = new Context(locale);
                context.setVariable("cert", (Object)certificate);
                context.setVariable("revokedByUser", (Object)revokedByUser);
                try {
                    this.mailService.sendEmailFromTemplate(context, domainOfficer, null, "mail/newPendingRequestEmail", "email.newPendingRequestEmail.subject");
                }
                catch (Throwable throwable) {
                    this.LOG.warn("Problem occurred while sending a notification eMail to domain officer address '" + domainOfficer.getEmail() + "'", throwable);
                    if (!logNotification) continue;
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(domainOfficer.getEmail()));
                }
            }
        }
    }

    @Transactional
    public void notifyRAOfficerOnRequest(CSR csr) {
        this.notifyRAOfficerOnRequest(csr, this.findAllRAOfficer("ROLE_RA"), this.findAllRAOfficer("ROLE_RA_DOMAIN"), true);
    }

    public void notifyRAOfficerOnRequest(CSR csr, List<User> raOfficerList, List<User> domainOfficerList, boolean logNotification) {
        Context context;
        Locale locale;
        this.LOG.info("certificate requested, causing a new pending requests (CSR # {})", (Object)csr.getId());
        ArrayList<CSR> newCsrList = new ArrayList<CSR>();
        newCsrList.add(csr);
        for (User raOfficer : raOfficerList) {
            locale = Locale.forLanguageTag(raOfficer.getLangKey());
            context = new Context(locale);
            context.setVariable("newCsrList", newCsrList);
            try {
                this.mailService.sendEmailFromTemplate(context, raOfficer, null, "mail/newPendingRequestEmail", "email.newPendingRequestEmail.subject");
            }
            catch (Throwable throwable) {
                this.LOG.warn("Problem occurred while sending a notification eMail to RA officer address '" + raOfficer.getEmail() + "'", throwable);
            }
        }
        for (User domainOfficer : domainOfficerList) {
            if (!this.pipelineUtil.isUserValidAsRA(csr.getPipeline(), domainOfficer)) continue;
            locale = Locale.forLanguageTag(domainOfficer.getLangKey());
            context = new Context(locale);
            context.setVariable("newCsrList", newCsrList);
            try {
                this.mailService.sendEmailFromTemplate(context, domainOfficer, null, "mail/newPendingRequestEmail", "email.newPendingRequestEmail.subject");
            }
            catch (Throwable throwable) {
                this.LOG.warn("Problem occurred while sending a notification eMail to domain officer address '" + domainOfficer.getEmail() + "'", throwable);
                if (!logNotification) continue;
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(domainOfficer.getEmail()));
            }
        }
    }

    @Async
    public void notifyUserCerificateIssuedAsync(User requestor, Certificate cert, Set<String> additionalEmailSet) {
        try {
            this.notifyUserCerificateIssued(requestor, cert, additionalEmailSet);
        }
        catch (MessagingException e) {
            this.LOG.error("problem sending user notification for issued cert", (Throwable)e);
        }
    }

    @Transactional
    public void notifyUserCerificateIssued(User requestor, Certificate cert, Set<String> additionalEmailSet) throws MessagingException {
        Locale locale = Locale.forLanguageTag(requestor.getLangKey());
        Context context = new Context(locale);
        context.setVariable("certId", (Object)cert.getId());
        context.setVariable("subject", (Object)cert.getSubject());
        context.setVariable("sans", (Object)cert.getSans());
        String downloadFilename = CertificateUtil.getDownloadFilename((Certificate)cert);
        Instant requestedOn = cert.getValidFrom();
        boolean isServersideKeyGeneration = false;
        if (cert.getCsr() != null) {
            requestedOn = cert.getCsr().getRequestedOn();
            isServersideKeyGeneration = cert.getCsr().isServersideKeyGeneration();
        }
        context.setVariable("requestedOn", (Object)requestedOn);
        context.setVariable("isServersideKeyGeneration", (Object)isServersideKeyGeneration);
        context.setVariable("filenameCrt", (Object)(downloadFilename + ".crt"));
        context.setVariable("filenamePem", (Object)(downloadFilename + ".pem"));
        context.setVariable("filenameFullChainPem", (Object)(downloadFilename + ".full.pem"));
        this.mailService.sendEmailFromTemplate(context, requestor, additionalEmailSet.toArray(new String[0]), "mail/acceptedRequestEmail", "email.acceptedRequest.title");
    }

    @Async
    public void notifyUserCerificateRejectedAsync(User requestor, CSR csr) {
        try {
            this.notifyUserCerificateRejected(requestor, csr);
        }
        catch (MessagingException e) {
            this.LOG.error("problem sending user notification for rejected request", (Throwable)e);
        }
    }

    @Transactional
    public void notifyUserCerificateRejected(User requestor, CSR csr) throws MessagingException {
        Locale locale = Locale.forLanguageTag(requestor.getLangKey());
        Context context = new Context(locale);
        context.setVariable("csr", (Object)csr);
        this.mailService.sendEmailFromTemplate(context, requestor, null, "mail/rejectedRequestEmail", "email.request.rejection.title");
    }

    @Async
    public void notifyUserCerificateRevokedAsync(User requestor, Certificate cert, CSR csr) {
        try {
            this.notifyCerificateRevoked(requestor, cert, csr);
        }
        catch (MessagingException e) {
            this.LOG.error("problem sending user notification for revoked certificate", (Throwable)e);
        }
    }

    @Transactional
    public void notifyCerificateRevoked(User requestor, Certificate cert, CSR csr) throws MessagingException {
        Locale locale = Locale.forLanguageTag(requestor.getLangKey());
        Context context = new Context(locale);
        context.setVariable("csr", (Object)csr);
        context.setVariable("cert", (Object)cert);
        String subject = cert.getSubject();
        if (subject == null) {
            subject = "";
        }
        String[] args = new String[]{subject, cert.getSerial(), cert.getIssuer()};
        this.mailService.sendEmailFromTemplate(context, requestor, null, "mail/revokedCertificateEmail", "email.revokedCertificate.title", args);
    }

    private List<User> findAllRAOfficer(String authority) {
        ArrayList<User> raOfficerList = new ArrayList<User>();
        block0: for (User user : this.userRepository.findAll()) {
            for (Authority auth : user.getAuthorities()) {
                this.LOG.debug("user {} {} has role {}", new Object[]{user.getFirstName(), user.getLastName(), auth.getName()});
                if (!authority.equalsIgnoreCase(auth.getName())) continue;
                raOfficerList.add(user);
                this.LOG.debug("found user {} {} having the role of a RA officers", (Object)user.getFirstName(), (Object)user.getLastName());
                continue block0;
            }
        }
        return raOfficerList;
    }
}

