/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Tenant;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.CSRService;
import de.trustable.ca3s.core.service.dto.CSRView;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.service.util.UserUtil;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import tech.jhipster.web.util.HeaderUtil;

@RestController
@RequestMapping(value={"/api"})
public class CSRResource {
    private final Logger log = LoggerFactory.getLogger(CSRResource.class);
    private static final String ENTITY_NAME = "cSR";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final CSRService cSRService;
    private final CSRUtil csrUtil;
    private final PipelineUtil pipelineUtil;
    private final UserRepository userRepository;
    private final UserUtil userUtil;
    private final String certificateStoreIsolation;
    private final boolean doDNSLookup;

    public CSRResource(CSRService cSRService, CSRUtil csrUtil, PipelineUtil pipelineUtil, UserRepository userRepository, UserUtil userUtil, @Value(value="${ca3s.ui.certificate-store.isolation:none}") String certificateStoreIsolation, @Value(value="${ca3s.ui.csr.dnslookup:false}") boolean doDNSLookup) {
        this.cSRService = cSRService;
        this.csrUtil = csrUtil;
        this.pipelineUtil = pipelineUtil;
        this.userRepository = userRepository;
        this.userUtil = userUtil;
        this.certificateStoreIsolation = certificateStoreIsolation;
        this.doDNSLookup = doDNSLookup;
    }

    @PostMapping(value={"/csrs"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<CSR> createCSR(@Valid @RequestBody CSR cSR) throws URISyntaxException {
        this.log.debug("REST request to save CSR : {}", (Object)cSR);
        if (cSR.getId() != null) {
            throw new BadRequestAlertException("A new cSR cannot already have an ID", ENTITY_NAME, "idexists");
        }
        CSR result = this.cSRService.save(cSR);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/csrs/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/csrs"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<CSR> updateCSR(@Valid @RequestBody CSR cSR) throws URISyntaxException {
        this.log.debug("REST request to update CSR : {}", (Object)cSR);
        return ResponseEntity.badRequest().build();
    }

    @GetMapping(value={"/csrs"})
    public List<CSR> getAllCSRS(@RequestParam(required=false) String filter) {
        return Collections.emptyList();
    }

    @GetMapping(value={"/csrView/{id}"})
    @Transactional(readOnly=true)
    public ResponseEntity<CSRView> getCSRView(@PathVariable Long id) {
        this.log.debug("REST request to get CSRView for CSR id : {}", (Object)id);
        Optional cSROptional = this.cSRService.findOne(id);
        if (cSROptional.isPresent()) {
            CSR csr = (CSR)cSROptional.get();
            CSRView csrView = new CSRView(this.csrUtil, csr, this.doDNSLookup);
            User currentUser = this.userUtil.getCurrentUser();
            csrView.setAdministrable(this.pipelineUtil.isUserValidAsRA(csr.getPipeline(), currentUser));
            this.userUtil.addUserDetails(csrView);
            if (csr.getRequestedBy().equals(currentUser.getLogin()) || csrView.getIsAdministrable()) {
                csrView.setCsrBase64(csr.getCsrBase64());
            }
            this.log.debug("returning CSRView for id : {} -> {}", (Object)id, (Object)csrView);
            return ResponseEntity.ok((Object)csrView);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/csrs/{id}"})
    public ResponseEntity<CSR> getCSR(@PathVariable Long id) {
        this.log.debug("REST request to get CSR : {}", (Object)id);
        return ResponseEntity.badRequest().build();
    }

    @DeleteMapping(value={"/csrs/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Void> deleteCSR(@PathVariable Long id) {
        this.log.debug("REST request to delete CSR : {} rejected", (Object)id);
        return ResponseEntity.badRequest().build();
    }

    private void checkTenant(CSR csr) {
        User currentUser;
        Tenant tenant;
        if ("none".equalsIgnoreCase(this.certificateStoreIsolation)) {
            return;
        }
        if (!this.userUtil.isAdministrativeUser() && (tenant = (currentUser = this.userUtil.getCurrentUser()).getTenant()) != null && tenant.getId() != csr.getTenant().getId()) {
            this.log.info("user [{}] tried to download csr [{}] of tenant [{}]", new Object[]{currentUser.getLogin(), csr.getId(), tenant.getLongname()});
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND);
        }
    }
}

