/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.service.dto.acme.DirectoryResponse;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/acme/{realm}/directory"})
public class DirectoryController
extends AcmeController {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryController.class);

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public DirectoryResponse getDirectory(@PathVariable String realm, @RequestHeader(value="X-CA3S-Forwarded-Host", required=false) String forwardedHost) {
        this.getPipelineForRealm(realm);
        DirectoryResponse resp = new DirectoryResponse();
        resp.setNewNonceUri(this.newNonceResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).build().normalize().toUri());
        resp.setNewAccountUri(this.newAccountResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).build().normalize().toUri());
        resp.setNewOrderUri(this.newOrderResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).build().normalize().toUri());
        resp.setNewAuthzUri(this.newAuthorizationResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).build().normalize().toUri());
        resp.setRevokeUri(this.revokeResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).build().normalize().toUri());
        resp.setKeyChangeUri(this.keyChangeResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).build().normalize().toUri());
        LOG.info("directory request, returning {}", (Object)resp);
        return resp;
    }
}

