/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.CsrUsage;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.exception.CAFailureException;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.NotificationService;
import de.trustable.ca3s.core.service.badkeys.BadKeysResult;
import de.trustable.ca3s.core.service.badkeys.BadKeysService;
import de.trustable.ca3s.core.service.dto.KeyAlgoLengthOrSpec;
import de.trustable.ca3s.core.service.dto.NamedValues;
import de.trustable.ca3s.core.service.dto.PipelineView;
import de.trustable.ca3s.core.service.dto.Preferences;
import de.trustable.ca3s.core.service.dto.TypedValue;
import de.trustable.ca3s.core.service.util.CertificateProcessingUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.service.util.PreferenceUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.ca3s.core.service.util.UserUtil;
import de.trustable.ca3s.core.web.rest.data.CreationMode;
import de.trustable.ca3s.core.web.rest.data.PKCSDataType;
import de.trustable.ca3s.core.web.rest.data.Pkcs10RequestHolderShallow;
import de.trustable.ca3s.core.web.rest.data.PkcsXXData;
import de.trustable.ca3s.core.web.rest.data.UploadPrecheckData;
import de.trustable.ca3s.core.web.rest.data.X509CertificateHolderShallow;
import de.trustable.util.CryptoUtil;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.security.spec.AlgorithmParameterSpec;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.validation.Valid;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jcajce.interfaces.EdDSAPrivateKey;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.pqc.jcajce.provider.dilithium.BCDilithiumPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.falcon.BCFalconPrivateKey;
import org.bouncycastle.pqc.jcajce.spec.DilithiumParameterSpec;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ContentUploadProcessor {
    private final Logger LOG = LoggerFactory.getLogger(ContentUploadProcessor.class);
    private final CryptoUtil cryptoUtil;
    private final ProtectedContentUtil protUtil;
    private final CertificateUtil certUtil;
    private final CSRRepository csrRepository;
    private final CertificateRepository certificateRepository;
    private final UserUtil userUtil;
    private final PipelineRepository pipelineRepository;
    private final PipelineUtil pipelineUtil;
    private final PreferenceUtil preferenceUtil;
    private final CertificateProcessingUtil cpUtil;
    private final NotificationService notificationService;
    private final BadKeysService badKeysService;
    private final AuditService auditService;
    private final String pkcs12SecretRegexp;
    private final Pattern pkcs12SecretPattern;
    private static final String SIGNATURE_ALG = "SHA256withRSA";
    private static final String EC_SIGNATURE_ALG = "SHA256withECDSA";
    private static final String ED25519_SIGNATURE_ALG = "ed25519";
    static HashMap<String, ASN1ObjectIdentifier> nameOIDMap = new HashMap();
    static HashMap<String, Integer> nameGeneralNameMap = new HashMap();

    public ContentUploadProcessor(CryptoUtil cryptoUtil, ProtectedContentUtil protUtil, CertificateUtil certUtil, CSRRepository csrRepository, CertificateRepository certificateRepository, UserUtil userUtil, PipelineRepository pipelineRepository, PipelineUtil pipelineUtil, PreferenceUtil preferenceUtil, CertificateProcessingUtil cpUtil, NotificationService notificationService, BadKeysService badKeysService, AuditService auditService, @Value(value="${ca3s.pkcs12.secret.regexp:^(?=.*\\d)(?=.*[a-z]).{6,100}$}") String pkcs12SecretRegexp) {
        this.cryptoUtil = cryptoUtil;
        this.protUtil = protUtil;
        this.certUtil = certUtil;
        this.csrRepository = csrRepository;
        this.certificateRepository = certificateRepository;
        this.userUtil = userUtil;
        this.pipelineRepository = pipelineRepository;
        this.pipelineUtil = pipelineUtil;
        this.preferenceUtil = preferenceUtil;
        this.cpUtil = cpUtil;
        this.notificationService = notificationService;
        this.badKeysService = badKeysService;
        this.auditService = auditService;
        this.pkcs12SecretRegexp = pkcs12SecretRegexp;
        this.pkcs12SecretPattern = Pattern.compile(pkcs12SecretRegexp);
    }

    @PostMapping(value={"/uploadContent"})
    @Transactional(noRollbackFor={CAFailureException.class})
    public ResponseEntity<PkcsXXData> uploadContent(@Valid @RequestBody UploadPrecheckData uploaded) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String requestorName = auth.getName();
        CreationMode creationMode = uploaded.getCreationMode();
        if (CreationMode.COMMANDLINE_TOOL.equals((Object)creationMode)) {
            this.LOG.debug("not supported creation mode {}, requested by user '{}' ", (Object)creationMode, (Object)requestorName);
        } else {
            if (CreationMode.SERVERSIDE_KEY_CREATION.equals((Object)creationMode)) {
                Preferences prefs = this.preferenceUtil.getSystemPrefs();
                if (prefs.isServerSideKeyCreationAllowed()) {
                    return this.buildServerSideKeyAndRequest(uploaded, requestorName);
                }
                this.LOG.warn("creating serverside csr not allowed! Requested by user '{}'", (Object)requestorName);
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            if (CreationMode.CSR_AVAILABLE.equals((Object)creationMode)) {
                return this.buildCertificateFromCSR(uploaded, requestorName);
            }
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseEntity<PkcsXXData> buildCertificateFromCSR(UploadPrecheckData uploaded, String requestorName) {
        String content = uploaded.getContent();
        this.LOG.debug("Request to upload a PEM clob : {} by user {}", (Object)content, (Object)requestorName);
        PkcsXXData p10ReqData = new PkcsXXData();
        try {
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(Base64.decode((String)content)));
                content = this.cryptoUtil.x509CertToPem(cert);
                this.LOG.debug("certificate parsed from base64 (non-pem) content");
            }
            catch (IOException | GeneralSecurityException | DecoderException gse) {
                this.LOG.debug("certificate parsing from base64 (non-pem) content failed: " + gse.getMessage());
            }
            X509CertificateHolder certHolder = this.cryptoUtil.convertPemToCertificateHolder(content);
            List certList = this.findCertificateByIssuerSerial(certHolder);
            if (!certList.isEmpty()) {
                this.LOG.info("certificate already present");
                return new ResponseEntity(HttpStatus.CONFLICT);
            }
            if (this.badKeysService.isInstalled()) {
                BadKeysResult badKeysResult = this.badKeysService.checkContent(content);
                p10ReqData.setBadKeysResult(badKeysResult);
                if (badKeysResult.isValid()) {
                    this.LOG.debug("BadKeys is installed and returns OK");
                } else if (badKeysResult.getResponse() != null && badKeysResult.getResponse().getResults() != null && badKeysResult.getResponse().getResults().getResultType() != null) {
                    return new ResponseEntity(HttpStatus.BAD_REQUEST);
                }
            } else {
                this.LOG.debug("BadKeys not installed");
            }
            Certificate cert = this.insertCertificate(content, requestorName);
            p10ReqData = new PkcsXXData(certHolder, content, true);
            this.certUtil.setCertAttribute(cert, "REQUESTOR_NAME", requestorName);
            return new ResponseEntity((Object)p10ReqData, HttpStatus.CREATED);
        }
        catch (DecoderException de) {
            p10ReqData.setDataType(PKCSDataType.UNKNOWN);
            this.LOG.debug("certificate parsing problem of uploaded content:" + de.getMessage());
            return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
        }
        catch (IOException | GeneralSecurityException e) {
            this.LOG.debug("not a certificate, trying to parse it as CSR ");
            try {
                CSR csr;
                PKCS10CertificationRequest pkcs10CertificationRequest;
                try {
                    pkcs10CertificationRequest = new PKCS10CertificationRequest(Base64.decode((String)content));
                    this.LOG.debug("reading binary CSR succeeded");
                }
                catch (IOException | DecoderException e2) {
                    pkcs10CertificationRequest = this.cryptoUtil.convertPemToPKCS10CertificationRequest(content);
                }
                Pkcs10RequestHolder p10ReqHolder = this.cryptoUtil.parseCertificateRequest(pkcs10CertificationRequest);
                List csrList = this.csrRepository.findNonRejectedByPublicKeyHash(p10ReqHolder.getPublicKeyHash());
                this.LOG.debug("public key with hash '{}' already used in #{} CSRs.", (Object)p10ReqHolder.getPublicKeyHash(), (Object)csrList.size());
                Pkcs10RequestHolderShallow p10ReqHolderShallow = new Pkcs10RequestHolderShallow(p10ReqHolder);
                p10ReqData = new PkcsXXData(p10ReqHolderShallow);
                if (this.badKeysService.isInstalled()) {
                    BadKeysResult badKeysResult = this.badKeysService.checkContent(CryptoUtil.pkcs10RequestToPem((PKCS10CertificationRequest)p10ReqHolder.getP10Req()));
                    if (!badKeysResult.isValid()) {
                        this.LOG.debug("badKeysResult '{}'", (Object)badKeysResult.getResponse().getResults().getResultType());
                    } else {
                        this.LOG.debug("BadKeys not installed");
                    }
                    p10ReqData.setBadKeysResult(badKeysResult);
                }
                p10ReqData.setCsrPublicKeyPresentInDB(!csrList.isEmpty());
                if (!csrList.isEmpty()) return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
                Optional optPipeline = this.pipelineRepository.findById((Object)uploaded.getPipelineId());
                if (optPipeline.isPresent()) {
                    ArrayList messageList = new ArrayList();
                    if (!this.pipelineUtil.isPipelineRestrictionsResolved((Pipeline)optPipeline.get(), p10ReqHolder, uploaded.getArAttributes(), messageList)) {
                        p10ReqData.setWarnings(messageList.toArray(new String[0]));
                        return new ResponseEntity((Object)p10ReqData, HttpStatus.BAD_REQUEST);
                    }
                    this.LOG.debug("pipeline restrictions for pipeline '{}' solved", (Object)((Pipeline)optPipeline.get()).getName());
                } else {
                    this.LOG.info("pipeline id '{}' not found", (Object)uploaded.getPipelineId());
                }
                try {
                    csr = this.startCertificateCreationProcess(CryptoUtil.pkcs10RequestToPem((PKCS10CertificationRequest)pkcs10CertificationRequest), p10ReqData, requestorName, uploaded.getRequestorcomment(), uploaded.getArAttributes(), optPipeline);
                }
                catch (CAFailureException caFailureException) {
                    this.LOG.info("problem creating certificate", (Throwable)caFailureException);
                    String[] messages = (String[])ArrayUtils.add((Object[])p10ReqData.getWarnings(), (Object)caFailureException.getMessage());
                    p10ReqData.setWarnings(messages);
                    return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
                }
                if (csr == null) return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
                Certificate cert = csr.getCertificate();
                if (cert == null) return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
                X509CertificateHolder certHolder = this.cryptoUtil.convertPemToCertificateHolder(cert.getContent());
                p10ReqData = new PkcsXXData(certHolder, cert);
                return new ResponseEntity((Object)p10ReqData, HttpStatus.CREATED);
            }
            catch (IOException | GeneralSecurityException e2) {
                this.LOG.debug("describeCSR : " + e2.getMessage());
                this.LOG.debug("not a certificate, not a CSR, trying to parse it as a P12 container");
                try {
                    KeyStore pkcs12Store = KeyStore.getInstance("PKCS12", "BC");
                    ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((String)content));
                    char[] passphrase = new char[]{};
                    if (uploaded.getPassphrase() != null && uploaded.getPassphrase().trim().length() > 0) {
                        passphrase = uploaded.getPassphrase().toCharArray();
                    }
                    pkcs12Store.load(bais, passphrase);
                    this.LOG.debug("keystore loaded successfully!");
                    ArrayList<X509CertificateHolderShallow> certList = new ArrayList<X509CertificateHolderShallow>();
                    Enumeration<String> en = pkcs12Store.aliases();
                    while (true) {
                        Certificate cert;
                        if (!en.hasMoreElements()) {
                            p10ReqData = new PkcsXXData();
                            X509CertificateHolderShallow[] chsArr = new X509CertificateHolderShallow[certList.size()];
                            certList.toArray(chsArr);
                            p10ReqData.setCertsHolder(chsArr);
                            p10ReqData.setDataType(PKCSDataType.CONTAINER);
                            return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
                        }
                        String alias = en.nextElement();
                        this.LOG.debug("iterating keystore, found alias {}, isCertificateEntry {}, isKeyEntry {}", new Object[]{alias, pkcs12Store.isCertificateEntry(alias), pkcs12Store.isKeyEntry(alias)});
                        if (!pkcs12Store.isCertificateEntry(alias) && !pkcs12Store.isKeyEntry(alias)) continue;
                        X509Certificate x509cert = (X509Certificate)pkcs12Store.getCertificate(alias);
                        if (x509cert == null) {
                            this.LOG.debug("alias {} does NOT refer to a certificate entry", (Object)alias);
                            continue;
                        }
                        this.LOG.debug("certificate {} found in PKCS12 for alias '{}'", (Object)x509cert.getSubjectX500Principal().toString(), (Object)alias);
                        String b64Content = this.cryptoUtil.x509CertToPem(x509cert);
                        X509CertificateHolder certHolder = this.cryptoUtil.convertPemToCertificateHolder(b64Content);
                        X509CertificateHolderShallow x509Holder = new X509CertificateHolderShallow(certHolder);
                        x509Holder.setPemCertificate(b64Content);
                        List certListDB = this.findCertificateByIssuerSerial(certHolder);
                        this.LOG.debug("certListDB has # {} item", (Object)certListDB.size());
                        if (!certListDB.isEmpty()) {
                            cert = (Certificate)certListDB.get(0);
                            if (certListDB.size() > 1) {
                                this.LOG.info("problem: found more than one matching certificate for issuer {}, serial {}", (Object)certHolder.getIssuer().toString(), (Object)certHolder.getSerialNumber().toString());
                            }
                        } else {
                            cert = this.insertCertificate(b64Content, requestorName);
                        }
                        x509Holder.setCertificateId(cert.getId().longValue());
                        x509Holder.setCertificatePresentInDB(true);
                        if (uploaded.isImportKey() && pkcs12Store.isKeyEntry(alias)) {
                            Key key = pkcs12Store.getKey(alias, passphrase);
                            this.LOG.debug("key {} found alongside certificate in PKCS12 for alias {}", (Object)"*****", (Object)alias);
                            KeyPair keyPair = new KeyPair(x509cert.getPublicKey(), (PrivateKey)key);
                            this.certUtil.storePrivateKey(cert, keyPair, cert.getValidTo());
                            x509Holder.setKeyPresent(true);
                            this.LOG.debug("key {} stored for certificate {}", (Object)"*****", (Object)cert.getId());
                        }
                        certList.add(x509Holder);
                    }
                }
                catch (IOException ioe) {
                    p10ReqData.setPassphraseRequired(true);
                    p10ReqData.setDataType(PKCSDataType.CONTAINER_REQUIRING_PASSPHRASE);
                    this.LOG.debug("p12 missing a passphrase: " + ioe.getMessage());
                    return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
                }
                catch (DecoderException de) {
                    p10ReqData.setDataType(PKCSDataType.UNKNOWN);
                    this.LOG.debug("p12 parsing problem of uploaded content: " + de.getMessage());
                    return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
                }
                catch (GeneralSecurityException e3) {
                    this.LOG.debug("general problem with uploaded content: " + e3.getMessage());
                    return new ResponseEntity(HttpStatus.BAD_REQUEST);
                }
            }
        }
    }

    @Transactional
    public ResponseEntity<PkcsXXData> buildServerSideKeyAndRequest(UploadPrecheckData uploaded, String requestorName) {
        try {
            CSR csr;
            KeyAlgoLengthOrSpec keyAlgoLengthOrSpec;
            DilithiumParameterSpec parameterSpec;
            JcaContentSignerBuilder csBuilder;
            if (!this.pkcs12SecretPattern.matcher(uploaded.getSecret()).matches()) {
                throw new GeneralSecurityException("PKCS12 secret does not match pattern '" + this.pkcs12SecretRegexp + "'");
            }
            Optional optPipeline = this.pipelineRepository.findById((Object)uploaded.getPipelineId());
            KeyAlgoLengthOrSpec keyAlgoLength = KeyAlgoLengthOrSpec.from((String)uploaded.getKeyAlgoLength());
            KeyPair keypair = this.generateKeyPair(keyAlgoLength);
            NamedValues[] certAttr = uploaded.getCertificateAttributes();
            X500NameBuilder namebuilder = new X500NameBuilder(X500Name.getDefaultStyle());
            ArrayList<GeneralName> gnList = new ArrayList<GeneralName>();
            for (NamedValues nv : certAttr) {
                String name = nv.getName();
                if (nameOIDMap.containsKey(name)) {
                    TypedValue[] oid = (TypedValue[])nameOIDMap.get(name);
                    TypedValue[] typedValueArray = nv.getValues();
                    int n = typedValueArray.length;
                    for (int i = 0; i < n; ++i) {
                        TypedValue typedValue = typedValueArray[i];
                        if (typedValue.getValue() == null || typedValue.getValue().isEmpty()) continue;
                        namebuilder.addRDN((ASN1ObjectIdentifier)oid, typedValue.getValue());
                    }
                    continue;
                }
                if ("SAN".equalsIgnoreCase(name)) {
                    for (TypedValue typedValue : nv.getValues()) {
                        String content = typedValue.getValue().trim();
                        if (content.isEmpty()) continue;
                        Integer sanType = 2;
                        if (nameGeneralNameMap.containsKey(typedValue.getType().toUpperCase())) {
                            sanType = (Integer)nameGeneralNameMap.get(typedValue.getType().toUpperCase());
                        } else {
                            this.LOG.warn("SAN certificate attribute has unknown type '{}'", (Object)typedValue.getType());
                        }
                        gnList.add(new GeneralName(sanType.intValue(), content));
                    }
                    continue;
                }
                this.LOG.warn("certificate attribute '{}' unknown ", (Object)name);
            }
            JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(namebuilder.build(), keypair.getPublic());
            if (!gnList.isEmpty()) {
                GeneralName[] gns = new GeneralName[gnList.size()];
                gnList.toArray(gns);
                GeneralNames subjectAltName = new GeneralNames(gns);
                ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
                extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltName);
                if (optPipeline.isPresent()) {
                    Pipeline p = (Pipeline)optPipeline.get();
                    PipelineView pv = this.pipelineUtil.from(p);
                    if (CsrUsage.TLS_SERVER.equals((Object)pv.getCsrUsage())) {
                        extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(160));
                        extensionsGenerator.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
                    } else if (CsrUsage.TLS_CLIENT.equals((Object)pv.getCsrUsage())) {
                        extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(128));
                        extensionsGenerator.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_clientAuth));
                    } else if (CsrUsage.DOC_SIGNING.equals((Object)pv.getCsrUsage())) {
                        extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(192));
                    } else if (CsrUsage.CODE_SIGNING.equals((Object)pv.getCsrUsage())) {
                        extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(128));
                        extensionsGenerator.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_codeSigning));
                    } else {
                        this.LOG.warn("unexpected CsrUsage found '{}'", (Object)pv.getCsrUsage());
                    }
                }
                p10Builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extensionsGenerator.generate());
            }
            PrivateKey pk = keypair.getPrivate();
            String algo = SIGNATURE_ALG;
            if (pk instanceof ECKey) {
                algo = EC_SIGNATURE_ALG;
                csBuilder = new JcaContentSignerBuilder(algo);
            } else if (pk instanceof EdDSAPrivateKey) {
                algo = ED25519_SIGNATURE_ALG;
                csBuilder = new JcaContentSignerBuilder(algo);
            } else if (pk instanceof BCDilithiumPrivateKey) {
                parameterSpec = ((BCDilithiumPrivateKey)pk).getParameterSpec();
                keyAlgoLengthOrSpec = KeyAlgoLengthOrSpec.from((AlgorithmParameterSpec)parameterSpec);
                csBuilder = keyAlgoLengthOrSpec.buildJcaContentSignerBuilder();
            } else if (pk instanceof BCFalconPrivateKey) {
                parameterSpec = ((BCFalconPrivateKey)pk).getParameterSpec();
                keyAlgoLengthOrSpec = KeyAlgoLengthOrSpec.from((AlgorithmParameterSpec)parameterSpec);
                csBuilder = keyAlgoLengthOrSpec.buildJcaContentSignerBuilder();
            } else {
                csBuilder = new JcaContentSignerBuilder(algo);
            }
            ContentSigner signer = csBuilder.build(pk);
            PKCS10CertificationRequest p10CR = p10Builder.build(signer);
            String csrAsPem = CryptoUtil.pkcs10RequestToPem((PKCS10CertificationRequest)p10CR);
            this.LOG.debug("created csr on behalf of user '{}':\n{}", (Object)requestorName, (Object)csrAsPem);
            Pkcs10RequestHolder p10ReqHolder = this.cryptoUtil.parseCertificateRequest(p10CR);
            Pkcs10RequestHolderShallow p10ReqHolderShallow = new Pkcs10RequestHolderShallow(p10ReqHolder);
            PkcsXXData p10ReqData = new PkcsXXData(p10ReqHolderShallow);
            try {
                csr = this.startCertificateCreationProcess(csrAsPem, p10ReqData, requestorName, uploaded.getRequestorcomment(), uploaded.getArAttributes(), optPipeline);
            }
            catch (CAFailureException caFailureException) {
                this.LOG.info("problem creating certificate", (Throwable)caFailureException);
                String[] messages = (String[])ArrayUtils.add((Object[])p10ReqData.getWarnings(), (Object)caFailureException.getMessage());
                p10ReqData.setWarnings(messages);
                return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
            }
            if (csr != null) {
                csr.setServersideKeyGeneration(Boolean.valueOf(true));
                this.csrRepository.save((Object)csr);
                Instant validTo = Instant.now().plus((long)this.preferenceUtil.getServerSideKeyDeleteAfterDays(), ChronoUnit.DAYS);
                int leftUsages = this.preferenceUtil.getServerSideKeyDeleteAfterUses();
                this.certUtil.storePrivateKey(csr, keypair, leftUsages, validTo);
                this.protUtil.createProtectedContent(uploaded.getSecret(), ProtectedContentType.PASSWORD, ContentRelationType.CSR, csr.getId().longValue(), leftUsages, validTo);
                Certificate cert = csr.getCertificate();
                if (cert != null) {
                    X509CertificateHolder certHolder = this.cryptoUtil.convertPemToCertificateHolder(cert.getContent());
                    p10ReqData = new PkcsXXData(certHolder, cert);
                }
                return new ResponseEntity((Object)p10ReqData, HttpStatus.CREATED);
            }
            this.LOG.warn("problem creating serverside csr object from CSR PEM: \n{}", (Object)csrAsPem);
            return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
        }
        catch (IOException | GeneralSecurityException | OperatorCreationException ex) {
            this.LOG.debug("problem creating serverside csr", ex);
            this.LOG.warn("problem creating serverside csr: " + ex.getMessage());
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    private KeyPair generateKeyPair(KeyAlgoLengthOrSpec keyAlgoLength) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        return keyAlgoLength.generateKeyPair();
    }

    private Certificate insertCertificate(String content, String requestorName) throws GeneralSecurityException, IOException {
        Certificate cert = this.certUtil.createCertificate(content, null, null, false);
        this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificate("MANUAL_CERTIFICATE_IMPORTED", cert));
        this.certUtil.setCertAttribute(cert, "UPLOADED_BY", requestorName);
        this.certificateRepository.save((Object)cert);
        this.LOG.info("created new certificate entry with id {} uploaded by {}", (Object)cert.getId(), (Object)requestorName);
        return cert;
    }

    private CSR startCertificateCreationProcess(String csrAsPem, PkcsXXData p10ReqData, String requestorName, String requestorComment, NamedValues[] nvArr, Optional<Pipeline> optPipeline) {
        if (optPipeline.isPresent()) {
            Pipeline pipeline = optPipeline.get();
            if (pipeline.isActive().booleanValue()) {
                ArrayList messageList = new ArrayList();
                CSR csr = this.cpUtil.buildCSR(csrAsPem, requestorName, "WEB_CERTIFICATE_REQUESTED", requestorComment, pipeline, nvArr, messageList);
                p10ReqData.setWarnings(messageList.toArray(new String[0]));
                if (csr != null) {
                    p10ReqData.setCreatedCSRId(csr.getId().toString());
                    csr.setTenant(this.userUtil.getCurrentUser().getTenant());
                    if (pipeline.isApprovalRequired().booleanValue()) {
                        this.LOG.debug("deferring certificate creation for csr #{}", (Object)csr.getId());
                        p10ReqData.setCsrPending(true);
                        if ("TRUE".equalsIgnoreCase(this.pipelineUtil.getPipelineAttribute(pipeline, "NOTIFY_RA_OFFICER_ON_PENDING", "" + this.preferenceUtil.isNotifyRAOnRequest()))) {
                            this.notificationService.notifyRAOfficerOnRequest(csr);
                        }
                    } else {
                        this.auditService.saveAuditTrace(this.auditService.createAuditTraceWebAutoAccepted(csr));
                        try {
                            this.cpUtil.processCertificateRequest(csr, requestorName, "WEB_CERTIFICATE_CREATED", pipeline);
                        }
                        catch (CAFailureException caFailureException) {
                            this.LOG.info("certificate creation failed", (Throwable)caFailureException);
                            String msg = "certificate creation failed '" + caFailureException.getMessage() + "'!";
                            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrRejected(csr, msg));
                            this.LOG.info(msg);
                        }
                    }
                    return csr;
                }
                this.LOG.warn("startCertificateCreationProcess: creation of CSR failed");
            } else {
                this.LOG.warn("startCertificateCreationProcess: pipeline {} not active", (Object)pipeline.getName());
            }
        } else {
            this.LOG.warn("startCertificateCreationProcess: no processing pipeline defined");
        }
        return null;
    }

    private List<Certificate> findCertificateByIssuerSerial(X509CertificateHolder certHolder) {
        return this.certificateRepository.findByIssuerSerial(certHolder.getIssuer().toString(), certHolder.getSerialNumber().toString());
    }

    static {
        nameOIDMap.put("C", BCStyle.C);
        nameOIDMap.put("CN", BCStyle.CN);
        nameOIDMap.put("O", BCStyle.O);
        nameOIDMap.put("OU", BCStyle.OU);
        nameOIDMap.put("L", BCStyle.L);
        nameOIDMap.put("ST", BCStyle.ST);
        nameOIDMap.put("E", BCStyle.E);
        nameGeneralNameMap.put("DNS-NAME", 2);
        nameGeneralNameMap.put("DNS", 2);
        nameGeneralNameMap.put("IP", 7);
    }
}

