/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.config;

import java.util.Optional;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import tech.jhipster.config.JHipsterProperties;

@Configuration
@EnableWebSocketMessageBroker
public class WebsocketConfiguration
implements WebSocketMessageBrokerConfigurer {
    public static final String IP_ADDRESS = "IP_ADDRESS";
    private final JHipsterProperties jHipsterProperties;

    public WebsocketConfiguration(JHipsterProperties jHipsterProperties) {
        this.jHipsterProperties = jHipsterProperties;
    }

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.enableSimpleBroker(new String[]{"/topic"});
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        String[] allowedOrigins = Optional.ofNullable(this.jHipsterProperties.getCors().getAllowedOrigins()).map(origins -> origins.toArray(new String[0])).orElse(new String[0]);
        registry.addEndpoint(new String[]{"/websocket/tracker"}).setHandshakeHandler((HandshakeHandler)this.defaultHandshakeHandler()).setAllowedOrigins(allowedOrigins).withSockJS().setInterceptors(new HandshakeInterceptor[]{this.httpSessionHandshakeInterceptor()});
    }

    @Bean
    public HandshakeInterceptor httpSessionHandshakeInterceptor() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private DefaultHandshakeHandler defaultHandshakeHandler() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

