/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.RequestAttributeValue;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="request_attribute")
public class RequestAttribute
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @NotNull
    @Column(name="attribute_type", nullable=false)
    private String attributeType;
    @OneToMany(mappedBy="reqAttr")
    private Set<RequestAttributeValue> requestAttributeValues = new HashSet();
    @ManyToOne
    @JsonIgnoreProperties(value={"requestAttributes"})
    private RequestAttributeValue holdingRequestAttribute;
    @ManyToOne
    @JsonIgnoreProperties(value={"ras"})
    private CSR csr;

    public Long getId() {
        return this.id;
    }

    public RequestAttribute id(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public RequestAttribute attributeType(String attributeType) {
        this.setAttributeType(attributeType);
        return this;
    }

    public void setAttributeType(String attributeType) {
        this.attributeType = attributeType;
    }

    public Set<RequestAttributeValue> getRequestAttributeValues() {
        return this.requestAttributeValues;
    }

    public void setRequestAttributeValues(Set<RequestAttributeValue> requestAttributeValues) {
        if (this.requestAttributeValues != null) {
            this.requestAttributeValues.forEach(i -> i.setReqAttr(null));
        }
        if (requestAttributeValues != null) {
            requestAttributeValues.forEach(i -> i.setReqAttr(this));
        }
        this.requestAttributeValues = requestAttributeValues;
    }

    public RequestAttribute requestAttributeValues(Set<RequestAttributeValue> requestAttributeValues) {
        this.setRequestAttributeValues(requestAttributeValues);
        return this;
    }

    public RequestAttribute addRequestAttributeValues(RequestAttributeValue requestAttributeValue) {
        this.requestAttributeValues.add(requestAttributeValue);
        requestAttributeValue.setReqAttr(this);
        return this;
    }

    public RequestAttribute removeRequestAttributeValues(RequestAttributeValue requestAttributeValue) {
        this.requestAttributeValues.remove(requestAttributeValue);
        requestAttributeValue.setReqAttr(null);
        return this;
    }

    public RequestAttributeValue getHoldingRequestAttribute() {
        return this.holdingRequestAttribute;
    }

    public void setHoldingRequestAttribute(RequestAttributeValue requestAttributeValue) {
        this.holdingRequestAttribute = requestAttributeValue;
    }

    public RequestAttribute holdingRequestAttribute(RequestAttributeValue requestAttributeValue) {
        this.setHoldingRequestAttribute(requestAttributeValue);
        return this;
    }

    public CSR getCsr() {
        return this.csr;
    }

    public void setCsr(CSR cSR) {
        this.csr = cSR;
    }

    public RequestAttribute csr(CSR cSR) {
        this.setCsr(cSR);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestAttribute)) {
            return false;
        }
        return this.id != null && this.id.equals(((RequestAttribute)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "RequestAttribute{id=" + this.getId() + ", attributeType='" + this.getAttributeType() + "'}";
    }
}

