/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.repository.CsrAttributeRepository;
import de.trustable.ca3s.core.service.CsrAttributeService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CsrAttributeServiceImpl
implements CsrAttributeService {
    private final Logger log = LoggerFactory.getLogger(CsrAttributeServiceImpl.class);
    private final CsrAttributeRepository csrAttributeRepository;

    public CsrAttributeServiceImpl(CsrAttributeRepository csrAttributeRepository) {
        this.csrAttributeRepository = csrAttributeRepository;
    }

    public CsrAttribute save(CsrAttribute csrAttribute) {
        this.log.debug("Request to save CsrAttribute : {}", (Object)csrAttribute);
        return (CsrAttribute)this.csrAttributeRepository.save((Object)csrAttribute);
    }

    @Transactional(readOnly=true)
    public List<CsrAttribute> findAll() {
        this.log.debug("Request to get all CsrAttributes");
        return this.csrAttributeRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<CsrAttribute> findOne(Long id) {
        this.log.debug("Request to get CsrAttribute : {}", (Object)id);
        return this.csrAttributeRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete CsrAttribute : {}", (Object)id);
        this.csrAttributeRepository.deleteById((Object)id);
    }
}

