/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.TimedElementNotification;
import de.trustable.ca3s.core.repository.TimedElementNotificationRepository;
import de.trustable.ca3s.core.service.TimedElementNotificationService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TimedElementNotificationServiceImpl
implements TimedElementNotificationService {
    private final Logger log = LoggerFactory.getLogger(TimedElementNotificationServiceImpl.class);
    private final TimedElementNotificationRepository timedElementNotificationRepository;

    public TimedElementNotificationServiceImpl(TimedElementNotificationRepository timedElementNotificationRepository) {
        this.timedElementNotificationRepository = timedElementNotificationRepository;
    }

    public TimedElementNotification save(TimedElementNotification timedElementNotification) {
        this.log.debug("Request to save TimedElementNotification : {}", (Object)timedElementNotification);
        return (TimedElementNotification)this.timedElementNotificationRepository.save((Object)timedElementNotification);
    }

    public TimedElementNotification update(TimedElementNotification timedElementNotification) {
        this.log.debug("Request to update TimedElementNotification : {}", (Object)timedElementNotification);
        return (TimedElementNotification)this.timedElementNotificationRepository.save((Object)timedElementNotification);
    }

    public Optional<TimedElementNotification> partialUpdate(TimedElementNotification timedElementNotification) {
        this.log.debug("Request to partially update TimedElementNotification : {}", (Object)timedElementNotification);
        return this.timedElementNotificationRepository.findById((Object)timedElementNotification.getId()).map(existingTimedElementNotification -> {
            if (timedElementNotification.getType() != null) {
                existingTimedElementNotification.setType(timedElementNotification.getType());
            }
            if (timedElementNotification.getNotifyOn() != null) {
                existingTimedElementNotification.setNotifyOn(timedElementNotification.getNotifyOn());
            }
            if (timedElementNotification.getCustomMessage() != null) {
                existingTimedElementNotification.setCustomMessage(timedElementNotification.getCustomMessage());
            }
            return existingTimedElementNotification;
        }).map(arg_0 -> ((TimedElementNotificationRepository)this.timedElementNotificationRepository).save(arg_0));
    }

    @Transactional(readOnly=true)
    public List<TimedElementNotification> findAll() {
        this.log.debug("Request to get all TimedElementNotifications");
        return this.timedElementNotificationRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<TimedElementNotification> findOne(Long id) {
        this.log.debug("Request to get TimedElementNotification : {}", (Object)id);
        return this.timedElementNotificationRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete TimedElementNotification : {}", (Object)id);
        this.timedElementNotificationRepository.deleteById((Object)id);
    }
}

