/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/auth/realms"})
public class OpenidConfigurationController {
    @Value(value="${ca3s.oidc.configurationFile:classpath:public/openid-configuration/openid-configuration.json}")
    private Resource oidcConfigResource;

    @GetMapping(value={"/{realm}/.well-known/openid-configuration"}, produces={"application/json"})
    public void getOpenidConfiguration(HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        StreamUtils.copy((InputStream)this.oidcConfigResource.getInputStream(), (OutputStream)response.getOutputStream());
    }
}

