/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.TimedElementNotification;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.repository.TimedElementNotificationRepository;
import de.trustable.ca3s.core.service.TimedElementNotificationService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class TimedElementNotificationResource {
    private final Logger log = LoggerFactory.getLogger(TimedElementNotificationResource.class);
    private static final String ENTITY_NAME = "timedElementNotification";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final TimedElementNotificationService timedElementNotificationService;
    private final TimedElementNotificationRepository timedElementNotificationRepository;

    public TimedElementNotificationResource(TimedElementNotificationService timedElementNotificationService, TimedElementNotificationRepository timedElementNotificationRepository) {
        this.timedElementNotificationService = timedElementNotificationService;
        this.timedElementNotificationRepository = timedElementNotificationRepository;
    }

    @PostMapping(value={"/timed-element-notifications"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<TimedElementNotification> createTimedElementNotification(@Valid @RequestBody TimedElementNotification timedElementNotification) throws URISyntaxException {
        this.log.debug("REST request to save TimedElementNotification : {}", (Object)timedElementNotification);
        if (timedElementNotification.getId() != null) {
            throw new BadRequestAlertException("A new timedElementNotification cannot already have an ID", ENTITY_NAME, "idexists");
        }
        TimedElementNotification result = this.timedElementNotificationService.save(timedElementNotification);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/timed-element-notifications/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/timed-element-notifications/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<TimedElementNotification> updateTimedElementNotification(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody TimedElementNotification timedElementNotification) throws URISyntaxException {
        this.log.debug("REST request to update TimedElementNotification : {}, {}", (Object)id, (Object)timedElementNotification);
        if (timedElementNotification.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, timedElementNotification.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.timedElementNotificationRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        TimedElementNotification result = this.timedElementNotificationService.update(timedElementNotification);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)timedElementNotification.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/timed-element-notifications"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public List<TimedElementNotification> getAllTimedElementNotifications() {
        this.log.debug("REST request to get all TimedElementNotifications");
        return this.timedElementNotificationService.findAll();
    }

    @GetMapping(value={"/timed-element-notifications/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<TimedElementNotification> getTimedElementNotification(@PathVariable Long id) {
        this.log.debug("REST request to get TimedElementNotification : {}", (Object)id);
        Optional timedElementNotification = this.timedElementNotificationService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)timedElementNotification);
    }

    @DeleteMapping(value={"/timed-element-notifications/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Void> deleteTimedElementNotification(@PathVariable Long id) {
        this.log.debug("REST request to delete TimedElementNotification : {}", (Object)id);
        this.timedElementNotificationService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

