/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.service.dto.acme.AccountRequest;
import de.trustable.ca3s.core.service.dto.acme.AccountResponse;
import de.trustable.ca3s.core.service.dto.acme.ChangeKeyRequest;
import de.trustable.ca3s.core.service.dto.acme.OrderSetResponse;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.AcmeUtil;
import de.trustable.ca3s.core.service.util.JwtUtil;
import de.trustable.ca3s.core.web.rest.acme.AccountDoesNotExistException;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import java.security.PublicKey;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.codec.binary.Base64;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Transactional(dontRollbackOn={AcmeProblemException.class})
@RestController
@RequestMapping(value={"/acme/{realm}/acct"})
public class AccountController
extends AcmeController {
    private static final Logger LOG = LoggerFactory.getLogger(AccountController.class);
    private static final int CURSOR_CHUNK = 10;
    @Autowired
    JwtUtil jwtUtil;

    public ResponseEntity<AccountResponse> getAccount(@PathVariable long accountId, @PathVariable String realm, @RequestHeader(value="X-CA3S-Forwarded-Host", required=false) String forwardedHost) {
        LOG.info("Received GET request for '{}'", (Object)accountId);
        HttpHeaders additionalHeaders = new HttpHeaders();
        additionalHeaders.set("Link", "<" + this.directoryResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost).path("/..")).build().normalize() + ">;rel=\"index\"");
        Optional acct = this.acctRepository.findById((Object)accountId);
        if (acct.isPresent()) {
            AccountResponse accResp = new AccountResponse((AcmeAccount)acct.get(), this.getEffectiveUriComponentsBuilder(realm, forwardedHost));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)accResp);
        }
        throw new AccountDoesNotExistException(this.getEffectiveUriComponentsBuilder(realm, forwardedHost).build().toUri());
    }

    @RequestMapping(value={"/changeKey"}, method={RequestMethod.POST}, consumes={"application/jose+json"})
    public ResponseEntity<?> changeKey(@RequestBody String requestBody, @PathVariable String realm) {
        LOG.info("Received change key request for ");
        try {
            String accountURL;
            String compactInnerJWT;
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            AcmeAccount acctByKidDao = this.checkJWTSignatureForAccount(context, realm);
            JwtClaims claims = context.getJwtClaims();
            try {
                compactInnerJWT = (String)claims.getClaimValue("protected", String.class) + "." + (String)claims.getClaimValue("payload", String.class) + "." + (String)claims.getClaimValue("signature", String.class);
                LOG.debug("change key compactInnerJWT : " + compactInnerJWT);
            }
            catch (MalformedClaimException e) {
                ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "change key: error reading compactInnerJWT " + e.getMessage(), HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            JwtContext innerContext = this.jwtUtil.processCompactJWT(compactInnerJWT);
            JsonWebStructure innerWebStruct = this.jwtUtil.getJsonWebStructure(innerContext);
            try {
                accountURL = (String)innerContext.getJwtClaims().getClaimValue("account", String.class);
            }
            catch (MalformedClaimException e) {
                ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "change key: error reading claim value for 'account' " + e.getMessage(), HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            ChangeKeyRequest changeKeyReq = this.jwtUtil.getChangeKeyRequest(innerContext.getJwtClaims());
            PublicKey newPK = this.jwtUtil.getPublicKey(innerWebStruct);
            JsonWebKey oldWebKey = changeKeyReq.getOldKey();
            if (!(oldWebKey instanceof PublicJsonWebKey)) {
                String msg = "change Key request: old key is NOT a PublicJsonWebKey (but of class " + oldWebKey.getClass().getName();
                LOG.warn(msg);
                ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "msg", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            PublicKey oldPK = ((PublicJsonWebKey)oldWebKey).getPublicKey();
            LOG.debug("change key, new key : thumb {} : {}", (Object)this.jwtUtil.getJWKThumbPrint(newPK), (Object)newPK);
            LOG.debug("change key, old key : thumb {} : {}", (Object)this.jwtUtil.getJWKThumbPrint(oldPK), (Object)oldPK);
            List accListByOldPK = this.acctRepository.findByPublicKeyHashBase64(this.jwtUtil.getJWKThumbPrint(oldPK));
            if (accListByOldPK.isEmpty()) {
                LOG.warn("change Key request: old key does NOT identify given account");
                ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "old key does NOT identify given account", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            AcmeAccount accountDao = (AcmeAccount)accListByOldPK.get(0);
            String[] urlParts = accountURL.split("/");
            long accountId = Long.parseLong(urlParts[urlParts.length - 1]);
            if (!accountDao.getAccountId().equals(acctByKidDao.getAccountId())) {
                LOG.warn("change Key request: account identified by old key {} does not match account identified by URL : {}", (Object)accountDao.getAccountId(), (Object)acctByKidDao.getAccountId());
                ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "old key does NOT identify kid-identified account", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            if (accountDao.getAccountId() != accountId) {
                LOG.warn("change Key request: account identified by old key {} does not match account isetified by URL : {}", (Object)accountDao.getAccountId(), (Object)accountId);
                ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "old key does NOT identify payload URL-defined account", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            this.jwtUtil.verifyJWT(innerContext, newPK);
            LOG.debug("succesful verification of outer JWT");
            String pkAsString = Base64.encodeBase64String((byte[])newPK.getEncoded()).trim();
            accountDao.setPublicKey(pkAsString);
            String thumbPrint = this.jwtUtil.getJWKThumbPrint(newPK);
            accountDao.setPublicKeyHash(thumbPrint);
            this.acctRepository.save((Object)accountDao);
            LOG.debug("account {} has thumbprint {}", (Object)accountDao.getAccountId(), (Object)thumbPrint);
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).build();
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
        catch (JoseException e) {
            LOG.error("Problem verifying JWT", (Throwable)e);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "Internal crypto problem", HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), AcmeController.NO_INSTANCE);
            return this.buildProblemResponseEntity(new AcmeProblemException(problem));
        }
    }

    @RequestMapping(value={"/{accountId}/orders"}, method={RequestMethod.POST}, consumes={"application/jose+json"})
    public ResponseEntity<?> getAccountOrders(@PathVariable long accountId, @PathVariable String realm, @RequestParam(name="cursor", defaultValue="0") String cursorParam, @RequestHeader(value="X-CA3S-Forwarded-Host", required=false) String forwardedHost, @RequestBody String requestBody) {
        LOG.info("Received getAccountOrders request for '{}', cursor '{}'", (Object)accountId, (Object)cursorParam);
        int cursor = Integer.parseInt(cursorParam);
        int maxCursor = 10 + cursor;
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            AcmeAccount acctDao = this.checkJWTSignatureForAccount(context, realm, Long.valueOf(accountId));
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            OrderSetResponse orderSetResp = new OrderSetResponse();
            String orderUrl = this.accountResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost).path("../..")).path("/").path(Long.toString(accountId)).path("/orders/").build().normalize().toUri().toString();
            int nThisChunk = acctDao.getOrders().size();
            if (nThisChunk > 10) {
                nThisChunk = 10;
            }
            LOG.info("GetAccountOrders cursor '{}', maxCursor '{}', nThisChunk  '{}'", new Object[]{cursor, maxCursor, nThisChunk});
            String[] orderUrlArr = new String[nThisChunk];
            int i = 0;
            int n = 0;
            for (AcmeOrder orderdDao : acctDao.getOrders()) {
                LOG.info("GetAccountOrders i '{}', n '{}'", (Object)i, (Object)n);
                if (i >= cursor) {
                    orderUrlArr[n++] = orderUrl + orderdDao.getId();
                }
                if (++i < maxCursor) continue;
                String nextLink = "<" + this.getEffectiveUriComponentsBuilder(realm, forwardedHost).queryParam("cursor", new Object[]{maxCursor}).build().normalize() + ">;rel=\"next\"";
                LOG.info("Next Chunk Link '{}'", (Object)nextLink);
                additionalHeaders.set("Link", nextLink);
                break;
            }
            orderSetResp.setOrderUrls(orderUrlArr);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)orderSetResp);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }

    @RequestMapping(value={"/{accountId}"}, method={RequestMethod.POST}, consumes={"application/jose+json"})
    public ResponseEntity<?> updateAccount(@PathVariable long accountId, @PathVariable String realm, @RequestHeader(value="X-CA3S-Forwarded-Host", required=false) String forwardedHost, @RequestBody String requestBody) {
        LOG.info("Received updateAccount request for '{}'", (Object)accountId);
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            AccountRequest updateAccountReq = this.jwtUtil.getAccountRequest(context.getJwtClaims());
            AcmeAccount acctDao = this.checkJWTSignatureForAccount(context, realm, Long.valueOf(accountId));
            this.contactsFromRequest(acctDao, updateAccountReq);
            this.acctRepository.save((Object)acctDao);
            AccountResponse accResp = new AccountResponse(acctDao, this.getEffectiveUriComponentsBuilder(realm, forwardedHost));
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)accResp);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }
}

