/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.NotificationService;
import de.trustable.ca3s.core.service.util.NameAndRoleUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class NotificationSupport {
    private final Logger LOG = LoggerFactory.getLogger(NotificationSupport.class);
    private final NameAndRoleUtil nameAndRoleUtil;
    private final UserRepository userRepository;
    private final NotificationService notificationService;
    private final CertificateRepository certificateRepository;
    private final CSRRepository csrRepository;

    public NotificationSupport(NameAndRoleUtil nameAndRoleUtil, UserRepository userRepository, NotificationService notificationService, CertificateRepository certificateRepository, CSRRepository csrRepository) {
        this.nameAndRoleUtil = nameAndRoleUtil;
        this.userRepository = userRepository;
        this.notificationService = notificationService;
        this.certificateRepository = certificateRepository;
        this.csrRepository = csrRepository;
    }

    @Transactional
    @PostMapping(value={"notification/sendExpiryPendingSummary"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public int notifyRAOfficerHolderOnExpiry() throws MessagingException {
        Optional optUser = this.userRepository.findOneByLogin(this.nameAndRoleUtil.getNameAndRole().getName());
        if (optUser.isPresent()) {
            User admin = (User)optUser.get();
            ArrayList<User> raOfficerList = new ArrayList<User>();
            raOfficerList.add(admin);
            ArrayList domainOfficerList = new ArrayList();
            return this.notificationService.notifyRAOfficerHolderOnExpiry(raOfficerList, domainOfficerList, false);
        }
        return 0;
    }

    @Transactional
    @PostMapping(value={"notification/sendRequestorExpirySummary"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public int notifyRequestorOnExpiry() throws MessagingException {
        Optional optUser = this.userRepository.findOneByLogin(this.nameAndRoleUtil.getNameAndRole().getName());
        if (optUser.isPresent()) {
            User admin = (User)optUser.get();
            return this.notificationService.notifyRequestorOnExpiry(admin, false);
        }
        return 0;
    }

    @Transactional
    @PostMapping(value={"notification/sendRAOfficerOnRequest/{csrId}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public void notifyRAOfficerOnRequest(@PathVariable String csrId) {
        Optional optUser = this.userRepository.findOneByLogin(this.nameAndRoleUtil.getNameAndRole().getName());
        if (optUser.isPresent()) {
            User admin = (User)optUser.get();
            ArrayList<User> raOfficerList = new ArrayList<User>();
            raOfficerList.add(admin);
            ArrayList domainOfficerList = new ArrayList();
            CSR csr = (CSR)this.csrRepository.getOne((Object)Long.parseLong(csrId));
            this.notificationService.notifyRAOfficerOnRequest(csr, raOfficerList, domainOfficerList, false);
        }
    }

    @Transactional
    @PostMapping(value={"notification/sendUserCertificateIssued/{certId}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public void notifyUserCertificateIssued(@PathVariable String certId) throws MessagingException {
        Optional optUser = this.userRepository.findOneByLogin(this.nameAndRoleUtil.getNameAndRole().getName());
        if (optUser.isPresent()) {
            User requestor = (User)optUser.get();
            Certificate cert = (Certificate)this.certificateRepository.getOne((Object)Long.parseLong(certId));
            this.notificationService.notifyUserCerificateIssued(requestor, cert, new HashSet());
        }
    }

    @Transactional
    @PostMapping(value={"notification/sendUserCertificateRejected/{csrId}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public void notifyUserCertificateRejected(@PathVariable String csrId) throws MessagingException {
        Optional optUser = this.userRepository.findOneByLogin(this.nameAndRoleUtil.getNameAndRole().getName());
        if (optUser.isPresent()) {
            User requestor = (User)optUser.get();
            CSR csr = (CSR)this.csrRepository.getOne((Object)Long.parseLong(csrId));
            this.notificationService.notifyUserCerificateRejected(requestor, csr);
        }
    }

    @Transactional
    @PostMapping(value={"notification/sendCertificateRevoked/{certId}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public void notifyCerificateRevoked(@PathVariable String certId) throws MessagingException {
        Optional optUser = this.userRepository.findOneByLogin(this.nameAndRoleUtil.getNameAndRole().getName());
        if (optUser.isPresent()) {
            User requestor = (User)optUser.get();
            Certificate cert = (Certificate)this.certificateRepository.getOne((Object)Long.parseLong(certId));
            this.notificationService.notifyCerificateRevoked(requestor, cert, cert.getCsr());
        }
    }

    @Transactional
    @PostMapping(value={"notification/sendUserCertificateRevoked/{certId}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public void notifyUserCerificateRevoked(@PathVariable String certId) throws MessagingException {
        Optional optUser = this.userRepository.findOneByLogin(this.nameAndRoleUtil.getNameAndRole().getName());
        if (optUser.isPresent()) {
            Certificate cert = (Certificate)this.certificateRepository.getOne((Object)Long.parseLong(certId));
            this.notificationService.notifyRAOfficerOnUserRevocation(cert);
        }
    }
}

