/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.security.apikey;

import java.util.Collection;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class APIKeyAuthenticationManager
implements AuthenticationManager {
    private final String apiKeyAdminValue;

    public APIKeyAuthenticationManager(String apiKeyAdminValue) {
        this.apiKeyAdminValue = apiKeyAdminValue;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String principal = (String)authentication.getPrincipal();
        if (this.apiKeyAdminValue == null || !this.apiKeyAdminValue.equals(principal)) {
            throw new BadCredentialsException("The API key was not found or not the expected value.");
        }
        return new PreAuthenticatedAuthenticationToken((Object)"APIKeyUser", (Object)"", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ADMIN"}));
    }
}

