/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.ejbca;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.schedule.ImportInfo;
import de.trustable.ca3s.core.service.cmp.SSLSocketFactoryWrapper;
import de.trustable.ca3s.core.service.dto.ejbca.CertificateRestResponseV2;
import de.trustable.ca3s.core.service.dto.ejbca.SearchCertificatesRestResponseV2;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.time.Instant;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EjbcaConnector {
    Logger LOGGER = LoggerFactory.getLogger(EjbcaConnector.class);
    final long PAGE_SIZE = 10L;
    private final X509TrustManager ca3sTrustManager;
    private final CertificateUtil certUtil;

    public EjbcaConnector(X509TrustManager ca3sTrustManager, CertificateUtil certUtil) {
        this.ca3sTrustManager = ca3sTrustManager;
        this.certUtil = certUtil;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int retrieveCertificates(CAConnectorConfig caConfig) throws IOException {
        ImportInfo importInfo;
        block7: {
            importInfo = new ImportInfo();
            if (caConfig.getCaUrl() == null) {
                this.LOGGER.warn("in retrieveCertificates: url missing");
                return 0;
            }
            if (caConfig.getSelector() == null || caConfig.getSelector().isEmpty()) {
                this.LOGGER.warn("in retrieveCertificates: selector missing");
                return 0;
            }
            String certificateRequestQuery = "{\n  \"pagination\": {\n    \"page_size\": 1000,\n    \"current_page\": 1\n  },  \"criteria\": [\n    {\n      \"property\": \"UPDATE_TIME\",\n      \"value\": \"" + caConfig.getLastUpdate() + "\",\n      \"operation\": \"AFTER\"\n    }\n  ],\n  \"sort_operation\": {\n    \"property\": \"UPDATE_TIME\",\n    \"operation\": \"ASC\"\n  }\n}";
            this.LOGGER.debug("in retrieveCertificates: query: " + certificateRequestQuery);
            try {
                Certificate certificateTlsAuthentication = caConfig.getTlsAuthentication();
                String url = caConfig.getCaUrl().toLowerCase();
                if (url.startsWith("http://") || certificateTlsAuthentication == null) {
                    importInfo = this.invokeRestEndpoint(caConfig, importInfo, url, certificateRequestQuery.getBytes(), null, true, null, null);
                    break block7;
                }
                if (url.startsWith("https://")) {
                    CertificateUtil.KeyStoreAndPassphrase keyStoreAndPassphrase = this.certUtil.getContainer(certificateTlsAuthentication, "entryAlias", "passphraseChars".toCharArray(), "PBEWithHmacSHA256AndAES_256");
                    importInfo = this.invokeRestEndpoint(caConfig, importInfo, url, certificateRequestQuery.getBytes(), null, true, keyStoreAndPassphrase.getKeyStore(), new String(keyStoreAndPassphrase.getPassphraseChars()));
                    break block7;
                }
                return 0;
            }
            catch (IOException e) {
                this.LOGGER.debug("problem retrieving certificates from ejbca", (Throwable)e);
                throw e;
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return importInfo.getImported();
    }

    private ImportInfo invokeRestEndpoint(CAConnectorConfig caConfig, ImportInfo importInfo, String requestUrl, byte[] requestBytes, String sni, boolean disableHostNameVerifier, KeyStore keyStore, String keyPassword) throws IOException {
        this.LOGGER.debug("Sending request to: " + requestUrl);
        long startTime = System.currentTimeMillis();
        URL url = new URL(requestUrl);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        if ("https".equals(url.getProtocol())) {
            try {
                KeyManager[] keyManagers = null;
                if (keyStore != null) {
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                    keyManagerFactory.init(keyStore, keyPassword.toCharArray());
                    keyManagers = keyManagerFactory.getKeyManagers();
                    this.LOGGER.debug("using client keystore");
                }
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(keyManagers, new TrustManager[]{this.ca3sTrustManager}, new SecureRandom());
                SSLSocketFactory socketFactory = sc.getSocketFactory();
                if (sni != null && !sni.trim().isEmpty()) {
                    this.LOGGER.debug("using sni '{}' for CA '{}'", (Object)sni, (Object)requestUrl);
                    SSLParameters sslParameters = new SSLParameters();
                    ArrayList<SNIServerName> sniHostNames = new ArrayList<SNIServerName>(1);
                    sniHostNames.add(new SNIHostName(sni));
                    sslParameters.setServerNames(sniHostNames);
                    socketFactory = new SSLSocketFactoryWrapper(socketFactory, sslParameters);
                }
                HttpsURLConnection conTLS = (HttpsURLConnection)con;
                if (disableHostNameVerifier) {
                    conTLS.setHostnameVerifier((HostnameVerifier)new /* Unavailable Anonymous Inner Class!! */);
                }
                conTLS.setSSLSocketFactory(socketFactory);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException("problem configuring the SSLContext", e);
            }
            catch (UnrecoverableKeyException e) {
                throw new IOException("problem reading keystore", e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        } else if (!"http".equals(url.getProtocol())) {
            throw new IOException("Unexpected protocol '" + url.getProtocol() + "'");
        }
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        OutputStream os = con.getOutputStream();
        os.write(requestBytes);
        os.close();
        this.parseResponse(con.getInputStream(), importInfo, caConfig);
        if (con.getResponseCode() != 200) {
            throw new IOException("Error sending CMP request. Response code != 200 : " + con.getResponseCode());
        }
        this.LOGGER.debug("Received certificate reply.");
        con.disconnect();
        this.LOGGER.debug("duration of remote EJBCA inventory call " + (System.currentTimeMillis() - startTime));
        return importInfo;
    }

    void parseResponse(InputStream in, ImportInfo importInfo, CAConnectorConfig caConfig) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            SearchCertificatesRestResponseV2 certificateSearchResponse = (SearchCertificatesRestResponseV2)objectMapper.readValue(in, SearchCertificatesRestResponseV2.class);
            for (CertificateRestResponseV2 certificateRestResponse : certificateSearchResponse.getCertificates()) {
                String desc = (certificateRestResponse.getSubjectDn() == null ? "" : certificateRestResponse.getSubjectDn()) + ", #" + certificateRestResponse.getSerialNumber();
                if (!certificateRestResponse.getBase64Cert().isEmpty()) {
                    CSR csr = null;
                    if (!certificateRestResponse.getCertificateRequest().isEmpty()) {
                        this.LOGGER.info("CertificateRestResponseV2 contains csr!");
                    }
                    byte[] certBytes = Base64.decodeBase64((byte[])((byte[])certificateRestResponse.getBase64Cert().get(0)));
                    try {
                        Certificate certificate = this.certUtil.createCertificate(certBytes, csr, "", true, caConfig.getCaUrl());
                        Instant lastUpdateInstant = Instant.ofEpochMilli(certificateRestResponse.getUdpateTime());
                        if (lastUpdateInstant.isAfter(caConfig.getLastUpdate())) {
                            caConfig.setLastUpdate(lastUpdateInstant);
                        }
                        importInfo.incImported();
                    }
                    catch (GeneralSecurityException e) {
                        this.LOGGER.info("CertificateRestResponseV2: parsing certificate for '{}' failed: {} ", (Object)desc, (Object)e.getMessage());
                    }
                    continue;
                }
                this.LOGGER.info("CertificateRestResponseV2 does not contain base64 data for {}", (Object)desc);
            }
        }
        catch (IOException e) {
            this.LOGGER.info("unmarshalling CertificateRestResponseV2", (Throwable)e);
        }
    }
}

