/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.Tenant;
import de.trustable.ca3s.core.repository.TenantRepository;
import de.trustable.ca3s.core.service.TenantService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TenantServiceImpl
implements TenantService {
    private final Logger log = LoggerFactory.getLogger(TenantServiceImpl.class);
    private final TenantRepository tenantRepository;

    public TenantServiceImpl(TenantRepository tenantRepository) {
        this.tenantRepository = tenantRepository;
    }

    public Tenant save(Tenant tenant) {
        this.log.debug("Request to save Tenant : {}", (Object)tenant);
        return (Tenant)this.tenantRepository.save((Object)tenant);
    }

    public Tenant update(Tenant tenant) {
        this.log.debug("Request to update Tenant : {}", (Object)tenant);
        return (Tenant)this.tenantRepository.save((Object)tenant);
    }

    public Optional<Tenant> partialUpdate(Tenant tenant) {
        this.log.debug("Request to partially update Tenant : {}", (Object)tenant);
        return this.tenantRepository.findById((Object)tenant.getId()).map(existingTenant -> {
            if (tenant.getName() != null) {
                existingTenant.setName(tenant.getName());
            }
            if (tenant.getLongname() != null) {
                existingTenant.setLongname(tenant.getLongname());
            }
            if (tenant.getActive() != null) {
                existingTenant.setActive(tenant.getActive());
            }
            return existingTenant;
        }).map(arg_0 -> ((TenantRepository)this.tenantRepository).save(arg_0));
    }

    @Transactional(readOnly=true)
    public List<Tenant> findAll() {
        this.log.debug("Request to get all Tenants");
        return this.tenantRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<Tenant> findOne(Long id) {
        this.log.debug("Request to get Tenant : {}", (Object)id);
        return this.tenantRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Tenant : {}", (Object)id);
        this.tenantRepository.deleteById((Object)id);
    }
}

