/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.repository.AcmeAccountViewRepository;
import de.trustable.ca3s.core.service.dto.AcmeAccountView;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.PaginationUtil;

@RestController
@RequestMapping(value={"/api"})
public class AcmeAccountListResource {
    private final AcmeAccountViewRepository acmeAccountViewRepository;
    private final Logger log = LoggerFactory.getLogger(AcmeAccountListResource.class);

    public AcmeAccountListResource(AcmeAccountViewRepository acmeAccountViewRepository) {
        this.acmeAccountViewRepository = acmeAccountViewRepository;
    }

    @GetMapping(value={"/acmeAccountList"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<List<AcmeAccountView>> getAllAcmeAccounts(Pageable pageable, HttpServletRequest request) {
        this.log.debug("REST request to get a page of AcmeAccountViews");
        Page page = this.acmeAccountViewRepository.findSelection(request.getParameterMap());
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }
}

