/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.enumeration.AccountStatus;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.service.AcmeAccountService;
import de.trustable.ca3s.core.web.rest.data.AcmeAccountStatusAdministration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AcmeAccountResource {
    private final Logger log = LoggerFactory.getLogger(AcmeAccountResource.class);
    private static final String ENTITY_NAME = "aCMEAccount";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AcmeAccountService aCMEAccountService;

    public AcmeAccountResource(AcmeAccountService aCMEAccountService) {
        this.aCMEAccountService = aCMEAccountService;
    }

    @PostMapping(value={"/acme-accounts"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<AcmeAccount> createAcmeAccount(@Valid @RequestBody AcmeAccount aCMEAccount) throws URISyntaxException {
        this.log.debug("REST request to save AcmeAccount : {}", (Object)aCMEAccount);
        if (aCMEAccount.getId() != null) {
            throw new BadRequestAlertException("A new aCMEAccount cannot already have an ID", ENTITY_NAME, "idexists");
        }
        AcmeAccount result = this.aCMEAccountService.save(aCMEAccount);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/acme-accounts/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/acme-accounts"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<AcmeAccount> updateAcmeAccount(@Valid @RequestBody AcmeAccount aCMEAccount) throws URISyntaxException {
        this.log.debug("REST request to update AcmeAccount : {}", (Object)aCMEAccount);
        if (aCMEAccount.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        AcmeAccount result = this.aCMEAccountService.save(aCMEAccount);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)aCMEAccount.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/acme-accounts"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public List<AcmeAccount> getAllAcmeAccounts() {
        this.log.debug("REST request to get all AcmeAccounts");
        return this.aCMEAccountService.findAll();
    }

    @GetMapping(value={"/acme-accounts/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<AcmeAccount> getAcmeAccount(@PathVariable Long id) {
        this.log.debug("REST request to get AcmeAccount : {}", (Object)id);
        Optional aCMEAccount = this.aCMEAccountService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)aCMEAccount);
    }

    @DeleteMapping(value={"/acme-accounts/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Void> deleteAcmeAccount(@PathVariable Long id) {
        this.log.debug("REST request to delete AcmeAccount : {}", (Object)id);
        this.aCMEAccountService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @PostMapping(value={"/acme-accounts/{id}/status"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    @Transactional
    public ResponseEntity<Void> updateAcmeAccountStatus(@PathVariable Long id, @RequestBody AcmeAccountStatusAdministration statusAdministration) {
        this.log.debug("REST request to update the status of AcmeAccount : {} to {}", (Object)id, (Object)statusAdministration.getStatus());
        Optional acmeAccountOptional = this.aCMEAccountService.findOne(id);
        if (acmeAccountOptional.isPresent()) {
            AcmeAccount acmeAccount = (AcmeAccount)acmeAccountOptional.get();
            if (AccountStatus.REVOKED.equals((Object)acmeAccount.getStatus())) {
                this.log.info("AcmeAccount : {} has final state {}. Update to {} ignored", new Object[]{id, acmeAccount.getStatus(), statusAdministration.getStatus()});
            } else {
                this.log.info("AcmeAccount : {} updated from state {} to {}.", new Object[]{id, acmeAccount.getStatus(), statusAdministration.getStatus()});
                acmeAccount.setStatus(statusAdministration.getStatus());
            }
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

