/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.advice;

import de.trustable.ca3s.core.security.IPBlockedException;
import de.trustable.ca3s.core.security.UserCredentialsExpiredException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.exception.BlockedCredentialsException;
import de.trustable.ca3s.core.service.util.AcmeUtil;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import de.trustable.ca3s.core.web.rest.errors.RestURIs;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.concurrent.Immutable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
@Immutable
public final class BlockedCredentialsAdvice {
    @ExceptionHandler(value={BlockedCredentialsException.class})
    public ResponseEntity<ProblemDetail> respondTo(BlockedCredentialsException exception) {
        ProblemDetail problem = new ProblemDetail(RestURIs.USER_BLOCKED, "User blocked", HttpStatus.UNAUTHORIZED, "" + exception.getBlockedUntilDate(), AcmeUtil.NO_INSTANCE);
        HttpStatus status = problem.getStatus();
        return ResponseEntity.status((HttpStatus)status).contentType(AcmeController.APPLICATION_PROBLEM_JSON).body((Object)problem);
    }

    @ExceptionHandler(value={IPBlockedException.class})
    public ResponseEntity<ProblemDetail> respondTo(IPBlockedException exception) {
        ProblemDetail problem = new ProblemDetail(RestURIs.USER_BLOCKED, "User blocked", HttpStatus.UNAUTHORIZED, "" + Instant.now().plus(600L, ChronoUnit.SECONDS), AcmeUtil.NO_INSTANCE);
        HttpStatus status = problem.getStatus();
        return ResponseEntity.status((HttpStatus)status).contentType(AcmeController.APPLICATION_PROBLEM_JSON).body((Object)problem);
    }

    @ExceptionHandler(value={UserCredentialsExpiredException.class})
    public ResponseEntity<ProblemDetail> respondTo(UserCredentialsExpiredException exception) {
        ProblemDetail problem = new ProblemDetail(RestURIs.CREDENTIALS_EXPIRED, "Credentials expired", HttpStatus.UNAUTHORIZED, "", AcmeUtil.NO_INSTANCE);
        HttpStatus status = problem.getStatus();
        return ResponseEntity.status((HttpStatus)status).contentType(AcmeController.APPLICATION_PROBLEM_JSON).body((Object)problem);
    }
}

