"use strict";
(self["webpackChunkca_3_s"] = self["webpackChunkca_3_s"] || []).push([["src_main_webapp_app_core_cert-list_cert-info_vue"],{

/***/ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts&":
/*!******************************************************************************************************************************************************!*\
  !*** ./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts& ***!
  \******************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
/* harmony import */ var vue_fragment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue-fragment */ "./node_modules/vue-fragment/dist/vue-fragment.esm.js");
/* harmony import */ var vue_class_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! vue-class-component */ "./node_modules/vue-class-component/dist/vue-class-component.esm.js");
/* harmony import */ var _shared_data_data_utils_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/shared/data/data-utils.service */ "./src/main/webapp/app/shared/data/data-utils.service.ts");
/* harmony import */ var _shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/shared/alert/alert.mixin */ "./src/main/webapp/app/shared/alert/alert.mixin.ts");
/* harmony import */ var _shared_clipboard_clipboard_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/shared/clipboard/clipboard.vue */ "./src/main/webapp/app/shared/clipboard/clipboard.vue");
/* harmony import */ var _core_help_help_tag_vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/core/help/help-tag.vue */ "./src/main/webapp/app/core/help/help-tag.vue");
/* harmony import */ var _core_audit_audit_tag_vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/core/audit/audit-tag.vue */ "./src/main/webapp/app/core/audit/audit-tag.vue");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_7__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};









var CertificateDetails = /** @class */ (function (_super) {
    __extends(CertificateDetails, _super);
    function CertificateDetails() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.certificateView = {};
        _this.certificateAdminData = {};
        _this.attributeArr = [];
        _this.p12Alias = 'alias';
        _this.p12Pbe = 'aes-sha256';
        _this.p12KeyEx = false;
        _this.downloadFormat = 'pkix';
        _this.downloadUrlOnServer = '';
        _this.comment = '';
        _this.trusted = false;
        _this.collapsed = true;
        return _this;
    }
    CertificateDetails.prototype.setCollapsed = function (collapsed) {
        this.collapsed = collapsed;
    };
    CertificateDetails.prototype.getRevocationStyle = function (revoked) {
        return revoked ? 'text-decoration:line-through;' : 'font-weight:bold;';
    };
    CertificateDetails.prototype.getP12Pbe = function () {
        if (this.$store.state.uiConfigStore.config.cryptoConfigView !== undefined &&
            this.$store.state.uiConfigStore.config.cryptoConfigView.defaultPBEAlgo !== undefined) {
            return this.$store.state.uiConfigStore.config.cryptoConfigView.defaultPBEAlgo;
        }
        return 'aes-sha256';
    };
    CertificateDetails.prototype.getP12PbeAlgoArr = function () {
        return this.$store.state.uiConfigStore.config.cryptoConfigView.validPBEAlgoArr;
    };
    CertificateDetails.prototype.getDownloadFilename = function () {
        var extension = '.crt';
        if (this.downloadFormat === 'pem') {
            extension = '.pem';
        }
        else if (this.downloadFormat === 'pemPart') {
            extension = '.part.pem';
        }
        else if (this.downloadFormat === 'pemFull') {
            extension = '.full.pem';
        }
        window.console.info('downloadFilename : ' + this.certificateView.downloadFilename + extension);
        return this.certificateView.downloadFilename + extension;
    };
    CertificateDetails.prototype.downloadItem = function () {
        var filename = this.getDownloadFilename();
        var url = '/publicapi/certPKIX/' + this.certificateView.id + '/' + filename;
        var mimetype = 'application/pkix-cert';
        if (this.downloadFormat === 'pem') {
            url = '/publicapi/certPEM/' + this.certificateView.id + '/' + filename;
            mimetype = 'application/pem-certificate';
        }
        else if (this.downloadFormat === 'pemPart') {
            url = '/publicapi/certPEMPart/' + this.certificateView.id + '/' + filename;
            mimetype = 'application/x-pem-certificate-chain';
        }
        else if (this.downloadFormat === 'pemFull') {
            url = '/publicapi/certPEMFull/' + this.certificateView.id + '/' + filename;
            mimetype = 'application/pem-certificate-chain';
        }
        var headers = { Accept: mimetype };
        this.download(url, filename, mimetype, headers);
    };
    CertificateDetails.prototype.downloadKeystore = function (extension, mimetype) {
        var filename = this.certificateView.downloadFilename + extension;
        var url = '/publicapi/keystore/' + this.certificateView.id + '/' + encodeURIComponent(filename) + '/' + encodeURIComponent(this.p12Alias);
        var headers = {
            Accept: mimetype,
            X_pbeAlgo: this.getP12Pbe(),
            X_keyEx: this.p12KeyEx,
        };
        this.download(url, filename, mimetype, headers);
    };
    CertificateDetails.prototype.download = function (url, filename, mimetype, headers) {
        this.downloadUrlOnServer = url;
        var self = this;
        var config = {};
        config['responseType'] = 'blob';
        config['headers'] = headers;
        axios__WEBPACK_IMPORTED_MODULE_7___default().get(url, config)
            .then(function (response) {
            var blob = new Blob([response.data], { type: mimetype, endings: 'transparent' });
            var link = document.createElement('a');
            link.href = URL.createObjectURL(blob);
            link.download = filename;
            link.type = mimetype;
            window.console.info('tmp download lnk : ' + link.href);
            link.click();
            URL.revokeObjectURL(link.href);
        })
            .catch(function (error) {
            console.log(error);
            var message = self.$t('problem processing request: ' + error);
            var err = error;
            if (err.response) {
                console.log(err.response.status);
                console.log(err.response.data);
                if (err.response.status === 401) {
                    self.alertService().showAlert('Action not allowed', 'warn');
                }
                else {
                    self.alertService().showAlert(message, 'info');
                }
            }
            else {
                self.alertService().showAlert(message, 'info');
            }
            self.getAlertFromStore();
        });
    };
    CertificateDetails.prototype.crlExpiryNotification = function (certificateId) {
        window.console.info('crlExpiryNotification for certificateId ' + certificateId);
        var self = this;
        axios__WEBPACK_IMPORTED_MODULE_7___default()({
            method: 'post',
            url: 'api/crl-expiration-notifications/certificate',
            data: certificateId,
            responseType: 'stream',
        })
            .then(function (response) {
            console.log(response.status);
        })
            .catch(function (error) {
            console.log(error);
            var message = self.$t('problem processing request: ' + error);
            var err = error;
            if (err.response) {
                console.log(err.response.status);
                console.log(err.response.data);
                if (err.response.status === 401 || err.response.status === 403) {
                    self.alertService().showAlert('Action not allowed', 'danger');
                }
                else {
                    self.alertService().showAlert(message, 'info');
                }
            }
            else {
                self.alertService().showAlert(message, 'info');
            }
            self.getAlertFromStore();
        })
            .then(function () {
            // always executed
            // document.body.style.cursor = 'default';
        });
    };
    CertificateDetails.prototype.beforeRouteEnter = function (to, from, next) {
        next(function (vm) {
            window.console.info('################ to.params : ' + to.params.certificateId);
            if (to.params.certificateId) {
                vm.retrieveCertificate(to.params.certificateId);
            }
        });
    };
    CertificateDetails.prototype.mounted = function () {
        window.console.info('++++++++++++++++++ route.query : ' + this.$route.query.certificateId);
        if (this.$route.query.certificateId) {
            this.retrieveCertificate(this.$route.query.certificateId);
        }
        this.p12Pbe = this.getP12Pbe();
    };
    CertificateDetails.prototype.retrieveCertificate = function (certificateId) {
        var _this = this;
        var self = this;
        this.certificateViewService()
            .find(certificateId)
            .then(function (res) {
            self.certificateView = res;
            if (self.certificateAdminData === undefined) {
                self.certificateAdminData = {};
            }
            self.certificateAdminData.arAttributes = _this.certificateView.arArr;
            self.certificateAdminData.comment = _this.certificateView.comment;
            self.comment = _this.certificateView.comment;
            self.trusted = _this.certificateView.trusted;
            self.certificateAdminData.trusted = _this.certificateView.trusted;
            self.attributeArr = JSON.parse(JSON.stringify(self.certificateAdminData.arAttributes));
            window.console.info('certificate loaded successfully : ' + self.certificateView.id);
        });
    };
    CertificateDetails.prototype.previousState = function () {
        this.$router.go(-1);
    };
    Object.defineProperty(CertificateDetails.prototype, "roles", {
        get: function () {
            return this.$store.getters.account ? this.$store.getters.account.authorities[0] : '';
        },
        enumerable: false,
        configurable: true
    });
    CertificateDetails.prototype.getUsername = function () {
        return this.$store.getters.account ? this.$store.getters.account.login : '';
    };
    CertificateDetails.prototype.isTrustable = function () {
        return this.isRAOrAdmin() && !this.certificateView.revoked && this.certificateView.selfsigned;
    };
    CertificateDetails.prototype.isEditable = function () {
        return this.isRAOfficer() || this.isOwnCertificate();
    };
    CertificateDetails.prototype.isRevocable = function () {
        return (!this.certificateView.revoked &&
            this.certificateView.validTo &&
            //      ( this.certificate.validTo.getMilliseconds() < Date.now()) &&
            (this.isRAOfficer() || this.isOwnCertificate()));
    };
    CertificateDetails.prototype.isRemovableFromCRL = function () {
        return (this.certificateView.revocationReason === 'certificateHold' &&
            this.certificateView.validTo &&
            //      ( this.certificate.validTo.getMilliseconds() < Date.now()) &&
            (this.isRAOfficer() || this.isOwnCertificate()));
    };
    CertificateDetails.prototype.isRAOfficer = function () {
        return this.hasRole('ROLE_RA') || this.hasRole('ROLE_RA_DOMAIN');
    };
    CertificateDetails.prototype.isAdmin = function () {
        return this.hasRole('ROLE_ADMIN');
    };
    CertificateDetails.prototype.isRAOrAdmin = function () {
        return this.isRAOfficer() || this.isAdmin();
    };
    CertificateDetails.prototype.hasRole = function (targetRole) {
        if (this.$store.getters.account === null || this.$store.getters.account.authorities === null) {
            return false;
        }
        for (var _i = 0, _a = this.$store.getters.account.authorities; _i < _a.length; _i++) {
            var role = _a[_i];
            if (targetRole === role) {
                return true;
            }
        }
        return false;
    };
    CertificateDetails.prototype.isOwnCertificate = function () {
        return this.getUsername() === this.certificateView.requestedBy;
    };
    CertificateDetails.prototype.isValuesChanged = function () {
        if (this.certificateAdminData.arAttributes && this.attributeArr) {
            for (var i = 0; i < this.certificateAdminData.arAttributes.length; i++) {
                if (this.certificateAdminData.arAttributes[i].value !== this.attributeArr[i].value) {
                    return true;
                }
            }
        }
        return this.comment !== this.certificateView.comment || this.trusted !== this.certificateView.trusted;
    };
    CertificateDetails.prototype.copyCertificateDataToAdminData = function () {
        this.certificateAdminData.certificateId = this.certificateView.id;
        this.certificateAdminData.comment = this.comment;
        this.certificateAdminData.trusted = this.trusted;
    };
    CertificateDetails.prototype.updateCertificate = function () {
        this.copyCertificateDataToAdminData();
        this.certificateAdminData.administrationType = 'UPDATE';
        this.sendAdministrationAction('api/administerCertificate');
    };
    CertificateDetails.prototype.updateCRL = function () {
        this.certificateAdminData.certificateId = this.certificateView.id;
        this.certificateAdminData.administrationType = 'UPDATE_CRL';
        this.sendAdministrationAction('api/administerCertificate');
    };
    CertificateDetails.prototype.removeCertificateFromCRL = function () {
        this.copyCertificateDataToAdminData();
        this.certificateAdminData.administrationType = 'REVOKE';
        this.sendAdministrationAction('api/administerCertificate');
    };
    CertificateDetails.prototype.revokeCertificate = function () {
        this.copyCertificateDataToAdminData();
        this.certificateAdminData.administrationType = 'REVOKE';
        this.sendAdministrationAction('api/administerCertificate');
    };
    CertificateDetails.prototype.revokeCertificateAndClose = function () {
        if (this.isOwnCertificate()) {
            this.withdrawCertificate();
        }
        else {
            this.revokeCertificate();
        }
        var message = this.$t('ca3SApp.certificate.revoked', { param: this.certificateView.id });
        this.alertService().showAlert(message, 'danger');
        this.getAlertFromStore();
        this.closeDialog();
    };
    CertificateDetails.prototype.prepareRevoke = function () {
        var message = this.$t('ca3SApp.certificate.revoked', { param: this.certificateView.id });
        this.alertService().showAlert(message, 'danger');
        this.getAlertFromStore();
        this.closeDialog();
    };
    CertificateDetails.prototype.closeDialog = function () {
        this.$refs.revokeCertificate.hide();
    };
    CertificateDetails.prototype.selfAdministerCertificate = function () {
        this.copyCertificateDataToAdminData();
        this.certificateAdminData.administrationType = 'UPDATE';
        this.sendAdministrationAction('api/selfAdministerCertificate');
    };
    CertificateDetails.prototype.withdrawCertificate = function () {
        this.copyCertificateDataToAdminData();
        this.certificateAdminData.administrationType = 'REVOKE';
        this.sendAdministrationAction('api/withdrawOwnCertificate');
    };
    CertificateDetails.prototype.sendAdministrationAction = function (adminUrl) {
        return __awaiter(this, void 0, void 0, function () {
            var self;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        document.body.style.cursor = 'wait';
                        self = this;
                        if (this.certificateAdminData.trusted === null) {
                            this.certificateAdminData.trusted = false;
                        }
                        return [4 /*yield*/, axios__WEBPACK_IMPORTED_MODULE_7___default()({
                                method: 'post',
                                url: adminUrl,
                                data: this.certificateAdminData,
                                responseType: 'stream',
                            })
                                .then(function (response) {
                                if (response) {
                                    console.log(response.status);
                                    if (response.status === 201) {
                                        self.$router.push({ name: 'CertInfo', params: { certificateId: response.data.toString() } });
                                    }
                                    else {
                                        self.previousState();
                                    }
                                }
                            })
                                .catch(function (error) {
                                console.log(error);
                                var message = self.$t('problem processing request: ' + error);
                                var err = error;
                                if (err.response) {
                                    console.log(err.response.status);
                                    console.log(err.response.data);
                                    if (err.response.status === 401 || err.response.status === 403) {
                                        self.alertService().showAlert('Action not allowed', 'danger');
                                    }
                                    else {
                                        self.alertService().showAlert(message, 'info');
                                    }
                                }
                                else {
                                    self.alertService().showAlert(message, 'info');
                                }
                                self.getAlertFromStore();
                            })
                                .then(function () {
                                // always executed
                                document.body.style.cursor = 'default';
                            })];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    CertificateDetails.prototype.showRegExpFieldWarning = function (value, regEx) {
        var regexp = new RegExp(regEx);
        var valid = regexp.test(value);
        console.log('showRegExpFieldWarning( ' + regEx + ', "' + value + '") -> ' + valid);
        return !valid;
    };
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('certificateViewService'),
        __metadata("design:type", Function)
    ], CertificateDetails.prototype, "certificateViewService", void 0);
    CertificateDetails = __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component)({
            components: {
                Fragment: vue_fragment__WEBPACK_IMPORTED_MODULE_1__.Fragment,
                CopyClipboardButton: _shared_clipboard_clipboard_vue__WEBPACK_IMPORTED_MODULE_4__["default"],
                HelpTag: _core_help_help_tag_vue__WEBPACK_IMPORTED_MODULE_5__["default"],
                AuditTag: _core_audit_audit_tag_vue__WEBPACK_IMPORTED_MODULE_6__["default"],
            },
        })
    ], CertificateDetails);
    return CertificateDetails;
}((0,vue_class_component__WEBPACK_IMPORTED_MODULE_8__.mixins)(_shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_3__["default"], _shared_data_data_utils_service__WEBPACK_IMPORTED_MODULE_2__["default"])));
/* harmony default export */ __webpack_exports__["default"] = (CertificateDetails);


/***/ }),

/***/ "./src/main/webapp/app/shared/data/data-utils.service.ts":
/*!***************************************************************!*\
  !*** ./src/main/webapp/app/shared/data/data-utils.service.ts ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
/*
Copyright 2013-2017 the original author or authors from the JHipster project.
This file is part of the JHipster project, see https://jhipster.github.io/
for more information.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/**
 * An utility service for data.
 */
var JhiDataUtils = /** @class */ (function (_super) {
    __extends(JhiDataUtils, _super);
    function JhiDataUtils() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Method to abbreviate the text given
     */
    JhiDataUtils.prototype.abbreviate = function (text, append) {
        if (append === void 0) { append = '...'; }
        if (text.length < 30) {
            return text;
        }
        return text ? text.substring(0, 15) + append + text.slice(-10) : '';
    };
    /**
     * Method to find the byte size of the string provides
     */
    JhiDataUtils.prototype.byteSize = function (base64String) {
        return this.formatAsBytes(this.size(base64String));
    };
    /**
     * Method to open file
     */
    JhiDataUtils.prototype.openFile = function (contentType, data) {
        if (window.navigator && window.navigator.msSaveOrOpenBlob) {
            // To support IE and Edge
            var byteCharacters = atob(data);
            var byteNumbers = new Array(byteCharacters.length);
            for (var i = 0; i < byteCharacters.length; i++) {
                byteNumbers[i] = byteCharacters.charCodeAt(i);
            }
            var byteArray = new Uint8Array(byteNumbers);
            var blob = new Blob([byteArray], {
                type: contentType
            });
            window.navigator.msSaveOrOpenBlob(blob);
        }
        else {
            // Other browsers
            var fileURL = "data:".concat(contentType, ";base64,").concat(data);
            var win = window.open();
            win.document.write('<iframe src="' +
                fileURL +
                '" frameborder="0" style="border:0; top:0px; left:0px; bottom:0px; right:0px; width:100%; height:100%;" allowfullscreen></iframe>');
        }
    };
    /**
     * Method to convert the file to base64
     */
    JhiDataUtils.prototype.toBase64 = function (file, cb) {
        var fileReader = new FileReader();
        fileReader.readAsDataURL(file);
        fileReader.onload = function (e) {
            var base64Data = e.target.result.substr(e.target.result.indexOf('base64,') + 'base64,'.length);
            cb(base64Data);
        };
    };
    /**
     * Method to clear the input
     */
    JhiDataUtils.prototype.clearInputImage = function (entity, elementRef, field, fieldContentType, idInput) {
        if (entity && field && fieldContentType) {
            if (entity.hasOwnProperty(field)) {
                entity[field] = null;
            }
            if (entity.hasOwnProperty(fieldContentType)) {
                entity[fieldContentType] = null;
            }
            if (elementRef && idInput && elementRef.nativeElement.querySelector('#' + idInput)) {
                elementRef.nativeElement.querySelector('#' + idInput).value = null;
            }
        }
    };
    JhiDataUtils.prototype.endsWith = function (suffix, str) {
        return str.indexOf(suffix, str.length - suffix.length) !== -1;
    };
    JhiDataUtils.prototype.paddingSize = function (value) {
        if (this.endsWith('==', value)) {
            return 2;
        }
        if (this.endsWith('=', value)) {
            return 1;
        }
        return 0;
    };
    JhiDataUtils.prototype.size = function (value) {
        return (value.length / 4) * 3 - this.paddingSize(value);
    };
    JhiDataUtils.prototype.formatAsBytes = function (size) {
        return size.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ' ') + ' bytes';
    };
    JhiDataUtils.prototype.setFileData = function (event, entity, field, isImage) {
        if (event && event.target.files && event.target.files[0]) {
            var file_1 = event.target.files[0];
            if (isImage && !/^image\//.test(file_1.type)) {
                return;
            }
            this.toBase64(file_1, function (base64Data) {
                entity[field] = base64Data;
                entity["".concat(field, "ContentType")] = file_1.type;
            });
        }
    };
    /**
     * Method to download file
     */
    JhiDataUtils.prototype.downloadFile = function (contentType, data, fileName) {
        var byteCharacters = atob(data);
        var byteNumbers = new Array(byteCharacters.length);
        for (var i = 0; i < byteCharacters.length; i++) {
            byteNumbers[i] = byteCharacters.charCodeAt(i);
        }
        var byteArray = new Uint8Array(byteNumbers);
        var blob = new Blob([byteArray], {
            type: contentType
        });
        var tempLink = document.createElement('a');
        tempLink.href = window.URL.createObjectURL(blob);
        tempLink.download = fileName;
        tempLink.target = '_blank';
        tempLink.click();
    };
    JhiDataUtils = __decorate([
        vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component
    ], JhiDataUtils);
    return JhiDataUtils;
}(vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Vue));
/* harmony default export */ __webpack_exports__["default"] = (JhiDataUtils);


/***/ }),

/***/ "./node_modules/vue-fragment/dist/vue-fragment.esm.js":
/*!************************************************************!*\
  !*** ./node_modules/vue-fragment/dist/vue-fragment.esm.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Fragment": function() { return /* binding */ Fragment; },
/* harmony export */   "Plugin": function() { return /* binding */ Plugin; },
/* harmony export */   "SSR": function() { return /* binding */ SSR; }
/* harmony export */ });
function _defineProperty(e,n,t){return n in e?Object.defineProperty(e,n,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[n]=t,e}function _objectSpread(e){for(var n=1;n<arguments.length;n++){var t=null!=arguments[n]?arguments[n]:{},r=Object.keys(t);"function"==typeof Object.getOwnPropertySymbols&&(r=r.concat(Object.getOwnPropertySymbols(t).filter(function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),r.forEach(function(n){_defineProperty(e,n,t[n])})}return e}var freeze=function(e,n,t){Object.defineProperty(e,n,{configurable:!0,get:function(){return t},set:function(e){console.warn("tried to set frozen property ".concat(n," with ").concat(e))}})},unfreeze=function(e,n){var t=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;Object.defineProperty(e,n,{configurable:!0,writable:!0,value:t})},component={abstract:!0,name:"Fragment",props:{name:{type:String,default:function(){return Math.floor(Date.now()*Math.random()).toString(16)}}},mounted:function(){var e=this.$el,n=e.parentNode,t=document.createComment("fragment#".concat(this.name,"#head")),r=document.createComment("fragment#".concat(this.name,"#tail"));n.insertBefore(t,e),n.insertBefore(r,e),e.appendChild=function(t){n.insertBefore(t,r),freeze(t,"parentNode",e)},e.insertBefore=function(t,r){n.insertBefore(t,r),freeze(t,"parentNode",e)},e.removeChild=function(e){n.removeChild(e),unfreeze(e,"parentNode")},Array.from(e.childNodes).forEach(function(n){return e.appendChild(n)}),n.removeChild(e),freeze(e,"parentNode",n),freeze(e,"nextSibling",r.nextSibling);var o=n.insertBefore;n.insertBefore=function(r,i){o.call(n,r,i!==e?i:t)};var i=n.removeChild;n.removeChild=function(a){if(a===e){for(;t.nextSibling!==r;)e.removeChild(t.nextSibling);n.removeChild(t),n.removeChild(r),unfreeze(e,"parentNode"),n.insertBefore=o,n.removeChild=i}else i.call(n,a)}},render:function(e){var n=this,t=this.$slots.default;return t&&t.length&&t.forEach(function(e){return e.data=_objectSpread({},e.data,{attrs:_objectSpread({fragment:n.name},(e.data||{}).attrs)})}),e("div",{attrs:{fragment:this.name}},t)}};function ssr(e,n){ true&&console.warn("v-fragment SSR is not implemented yet.")}var Fragment=component,SSR=ssr,Plugin={install:function(e){e.component("fragment",component)}},index={Fragment:component,Plugin:Plugin,SSR:ssr};/* harmony default export */ __webpack_exports__["default"] = (index);


/***/ }),

/***/ "./src/main/webapp/app/core/cert-list/cert-info.vue":
/*!**********************************************************!*\
  !*** ./src/main/webapp/app/core/cert-list/cert-info.vue ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cert-info.vue?vue&type=template&id=0ba0f292&scoped=true& */ "./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true&");
/* harmony import */ var _cert_info_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./cert-info.component.ts?vue&type=script&lang=ts& */ "./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");





/* normalize component */
;
var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  _cert_info_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__["default"],
  _cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__.render,
  _cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "0ba0f292",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/main/webapp/app/core/cert-list/cert-info.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts&":
/*!********************************************************************************************!*\
  !*** ./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts& ***!
  \********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_cert_info_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./cert-info.component.ts?vue&type=script&lang=ts& */ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts&");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_cert_info_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true&":
/*!*****************************************************************************************************!*\
  !*** ./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true& ***!
  \*****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   "staticRenderFns": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./cert-info.vue?vue&type=template&id=0ba0f292&scoped=true& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true&");


/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true&":
/*!*********************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true& ***!
  \*********************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* binding */ render; },
/* harmony export */   "staticRenderFns": function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c,
    _setup = _vm._self._setupProxy
  return _c(
    "div",
    [
      _c("div", { staticClass: "row justify-content-center" }, [
        _c("div", { staticClass: "col-8" }, [
          _vm.certificateView
            ? _c("div", [
                _c("h2", { staticClass: "jh-entity-heading" }, [
                  _c(
                    "span",
                    {
                      domProps: {
                        textContent: _vm._s(
                          _vm.$t("ca3SApp.certificate.detail.title")
                        ),
                      },
                    },
                    [_vm._v("Certificate")]
                  ),
                  _vm._v(" " + _vm._s(_vm.certificateView.id)),
                ]),
                _vm._v(" "),
                _c(
                  "dl",
                  { staticClass: "row jh-entity-details" },
                  [
                    _c("dt", [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.certificate.subject")
                            ),
                          },
                        },
                        [_vm._v("Subject")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c(
                      "dd",
                      {
                        style: _vm.getRevocationStyle(
                          _vm.certificateView.revoked
                        ),
                      },
                      [
                        _c("span", [
                          _vm._v(_vm._s(_vm.certificateView.subject)),
                        ]),
                      ]
                    ),
                    _vm._v(" "),
                    _vm.certificateView.revoked
                      ? _c("dt", [
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.certificate.revokedSince")
                                ),
                              },
                            },
                            [_vm._v("Revoked Since")]
                          ),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.revoked
                      ? _c("dd", [
                          _vm.certificateView.revokedSince
                            ? _c("span", [
                                _vm._v(
                                  _vm._s(
                                    _vm.$d(
                                      Date.parse(
                                        _vm.certificateView.revokedSince
                                      ),
                                      "long"
                                    )
                                  )
                                ),
                              ])
                            : _vm._e(),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.revoked
                      ? _c("dt", [
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.certificate.revocationReason")
                                ),
                              },
                            },
                            [_vm._v("Revocation Reason")]
                          ),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.revoked
                      ? _c("dd", [
                          _c("span", { attrs: { name: "revocationReason" } }, [
                            _vm._v(
                              _vm._s(_vm.certificateView.revocationReason)
                            ),
                          ]),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.sanArr &&
                    _vm.certificateView.sanArr.length > 0
                      ? _c("dt", [
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.certificate.sans")
                                ),
                              },
                            },
                            [_vm._v("Subject alternative names")]
                          ),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.sanArr &&
                    _vm.certificateView.sanArr.length > 0
                      ? _c("dd", [
                          _c(
                            "ul",
                            _vm._l(_vm.certificateView.sanArr, function (san) {
                              return _c("li", { key: san }, [
                                _vm._v(_vm._s(san)),
                              ])
                            }),
                            0
                          ),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _c("dt", [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.certificate.issuer")
                            ),
                          },
                        },
                        [_vm._v("Issuer")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("dd", [
                      _vm.certificateView.selfsigned
                        ? _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.certificate.selfsigned")
                                ),
                              },
                            },
                            [_vm._v("Selfsigned")]
                          )
                        : _vm.certificateView.issuerId
                        ? _c(
                            "a",
                            {
                              attrs: { href: "issuer" },
                              on: {
                                click: function ($event) {
                                  $event.preventDefault()
                                  return _vm.retrieveCertificate(
                                    _vm.certificateView.issuerId
                                  )
                                },
                              },
                            },
                            [_vm._v(_vm._s(_vm.certificateView.issuer))]
                          )
                        : _c("span", [
                            _vm._v(_vm._s(_vm.certificateView.issuer)),
                          ]),
                    ]),
                    _vm._v(" "),
                    !_vm.certificateView.selfsigned && _vm.certificateView.root
                      ? _c("dt", [
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.certificate.root")
                                ),
                              },
                            },
                            [_vm._v("Root")]
                          ),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    !_vm.certificateView.selfsigned && _vm.certificateView.root
                      ? _c("dd", [
                          _c("span", [
                            _vm._v(_vm._s(_vm.certificateView.root)),
                          ]),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _c("dt", [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.certificate.type")
                            ),
                          },
                        },
                        [_vm._v("Type")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("dd", [
                      _c("span", [_vm._v(_vm._s(_vm.certificateView.type))]),
                      _vm._v(" "),
                      _vm.certificateView.ca
                        ? _c("span", [_vm._v(", "), _c("b", [_vm._v("CA")])])
                        : _vm._e(),
                      _vm._v(" "),
                      _vm.certificateView.selfsigned
                        ? _c("span", [
                            _vm._v(", "),
                            _c("b", [_vm._v("Selfsigned")]),
                          ])
                        : _vm._e(),
                      _vm._v(" "),
                      _vm.certificateView.trusted
                        ? _c("span", [
                            _vm._v(", "),
                            _c("b", [_vm._v("Trusted")]),
                          ])
                        : _vm._e(),
                      _vm._v(" "),
                      _vm.certificateView.issuingActiveCertificates
                        ? _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.certificate.active.issued")
                                ),
                              },
                            },
                            [
                              _vm._v(", "),
                              _c("b", [
                                _vm._v("Has active certificate issued"),
                              ]),
                            ]
                          )
                        : _vm._e(),
                    ]),
                    _vm._v(" "),
                    _c("dt", [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.certificate.serial")
                            ),
                          },
                        },
                        [_vm._v("Serial")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("dd", [
                      _c("ul", [
                        _c("li", [
                          _vm._v(
                            _vm._s(_vm.certificateView.serialHex) +
                              " (" +
                              _vm._s(_vm.$t("HEX")) +
                              ")"
                          ),
                        ]),
                        _vm._v(" "),
                        _vm.certificateView.serialHex !=
                        _vm.certificateView.serial
                          ? _c("li", [
                              _vm._v(
                                _vm._s(_vm.certificateView.serial) +
                                  " (" +
                                  _vm._s(_vm.$t("DECIMAL")) +
                                  ")"
                              ),
                            ])
                          : _vm._e(),
                      ]),
                    ]),
                    _vm._v(" "),
                    _c("dt", [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.certificate.validFrom")
                            ),
                          },
                        },
                        [_vm._v("Valid From")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("dd", [
                      _vm.certificateView.validFrom
                        ? _c("span", [
                            _vm._v(
                              _vm._s(
                                _vm.$d(
                                  Date.parse(_vm.certificateView.validFrom),
                                  "long"
                                )
                              )
                            ),
                          ])
                        : _vm._e(),
                    ]),
                    _vm._v(" "),
                    _c("dt", [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.certificate.validTo")
                            ),
                          },
                        },
                        [_vm._v("Valid To")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("dd", [
                      _vm.certificateView.validTo
                        ? _c("span", [
                            _vm._v(
                              _vm._s(
                                _vm.$d(
                                  Date.parse(_vm.certificateView.validTo),
                                  "long"
                                )
                              )
                            ),
                          ])
                        : _vm._e(),
                    ]),
                    _vm._v(" "),
                    _c("dt", [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.certificate.keyDetails")
                            ),
                          },
                        },
                        [_vm._v("Key Details")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("dd", [
                      _c("span", [
                        _vm._v(_vm._s(_vm.certificateView.keyAlgorithm)),
                      ]),
                      _vm._v(" "),
                      _vm.certificateView.keyLength &&
                      _vm.certificateView.keyLength.length > 0 &&
                      _vm.certificateView.keyLength !== "-1"
                        ? _c("span", [
                            _vm._v(
                              " / " +
                                _vm._s(_vm.certificateView.keyLength) +
                                " bits"
                            ),
                          ])
                        : _vm._e(),
                      _vm._v(" "),
                      _vm.certificateView.altKeyAlgorithm
                        ? _c("span", [
                            _vm._v(
                              " alt: " +
                                _vm._s(_vm.certificateView.altKeyAlgorithm)
                            ),
                          ])
                        : _vm._e(),
                    ]),
                    _vm._v(" "),
                    _vm.certificateView.curveName &&
                    _vm.certificateView.curveName.length > 0
                      ? _c("dt", [
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.certificate.curveName")
                                ),
                              },
                            },
                            [_vm._v("Curve Name")]
                          ),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.curveName &&
                    _vm.certificateView.curveName.length > 0
                      ? _c("dd", [
                          _c("span", [
                            _vm._v(_vm._s(_vm.certificateView.curveName)),
                          ]),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _c("dt", [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.certificate.signingAlgorithm")
                            ),
                          },
                        },
                        [_vm._v("Signing Algorithm")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("dd", [
                      _c("span", [
                        _vm._v(_vm._s(_vm.certificateView.signingAlgorithm)),
                      ]),
                      _vm._v(" "),
                      _vm.certificateView.hashAlgorithm &&
                      _vm.certificateView.hashAlgorithm.length > 0
                        ? _c("span", [
                            _vm._v(
                              " / " + _vm._s(_vm.certificateView.hashAlgorithm)
                            ),
                          ])
                        : _vm._e(),
                      _vm._v(" "),
                      _vm.certificateView.paddingAlgorithm &&
                      _vm.certificateView.paddingAlgorithm.length > 0
                        ? _c("span", [
                            _vm._v(
                              " / " +
                                _vm._s(_vm.certificateView.paddingAlgorithm)
                            ),
                          ])
                        : _vm._e(),
                    ]),
                    _vm._v(" "),
                    _c("dt", [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.certificate.usage")
                            ),
                          },
                        },
                        [_vm._v("Usage")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("dd", [
                      _vm.certificateView.usage &&
                      _vm.certificateView.usage.length > 0
                        ? _c(
                            "ul",
                            _vm._l(_vm.certificateView.usage, function (usg) {
                              return _c("li", { key: usg }, [
                                _vm._v(_vm._s(usg)),
                              ])
                            }),
                            0
                          )
                        : _vm._e(),
                    ]),
                    _vm._v(" "),
                    _vm.certificateView.extUsage &&
                    _vm.certificateView.extUsage.length > 0
                      ? _c("dt", [
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.certificate.extended.usage")
                                ),
                              },
                            },
                            [_vm._v("Usage")]
                          ),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.extUsage &&
                    _vm.certificateView.extUsage.length > 0
                      ? _c("dd", [
                          _c(
                            "ul",
                            _vm._l(
                              _vm.certificateView.extUsage,
                              function (extUsage) {
                                return _c("li", { key: extUsage }, [
                                  _vm._v(_vm._s(extUsage)),
                                ])
                              }
                            ),
                            0
                          ),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _c("dt", [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.certificate.contentAddedAt")
                            ),
                          },
                        },
                        [_vm._v("Content Added At")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("dd", [
                      _vm.certificateView.contentAddedAt
                        ? _c("span", [
                            _vm._v(
                              _vm._s(
                                _vm.$d(
                                  Date.parse(
                                    _vm.certificateView.contentAddedAt
                                  ),
                                  "long"
                                )
                              )
                            ),
                          ])
                        : _vm._e(),
                    ]),
                    _vm._v(" "),
                    _vm.certificateView.crlUrl
                      ? _c("dt", [
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.certificate.crlUrl")
                                ),
                              },
                            },
                            [_vm._v("CRL Uri")]
                          ),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.crlUrl
                      ? _c("dd", [
                          _c("span", { attrs: { name: "crlUrl" } }, [
                            _vm._v(_vm._s(_vm.certificateView.crlUrl)),
                          ]),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _c("dt", [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.certificate.fingerprint")
                            ),
                          },
                        },
                        [_vm._v("Fingerprint")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("dd", [
                      _c("ul", [
                        _c("li", [
                          _c("span", [
                            _vm._v(_vm._s(_vm.certificateView.fingerprintSha1)),
                          ]),
                        ]),
                        _vm._v(" "),
                        _c("li", [
                          _c("span", [
                            _vm._v(
                              _vm._s(_vm.certificateView.fingerprintSha256)
                            ),
                          ]),
                        ]),
                      ]),
                    ]),
                    _vm._v(" "),
                    _vm.certificateView.csrId
                      ? _c("dt", [
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.certificate.csr")
                                ),
                              },
                            },
                            [_vm._v("Csr")]
                          ),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.csrId
                      ? _c("dd", [
                          _c(
                            "div",
                            [
                              _c(
                                "router-link",
                                {
                                  attrs: {
                                    to: {
                                      name: "CsrInfo",
                                      params: {
                                        csrId: _vm.certificateView.csrId,
                                      },
                                    },
                                  },
                                },
                                [_vm._v(_vm._s(_vm.certificateView.csrId))]
                              ),
                            ],
                            1
                          ),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.requestedBy
                      ? _c("dt", [
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.certificate.requestedBy")
                                ),
                              },
                            },
                            [_vm._v("Requested by")]
                          ),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.requestedBy
                      ? _c("dd", [
                          (_vm.certificateView.firstName ||
                            _vm.certificateView.lastName) &&
                          _vm.certificateView.email
                            ? _c("span", [
                                _c(
                                  "a",
                                  {
                                    attrs: {
                                      href:
                                        "mailto:" + _vm.certificateView.email,
                                    },
                                  },
                                  [
                                    _vm._v(
                                      _vm._s(
                                        _vm.$t(
                                          "ca3SApp.cSR.requestor.details",
                                          {
                                            login: _vm.certificateView.login,
                                            fistName:
                                              _vm.certificateView.firstName,
                                            lastName:
                                              _vm.certificateView.lastName,
                                          }
                                        )
                                      )
                                    ),
                                  ]
                                ),
                              ])
                            : _vm._e(),
                          _vm._v(" "),
                          (_vm.certificateView.firstName ||
                            _vm.certificateView.lastName) &&
                          !_vm.certificateView.email
                            ? _c("span", [
                                _vm._v(
                                  _vm._s(
                                    _vm.$t("ca3SApp.cSR.requestor.details", {
                                      login: _vm.certificateView.login,
                                      fistName: _vm.certificateView.firstName,
                                      lastName: _vm.certificateView.lastName,
                                    })
                                  )
                                ),
                              ])
                            : _vm._e(),
                          _vm._v(" "),
                          _vm.certificateView.tenantName
                            ? _c("span", [
                                _vm._v(
                                  _vm._s(
                                    _vm.$t("ca3SApp.cSR.requestor.tenant", {
                                      tenant: _vm.certificateView.tenantName,
                                    })
                                  )
                                ),
                              ])
                            : _vm._e(),
                          _vm._v(" "),
                          _c("span", [
                            _vm._v(_vm._s(_vm.certificateView.requestedBy)),
                          ]),
                          _vm._v(" "),
                          _vm.certificateView.tenantName
                            ? _c("span", [
                                _vm._v(
                                  " / " + _vm._s(_vm.certificateView.tenantName)
                                ),
                              ])
                            : _vm._e(),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.requestedOn
                      ? _c("dt", [
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.certificate.requestedOn")
                                ),
                              },
                            },
                            [_vm._v("Requested on")]
                          ),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.requestedOn
                      ? _c("dd", [
                          _c("span", [
                            _vm._v(_vm._s(_vm.certificateView.requestedOn)),
                          ]),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm._l(_vm.certificateView.arArr, function (attr) {
                      return !_vm.isEditable()
                        ? _c("Fragment", { key: attr.name }, [
                            _c("dt", [_c("span", [_vm._v(_vm._s(attr.name))])]),
                            _vm._v(" "),
                            _c("dd", [
                              _c("span", [_vm._v(_vm._s(attr.value))]),
                            ]),
                          ])
                        : _vm._e()
                    }),
                    _vm._v(" "),
                    _vm.certificateView.isServersideKeyGeneration &&
                    _vm.isEditable()
                      ? _c(
                          "dt",
                          [
                            _c(
                              "span",
                              {
                                domProps: {
                                  textContent: _vm._s(
                                    _vm.$t(
                                      "ca3SApp.certificate.download.PKCS12"
                                    )
                                  ),
                                },
                              },
                              [_vm._v("PKCS12 keystore")]
                            ),
                            _vm._v(" "),
                            _c("help-tag", {
                              attrs: {
                                target: "ca3SApp.certificate.download.PKCS12",
                              },
                            }),
                          ],
                          1
                        )
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.isServersideKeyGeneration &&
                    _vm.isEditable()
                      ? _c("dd", [
                          _c("div", { staticClass: "row" }, [
                            _c("div", { staticClass: "col" }, [
                              _c(
                                "label",
                                {
                                  staticClass: "form-control-label",
                                  attrs: { for: "p12Alias" },
                                  domProps: {
                                    textContent: _vm._s(
                                      _vm.$t(
                                        "ca3SApp.certificate.download.p12Alias"
                                      )
                                    ),
                                  },
                                },
                                [_vm._v("Alias")]
                              ),
                              _vm._v(" "),
                              _c("input", {
                                directives: [
                                  {
                                    name: "model",
                                    rawName: "v-model",
                                    value: _vm.p12Alias,
                                    expression: "p12Alias",
                                  },
                                ],
                                staticClass: "form-check-inline",
                                attrs: {
                                  type: "text",
                                  name: "p12Alias",
                                  id: "p12Alias",
                                },
                                domProps: { value: _vm.p12Alias },
                                on: {
                                  input: function ($event) {
                                    if ($event.target.composing) return
                                    _vm.p12Alias = $event.target.value
                                  },
                                },
                              }),
                              _vm._v(" "),
                              _vm.showRegExpFieldWarning(
                                _vm.p12Alias,
                                "^[a-zA-Z0-9_.-]{5,100}$"
                              )
                                ? _c(
                                    "small",
                                    {
                                      staticClass: "form-text text-danger",
                                      domProps: {
                                        textContent: _vm._s(
                                          _vm.$t(
                                            "ca3SApp.messages.password.requirement.min5NumberOrChars"
                                          )
                                        ),
                                      },
                                    },
                                    [
                                      _vm._v(
                                        "\n                                    secret must match RegEx!\n                                "
                                      ),
                                    ]
                                  )
                                : _vm._e(),
                            ]),
                            _vm._v(" "),
                            !_vm.showRegExpFieldWarning(
                              _vm.p12Alias,
                              "^[a-zA-Z0-9_.-]{5,100}$"
                            )
                              ? _c("div", { staticClass: "col colContent" }, [
                                  _c(
                                    "a",
                                    {
                                      attrs: {
                                        href: "downloadUrl",
                                        id: "pkcs12-download",
                                      },
                                      on: {
                                        click: function ($event) {
                                          $event.preventDefault()
                                          return _vm.downloadKeystore(
                                            ".p12",
                                            "application/x-pkcs12"
                                          )
                                        },
                                      },
                                    },
                                    [
                                      _vm._v(
                                        _vm._s(
                                          _vm.certificateView.downloadFilename
                                        ) + ".p12"
                                      ),
                                    ]
                                  ),
                                ])
                              : _vm._e(),
                          ]),
                          _vm._v(" "),
                          _c("div", { staticClass: "row" }, [
                            _c("div", { staticClass: "col" }, [
                              _c(
                                "label",
                                {
                                  staticClass: "form-control-label",
                                  attrs: { for: "availableUntil" },
                                  domProps: {
                                    textContent: _vm._s(
                                      _vm.$t(
                                        "ca3SApp.certificate.key.availableUntil"
                                      )
                                    ),
                                  },
                                },
                                [_vm._v("Key available until")]
                              ),
                              _vm._v(" "),
                              _vm.certificateView.serversideKeyValidTo
                                ? _c("span", [
                                    _vm._v(
                                      _vm._s(
                                        _vm.$d(
                                          Date.parse(
                                            _vm.certificateView
                                              .serversideKeyValidTo
                                          ),
                                          "short"
                                        )
                                      )
                                    ),
                                  ])
                                : _vm._e(),
                            ]),
                          ]),
                          _vm._v(" "),
                          _vm.getP12PbeAlgoArr().length > 1
                            ? _c("div", { staticClass: "row" }, [
                                _c("div", { staticClass: "col" }, [
                                  _vm.collapsed
                                    ? _c(
                                        "button",
                                        {
                                          staticClass: "addRemoveSelector",
                                          attrs: { type: "button" },
                                          on: {
                                            click: function ($event) {
                                              return _vm.setCollapsed(false)
                                            },
                                          },
                                        },
                                        [
                                          _c("font-awesome-icon", {
                                            attrs: { icon: "plus" },
                                          }),
                                        ],
                                        1
                                      )
                                    : _vm._e(),
                                  _vm._v(" "),
                                  !_vm.collapsed
                                    ? _c(
                                        "button",
                                        {
                                          staticClass: "addRemoveSelector",
                                          attrs: { type: "button" },
                                          on: {
                                            click: function ($event) {
                                              return _vm.setCollapsed(true)
                                            },
                                          },
                                        },
                                        [
                                          _c("font-awesome-icon", {
                                            attrs: { icon: "minus" },
                                          }),
                                        ],
                                        1
                                      )
                                    : _vm._e(),
                                  _vm._v(" "),
                                  !_vm.collapsed
                                    ? _c(
                                        "label",
                                        {
                                          staticClass: "form-control-label",
                                          attrs: { for: "p12Pbe" },
                                          domProps: {
                                            textContent: _vm._s(
                                              _vm.$t(
                                                "ca3SApp.certificate.download.p12pbe"
                                              )
                                            ),
                                          },
                                        },
                                        [_vm._v("PBE")]
                                      )
                                    : _vm._e(),
                                  _vm._v(" "),
                                  !_vm.collapsed
                                    ? _c(
                                        "select",
                                        {
                                          directives: [
                                            {
                                              name: "model",
                                              rawName: "v-model",
                                              value: _vm.p12Pbe,
                                              expression: "p12Pbe",
                                            },
                                          ],
                                          staticClass: "form-control",
                                          attrs: {
                                            id: "p12Pbe",
                                            name: "p12Pbe",
                                          },
                                          on: {
                                            change: function ($event) {
                                              var $$selectedVal =
                                                Array.prototype.filter
                                                  .call(
                                                    $event.target.options,
                                                    function (o) {
                                                      return o.selected
                                                    }
                                                  )
                                                  .map(function (o) {
                                                    var val =
                                                      "_value" in o
                                                        ? o._value
                                                        : o.value
                                                    return val
                                                  })
                                              _vm.p12Pbe = $event.target
                                                .multiple
                                                ? $$selectedVal
                                                : $$selectedVal[0]
                                            },
                                          },
                                        },
                                        _vm._l(
                                          _vm.getP12PbeAlgoArr(),
                                          function (algo) {
                                            return _c(
                                              "option",
                                              {
                                                key: algo,
                                                domProps: { value: algo },
                                              },
                                              [_vm._v(_vm._s(algo))]
                                            )
                                          }
                                        ),
                                        0
                                      )
                                    : _vm._e(),
                                ]),
                              ])
                            : _vm._e(),
                        ])
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.downloadFilename
                      ? _c(
                          "dt",
                          [
                            _c(
                              "span",
                              {
                                domProps: {
                                  textContent: _vm._s(
                                    _vm.$t("ca3SApp.certificate.download.pkix")
                                  ),
                                },
                              },
                              [_vm._v("Pkix")]
                            ),
                            _vm._v(" "),
                            _c("help-tag", {
                              attrs: {
                                target: "ca3SApp.certificate.download.PKIX",
                              },
                            }),
                          ],
                          1
                        )
                      : _vm._e(),
                    _vm._v(" "),
                    _vm.certificateView.downloadFilename
                      ? _c("dd", [
                          _c("div", { staticClass: "container" }, [
                            _c("div", { staticClass: "row" }, [
                              _c("div", { staticClass: "col" }, [
                                _c(
                                  "select",
                                  {
                                    directives: [
                                      {
                                        name: "model",
                                        rawName: "v-model",
                                        value: _vm.downloadFormat,
                                        expression: "downloadFormat",
                                      },
                                    ],
                                    staticClass: "form-control",
                                    attrs: {
                                      id: "download-format",
                                      name: "download-format",
                                    },
                                    on: {
                                      change: function ($event) {
                                        var $$selectedVal =
                                          Array.prototype.filter
                                            .call(
                                              $event.target.options,
                                              function (o) {
                                                return o.selected
                                              }
                                            )
                                            .map(function (o) {
                                              var val =
                                                "_value" in o
                                                  ? o._value
                                                  : o.value
                                              return val
                                            })
                                        _vm.downloadFormat = $event.target
                                          .multiple
                                          ? $$selectedVal
                                          : $$selectedVal[0]
                                      },
                                    },
                                  },
                                  [
                                    _c(
                                      "option",
                                      {
                                        attrs: {
                                          value: "pkix",
                                          selected: "selected",
                                        },
                                        domProps: {
                                          textContent: _vm._s(
                                            _vm.$t(
                                              "ca3SApp.certificate.download.PKIX"
                                            )
                                          ),
                                        },
                                      },
                                      [_vm._v("PKIX")]
                                    ),
                                    _vm._v(" "),
                                    _c(
                                      "option",
                                      {
                                        attrs: { value: "pem" },
                                        domProps: {
                                          textContent: _vm._s(
                                            _vm.$t(
                                              "ca3SApp.certificate.download.PEM"
                                            )
                                          ),
                                        },
                                      },
                                      [_vm._v("PEM")]
                                    ),
                                    _vm._v(" "),
                                    _vm.certificateView.endEntity &&
                                    _vm.certificateView.issuerId !== undefined
                                      ? _c(
                                          "option",
                                          {
                                            attrs: { value: "pemPart" },
                                            domProps: {
                                              textContent: _vm._s(
                                                _vm.$t(
                                                  "ca3SApp.certificate.download.pemPartChain"
                                                )
                                              ),
                                            },
                                          },
                                          [_vm._v("PEMPartChain")]
                                        )
                                      : _vm._e(),
                                    _vm._v(" "),
                                    _vm.certificateView.endEntity &&
                                    _vm.certificateView.issuerId !== undefined
                                      ? _c(
                                          "option",
                                          {
                                            attrs: { value: "pemFull" },
                                            domProps: {
                                              textContent: _vm._s(
                                                _vm.$t(
                                                  "ca3SApp.certificate.download.pemFullChain"
                                                )
                                              ),
                                            },
                                          },
                                          [_vm._v("PEMFullChain")]
                                        )
                                      : _vm._e(),
                                  ]
                                ),
                              ]),
                              _vm._v(" "),
                              _c("div", { staticClass: "col" }, [
                                _c(
                                  "a",
                                  {
                                    attrs: {
                                      href: "downloadUrl",
                                      id: "certificate-download",
                                    },
                                    on: {
                                      click: function ($event) {
                                        $event.preventDefault()
                                        return _vm.downloadItem()
                                      },
                                    },
                                  },
                                  [_vm._v(_vm._s(_vm.getDownloadFilename()))]
                                ),
                              ]),
                            ]),
                          ]),
                        ])
                      : _vm._e(),
                  ],
                  2
                ),
                _vm._v(" "),
                _vm.certificateView.auditPresent
                  ? _c(
                      "div",
                      [
                        _c("audit-tag", {
                          attrs: {
                            certificateId: _vm.certificateView.id,
                            csrId: _vm.certificateView.csrId,
                            showLinks: "false",
                            title: _vm.$t("ca3SApp.certificate.audit"),
                          },
                        }),
                      ],
                      1
                    )
                  : _vm._e(),
              ])
            : _vm._e(),
          _vm._v(" "),
          _c(
            "form",
            { attrs: { name: "editForm", role: "form", novalidate: "" } },
            [
              _c(
                "div",
                [
                  _vm.isTrustable()
                    ? _c("div", { staticClass: "form-group" }, [
                        _c(
                          "label",
                          {
                            staticClass: "form-control-label",
                            attrs: { for: "certificate-trusted" },
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("ca3SApp.pipeline.trusted")
                              ),
                            },
                          },
                          [_vm._v("Trusted")]
                        ),
                        _vm._v(" "),
                        _c("input", {
                          directives: [
                            {
                              name: "model",
                              rawName: "v-model",
                              value: _vm.trusted,
                              expression: "trusted",
                            },
                          ],
                          staticClass: "form-check-inline",
                          attrs: {
                            type: "checkbox",
                            name: "trusted",
                            id: "certificate-trusted",
                          },
                          domProps: {
                            checked: Array.isArray(_vm.trusted)
                              ? _vm._i(_vm.trusted, null) > -1
                              : _vm.trusted,
                          },
                          on: {
                            change: function ($event) {
                              var $$a = _vm.trusted,
                                $$el = $event.target,
                                $$c = $$el.checked ? true : false
                              if (Array.isArray($$a)) {
                                var $$v = null,
                                  $$i = _vm._i($$a, $$v)
                                if ($$el.checked) {
                                  $$i < 0 && (_vm.trusted = $$a.concat([$$v]))
                                } else {
                                  $$i > -1 &&
                                    (_vm.trusted = $$a
                                      .slice(0, $$i)
                                      .concat($$a.slice($$i + 1)))
                                }
                              } else {
                                _vm.trusted = $$c
                              }
                            },
                          },
                        }),
                      ])
                    : _vm._e(),
                  _vm._v(" "),
                  _vm._l(
                    _vm.certificateAdminData.arAttributes,
                    function (attr) {
                      return _vm.isEditable()
                        ? _c(
                            "div",
                            { key: attr.name, staticClass: "form-group" },
                            [
                              _c(
                                "label",
                                {
                                  staticClass: "form-control-label",
                                  attrs: { for: "cert-ar-" + attr.name },
                                },
                                [_vm._v(_vm._s(attr.name))]
                              ),
                              _vm._v(" "),
                              _c("input", {
                                directives: [
                                  {
                                    name: "model",
                                    rawName: "v-model",
                                    value: attr.value,
                                    expression: "attr.value",
                                  },
                                ],
                                staticClass: "form-control",
                                attrs: {
                                  type: "text",
                                  name: "cert-ar-" + attr.name,
                                  id: "cert-ar-" + attr.name,
                                },
                                domProps: { value: attr.value },
                                on: {
                                  input: function ($event) {
                                    if ($event.target.composing) return
                                    _vm.$set(attr, "value", $event.target.value)
                                  },
                                },
                              }),
                            ]
                          )
                        : _vm._e()
                    }
                  ),
                  _vm._v(" "),
                  _vm.isRevocable()
                    ? _c(
                        "div",
                        { staticClass: "form-group" },
                        [
                          _c(
                            "label",
                            {
                              staticClass: "form-control-label",
                              attrs: { for: "cert-revocationReason" },
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.certificate.revocationReason")
                                ),
                              },
                            },
                            [_vm._v("Revocation reason")]
                          ),
                          _vm._v(" "),
                          _c("help-tag", {
                            attrs: {
                              target:
                                "ca3SApp.certificate.download.revocationReason",
                            },
                          }),
                          _vm._v(" "),
                          _c(
                            "select",
                            {
                              directives: [
                                {
                                  name: "model",
                                  rawName: "v-model",
                                  value:
                                    _vm.certificateAdminData.revocationReason,
                                  expression:
                                    "certificateAdminData.revocationReason",
                                },
                              ],
                              staticClass: "form-control",
                              attrs: {
                                id: "cert-revocationReason",
                                name: "revocationReason",
                              },
                              on: {
                                change: function ($event) {
                                  var $$selectedVal = Array.prototype.filter
                                    .call($event.target.options, function (o) {
                                      return o.selected
                                    })
                                    .map(function (o) {
                                      var val =
                                        "_value" in o ? o._value : o.value
                                      return val
                                    })
                                  _vm.$set(
                                    _vm.certificateAdminData,
                                    "revocationReason",
                                    $event.target.multiple
                                      ? $$selectedVal
                                      : $$selectedVal[0]
                                  )
                                },
                              },
                            },
                            [
                              _c(
                                "option",
                                { domProps: { value: "certificateHold" } },
                                [_vm._v("certificateHold")]
                              ),
                              _vm._v(" "),
                              _c(
                                "option",
                                { domProps: { value: "keyCompromise" } },
                                [_vm._v("keyCompromise")]
                              ),
                              _vm._v(" "),
                              _c(
                                "option",
                                { domProps: { value: "cACompromise" } },
                                [_vm._v("cACompromise")]
                              ),
                              _vm._v(" "),
                              _c(
                                "option",
                                { domProps: { value: "affiliationChanged" } },
                                [_vm._v("affiliationChanged")]
                              ),
                              _vm._v(" "),
                              _c(
                                "option",
                                { domProps: { value: "superseded" } },
                                [_vm._v("superseded")]
                              ),
                              _vm._v(" "),
                              _c(
                                "option",
                                { domProps: { value: "cessationOfOperation" } },
                                [_vm._v("cessationOfOperation")]
                              ),
                              _vm._v(" "),
                              _c(
                                "option",
                                { domProps: { value: "privilegeWithdrawn" } },
                                [_vm._v("privilegeWithdrawn")]
                              ),
                              _vm._v(" "),
                              _c(
                                "option",
                                { domProps: { value: "unspecified" } },
                                [_vm._v("unspecified")]
                              ),
                            ]
                          ),
                        ],
                        1
                      )
                    : _vm._e(),
                  _vm._v(" "),
                  _c(
                    "div",
                    { staticClass: "form-group" },
                    [
                      _c(
                        "label",
                        {
                          staticClass: "form-control-label",
                          attrs: { for: "comment" },
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.certificate.comment")
                            ),
                          },
                        },
                        [_vm._v("Comment")]
                      ),
                      _vm._v(" "),
                      _c("help-tag", {
                        attrs: { target: "ca3SApp.certificate.comment" },
                      }),
                      _vm._v(" "),
                      _vm.isRAOrAdmin() || _vm.isOwnCertificate()
                        ? _c("textarea", {
                            directives: [
                              {
                                name: "model",
                                rawName: "v-model",
                                value: _vm.comment,
                                expression: "comment",
                              },
                            ],
                            staticClass: "form-control",
                            attrs: {
                              name: "content",
                              id: "comment",
                              autocomplete: "off",
                              autocorrect: "off",
                              autocapitalize: "off",
                              spellcheck: "false",
                            },
                            domProps: { value: _vm.comment },
                            on: {
                              input: function ($event) {
                                if ($event.target.composing) return
                                _vm.comment = $event.target.value
                              },
                            },
                          })
                        : _c("textarea", {
                            directives: [
                              {
                                name: "model",
                                rawName: "v-model",
                                value: _vm.comment,
                                expression: "comment",
                              },
                            ],
                            staticClass: "form-control",
                            attrs: {
                              name: "content",
                              id: "comment",
                              autocomplete: "off",
                              autocorrect: "off",
                              autocapitalize: "off",
                              spellcheck: "false",
                              readonly: "true",
                            },
                            domProps: { value: _vm.comment },
                            on: {
                              input: function ($event) {
                                if ($event.target.composing) return
                                _vm.comment = $event.target.value
                              },
                            },
                          }),
                    ],
                    1
                  ),
                  _vm._v(" "),
                  _c(
                    "b-alert",
                    {
                      attrs: {
                        show: _vm.dismissCountDown,
                        dismissible: "",
                        variant: _vm.alertType,
                      },
                      on: {
                        dismissed: function ($event) {
                          _vm.dismissCountDown = 0
                        },
                        "dismiss-count-down": _vm.countDownChanged,
                      },
                    },
                    [
                      _vm._v(
                        "\n                        " +
                          _vm._s(_vm.alertMessage) +
                          "\n                    "
                      ),
                    ]
                  ),
                  _vm._v(" "),
                  _c(
                    "button",
                    {
                      staticClass: "btn btn-info",
                      attrs: { type: "submit" },
                      on: {
                        click: function ($event) {
                          $event.preventDefault()
                          return _vm.previousState()
                        },
                      },
                    },
                    [
                      _c("font-awesome-icon", {
                        attrs: { icon: "arrow-left" },
                      }),
                      _vm._v(" "),
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(_vm.$t("entity.action.back")),
                          },
                        },
                        [_vm._v(" Back")]
                      ),
                    ],
                    1
                  ),
                  _vm._v(" "),
                  _vm.isOwnCertificate() && !_vm.isRAOrAdmin()
                    ? _c(
                        "button",
                        {
                          staticClass: "btn btn-secondary",
                          attrs: { type: "button", id: "edit" },
                          on: {
                            click: function ($event) {
                              return _vm.selfAdministerCertificate()
                            },
                          },
                        },
                        [
                          _c("font-awesome-icon", {
                            attrs: { icon: "pencil-alt" },
                          }),
                          _vm._v(" "),
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("entity.action.update")
                                ),
                              },
                            },
                            [_vm._v("Update")]
                          ),
                        ],
                        1
                      )
                    : _vm._e(),
                  _vm._v(" "),
                  _vm.isRAOrAdmin() && _vm.isValuesChanged()
                    ? _c(
                        "button",
                        {
                          staticClass: "btn btn-secondary",
                          attrs: { type: "button", id: "update" },
                          on: {
                            click: function ($event) {
                              return _vm.updateCertificate()
                            },
                          },
                        },
                        [
                          _c("font-awesome-icon", {
                            attrs: { icon: "pencil-alt" },
                          }),
                          _vm._v(" "),
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("entity.action.update")
                                ),
                              },
                            },
                            [_vm._v("Update")]
                          ),
                        ],
                        1
                      )
                    : _vm._e(),
                  _vm._v(" "),
                  _vm.isRAOfficer()
                    ? _c(
                        "button",
                        {
                          staticClass: "btn btn-secondary",
                          attrs: { type: "button", id: "updateCrl" },
                          on: {
                            click: function ($event) {
                              return _vm.updateCRL()
                            },
                          },
                        },
                        [
                          _c("font-awesome-icon", {
                            attrs: { icon: "pencil-alt" },
                          }),
                          _vm._v(" "),
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("entity.action.updateCrl")
                                ),
                              },
                            },
                            [_vm._v("Update CRL")]
                          ),
                        ],
                        1
                      )
                    : _vm._e(),
                  _vm._v(" "),
                  _vm.isRemovableFromCRL()
                    ? _c(
                        "button",
                        {
                          staticClass: "btn btn-secondary",
                          attrs: { type: "button", id: "removeFromCRL" },
                          on: {
                            click: function ($event) {
                              return _vm.removeCertificateFromCRL()
                            },
                          },
                        },
                        [
                          _c("font-awesome-icon", { attrs: { icon: "ban" } }),
                          _vm._v(" "),
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t(
                                    "entity.action.removeCertificateFromCRL"
                                  )
                                ),
                              },
                            },
                            [_vm._v("Remove from CRL")]
                          ),
                        ],
                        1
                      )
                    : _vm._e(),
                  _vm._v(" "),
                  (_vm.isRAOfficer() || _vm.isOwnCertificate()) &&
                  _vm.isRevocable()
                    ? _c(
                        "b-button",
                        {
                          directives: [
                            {
                              name: "b-modal",
                              rawName: "v-b-modal.revokeCertificate",
                              modifiers: { revokeCertificate: true },
                            },
                          ],
                          staticClass: "btn",
                          attrs: { variant: "danger" },
                        },
                        [
                          _c("font-awesome-icon", { attrs: { icon: "times" } }),
                          _vm._v(" "),
                          _c(
                            "span",
                            {
                              staticClass: "d-none d-md-inline",
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("entity.action.revoke")
                                ),
                              },
                            },
                            [_vm._v("Revoke")]
                          ),
                        ],
                        1
                      )
                    : _vm._e(),
                ],
                2
              ),
            ]
          ),
        ]),
      ]),
      _vm._v(" "),
      _c(
        "b-modal",
        { ref: "revokeCertificate", attrs: { id: "revokeCertificate" } },
        [
          _c("span", { attrs: { slot: "modal-title" }, slot: "modal-title" }, [
            _c(
              "span",
              {
                attrs: { id: "ca3SApp.certificate.revoke.question" },
                domProps: {
                  textContent: _vm._s(_vm.$t("entity.revoke.title")),
                },
              },
              [_vm._v("Confirm revocation")]
            ),
          ]),
          _vm._v(" "),
          _c("div", { staticClass: "modal-body" }, [
            _vm.certificateView.ca
              ? _c(
                  "div",
                  {
                    staticClass: "alert alert-warning",
                    attrs: { role: "alert" },
                  },
                  [
                    _c(
                      "p",
                      {
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.certificate.ca.hint")
                          ),
                        },
                      },
                      [_vm._v("This is a CA certificate!")]
                    ),
                  ]
                )
              : _vm._e(),
            _vm._v(" "),
            _vm.certificateView.issuingActiveCertificates
              ? _c(
                  "div",
                  {
                    staticClass: "alert alert-danger",
                    attrs: { role: "alert" },
                  },
                  [
                    _c(
                      "p",
                      {
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t(
                              "ca3SApp.certificate.no.revocation.active.issued"
                            )
                          ),
                        },
                      },
                      [_vm._v("Has active issued certificates")]
                    ),
                  ]
                )
              : _vm._e(),
            _vm._v(" "),
            _c(
              "p",
              {
                attrs: { id: "jhi-revoke-certificate-heading" },
                domProps: {
                  textContent: _vm._s(
                    _vm.$t("ca3SApp.certificate.revoke.question", {
                      id: _vm.certificateView.id,
                    })
                  ),
                },
              },
              [_vm._v("Are you sure you want to revoke this certificate?")]
            ),
          ]),
          _vm._v(" "),
          _c("div", { attrs: { slot: "modal-footer" }, slot: "modal-footer" }, [
            _c(
              "button",
              {
                staticClass: "btn btn-secondary",
                attrs: { type: "button" },
                domProps: {
                  textContent: _vm._s(_vm.$t("entity.action.cancel")),
                },
                on: {
                  click: function ($event) {
                    return _vm.closeDialog()
                  },
                },
              },
              [_vm._v("Cancel")]
            ),
            _vm._v(" "),
            !_vm.certificateView.issuingActiveCertificates
              ? _c(
                  "button",
                  {
                    staticClass: "btn btn-primary",
                    attrs: { type: "button", id: "confirm-revoke-certificate" },
                    domProps: {
                      textContent: _vm._s(_vm.$t("entity.action.revoke")),
                    },
                    on: {
                      click: function ($event) {
                        return _vm.revokeCertificateAndClose()
                      },
                    },
                  },
                  [_vm._v("Revoke")]
                )
              : _vm._e(),
          ]),
        ]
      ),
    ],
    1
  )
}
var staticRenderFns = []
render._withStripped = true



/***/ })

}]);
//# sourceMappingURL=src_main_webapp_app_core_cert-list_cert-info_vue.82eba56701cca3f57b55.chunk.js.map