/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ClientAuthConfig {
    private final Logger LOG = LoggerFactory.getLogger(ClientAuthConfig.class);
    @Value(value="${ca3s.tlsClientAuth..port:8442}")
    int tlsClientAuthPort;
    @Value(value="${ca3s.tlsClientAuth..external.port:#{null}}")
    Integer tlsClientAuthExternalPort;
    @Value(value="${ca3s.tlsClientAuth..external.host:#{null}}")
    String tlsClientAuthHost;

    public boolean isTlsClientAuthActive() {
        return this.tlsClientAuthPort != 0;
    }

    public String getClientAuthTarget() {
        String host = this.tlsClientAuthHost;
        if (this.tlsClientAuthHost == null) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.LOG.info("Problem resolving hostname for TLSClientAuth Cors", (Throwable)e);
                host = "localhost";
            }
        }
        String clientAuthTarget = this.tlsClientAuthExternalPort == null ? "https://" + host + ":" + this.tlsClientAuthPort : "https://" + host + ":" + this.tlsClientAuthExternalPort;
        this.LOG.info("ClientAuthTarget : {}", (Object)clientAuthTarget);
        return clientAuthTarget;
    }
}

