/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.config.saml;

import java.net.URI;
import java.net.URISyntaxException;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.websso.WebSSOProfileImpl;

public class CustomWebSSOProfileImpl
extends WebSSOProfileImpl {
    private final Logger LOG = LoggerFactory.getLogger(CustomWebSSOProfileImpl.class);
    private final URI targetAddressURI;

    public CustomWebSSOProfileImpl(URI targetAddressURI) {
        this.targetAddressURI = targetAddressURI;
    }

    protected void buildReturnAddress(AuthnRequest request, AssertionConsumerService service) throws MetadataProviderException {
        this.LOG.info("Current SAML service location '{}'", (Object)service.getLocation());
        super.buildReturnAddress(request, service);
        if (this.targetAddressURI != null) {
            try {
                URI returnAddressURL = new URI(request.getAssertionConsumerServiceURL());
                URI normalizedAddressURL = new URI(this.targetAddressURI.getScheme(), returnAddressURL.getUserInfo(), this.targetAddressURI.getHost(), this.targetAddressURI.getPort(), returnAddressURL.getPath(), returnAddressURL.getQuery(), returnAddressURL.getFragment());
                request.setAssertionConsumerServiceURL(normalizedAddressURL.toString());
            }
            catch (URISyntaxException e) {
                this.LOG.error("AssertionConsumerServiceURL could not be parsed! Ignoring the value.", (Throwable)e);
            }
        }
    }
}

