/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.schedule.ProtectedContentScheduleUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ProtectedContentCleanupScheduler {
    private final int maxRecordsPerTransaction;
    private final ProtectedContentScheduleUtil protectedContentScheduleUtil;

    public ProtectedContentCleanupScheduler(@Value(value="${ca3s.batch.maxRecordsPerTransaction:1000}") int maxRecordsPerTransaction, ProtectedContentScheduleUtil protectedContentScheduleUtil) {
        this.protectedContentScheduleUtil = protectedContentScheduleUtil;
        this.maxRecordsPerTransaction = maxRecordsPerTransaction;
    }

    @Scheduled(fixedRateString="${ca3s.schedule.rate.protectedContentCleanup:600000}")
    public void runDaily() {
        this.protectedContentScheduleUtil.invalidateCSRsWithExpiringPC(this.maxRecordsPerTransaction);
        this.protectedContentScheduleUtil.deleteExpiredElements(this.maxRecordsPerTransaction);
    }
}

