/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.util.CSRUtil;
import java.time.Instant;
import java.util.Optional;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ProtectedContentScheduleUtil {
    private final Logger log = LoggerFactory.getLogger(ProtectedContentScheduleUtil.class);
    private final ProtectedContentRepository protContentRepository;
    private final CSRRepository csrRepository;
    private final CSRUtil csrUtil;
    private final AuditService auditService;

    public ProtectedContentScheduleUtil(ProtectedContentRepository protContentRepository, CSRRepository csrRepository, CSRUtil csrUtil, AuditService auditService) {
        this.protContentRepository = protContentRepository;
        this.csrRepository = csrRepository;
        this.csrUtil = csrUtil;
        this.auditService = auditService;
    }

    @Transactional
    public void invalidateCSRsWithExpiringPC(int maxRecordsPerTransaction) {
        Page invalidList = this.protContentRepository.findByValidToPassed((Pageable)PageRequest.of((int)0, (int)maxRecordsPerTransaction), Instant.now());
        for (ProtectedContent pc : invalidList) {
            CSR csr;
            Optional optCsr;
            if (!ContentRelationType.CSR.equals((Object)pc.getRelationType()) || !(optCsr = this.csrRepository.findById((Object)pc.getRelatedId())).isPresent() || !CsrStatus.PENDING.equals((Object)(csr = (CSR)optCsr.get()).getStatus())) continue;
            this.csrUtil.setStatusAndRejectionReason(csr, CsrStatus.REJECTED, "created key for csr expired");
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrRejected(csr, "created key for csr expired"));
        }
    }

    @Transactional
    public void deleteExpiredElements(int maxRecordsPerTransaction) {
        Page expiredList = this.protContentRepository.findByDeleteAfterPassed((Pageable)PageRequest.of((int)0, (int)maxRecordsPerTransaction), Instant.now());
        if (!expiredList.isEmpty()) {
            this.log.info("deleting #{} expired ProtectedContent objects", (Object)expiredList.getNumberOfElements());
            for (ProtectedContent pc : expiredList) {
                this.log.debug("delete protected content due to passed deletion date: {}", (Object)pc);
            }
            this.protContentRepository.deleteAll((Iterable)expiredList);
        }
    }
}

