/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.security;

import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.enumeration.AuthSecondFactor;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.security.UserCredentialsExpiredException;
import de.trustable.ca3s.core.security.UserNotActivatedException;
import de.trustable.ca3s.core.service.exception.BlockedCredentialsException;
import de.trustable.ca3s.core.service.util.UserUtil;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="userDetailsService")
public class DomainUserDetailsService
implements UserDetailsService {
    private final Logger log = LoggerFactory.getLogger(DomainUserDetailsService.class);
    private final UserRepository userRepository;
    private final UserUtil userUtil;

    public DomainUserDetailsService(UserRepository userRepository, UserUtil userUtil) {
        this.userRepository = userRepository;
        this.userUtil = userUtil;
    }

    @Transactional
    public UserDetails loadUserByUsername(String login) {
        this.log.debug("----------- Authenticating {}", (Object)login);
        if (login.startsWith("Kerberos@@")) {
            String username = login.substring(10);
            return new org.springframework.security.core.userdetails.User(username, "KerberosToken", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
        }
        return this.createSpringSecurityUser(login, this.userUtil.getUserByLogin(login));
    }

    private org.springframework.security.core.userdetails.User createSpringSecurityUser(String login, User user) {
        this.log.info("user {}, isActive {}, failed logins {}, blocked until {}, credentials valid until {}", new Object[]{login, user.isActivated(), user.getFailedLogins(), user.getBlockedUntilDate(), user.getCredentialsValidToDate()});
        if (!user.isActivated()) {
            throw new UserNotActivatedException("User " + login + " was not activated");
        }
        Instant now = Instant.now();
        if (user.getBlockedUntilDate() != null && user.getBlockedUntilDate().isAfter(now)) {
            this.userUtil.handleBadCredentials(login, AuthSecondFactor.NONE);
            throw new BlockedCredentialsException("User '" + login + "' blocked until " + user.getBlockedUntilDate());
        }
        if (user.getCredentialsValidToDate() != null && user.getCredentialsValidToDate().isBefore(now)) {
            throw new UserCredentialsExpiredException("User " + login + " credentials expired since " + user.getCredentialsValidToDate());
        }
        List grantedAuthorities = user.getAuthorities().stream().map(authority -> new SimpleGrantedAuthority(authority.getName())).collect(Collectors.toList());
        return new org.springframework.security.core.userdetails.User(user.getLogin(), user.getPassword(), grantedAuthorities);
    }
}

