/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.service.NotificationService;
import java.util.Set;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AsyncNotificationService {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncNotificationService.class);
    private final NotificationService notificationService;

    public AsyncNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Async
    public void notifyRAOfficerOnRequestAsync(CSR csr) {
        try {
            this.notificationService.notifyRAOfficerOnRequest(csr);
        }
        catch (Exception e) {
            LOG.error("problem sending ra officer notification", (Throwable)e);
        }
    }

    @Async
    public void notifyUserCertificateIssuedAsync(User requestor, Certificate cert, Set<String> additionalEmailSet) {
        try {
            this.notificationService.notifyUserCertificateIssued(requestor, cert, additionalEmailSet);
        }
        catch (MessagingException e) {
            LOG.error("problem sending user notification for issued cert", (Throwable)e);
        }
    }

    @Async
    public void notifyUserCertificateRejectedAsync(User requestor, CSR csr, Set<String> additionalEmailSet) {
        try {
            this.notificationService.notifyUserCertificateRejected(requestor, csr, additionalEmailSet);
        }
        catch (MessagingException e) {
            LOG.error("problem sending user notification for rejected request", (Throwable)e);
        }
    }

    @Async
    public void notifyUserCertificateRevokedAsync(User requestor, Certificate cert, CSR csr, Set<String> additionalEmailSet) {
        try {
            this.notificationService.notifyCertificateRevoked(requestor, cert, csr, additionalEmailSet);
        }
        catch (MessagingException e) {
            LOG.error("problem sending user notification for revoked certificate", (Throwable)e);
        }
    }

    @Async
    public void notifyRAOfficerOnUserRevocation(Certificate cert) {
        this.notificationService.notifyRAOfficerOnUserRevocation(cert);
    }
}

