/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.AuditTrace;
import de.trustable.ca3s.core.domain.BPMNProcessInfo;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.RequestProxyConfig;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.AuditTraceRepository;
import de.trustable.ca3s.core.service.util.NameAndRole;
import de.trustable.ca3s.core.service.util.NameAndRoleUtil;
import de.trustable.util.CryptoUtil;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuditService {
    public static final String AUDIT_CA3S_STARTED = "CA3S_STARTED";
    public static final String AUDIT_CA3S_STOPPED = "CA3S_STOPPED";
    public static final String AUDIT_EXPIRY_NOTIFICATION_SENT = "EXPIRY_NOTIFICATION_SENT";
    public static final String AUDIT_CSR_ACCEPTED = "CSR_ACCEPTED";
    public static final String AUDIT_CSR_REJECTED = "CSR_REJECTED";
    public static final String AUDIT_CSR_SIGNING_FAILED = "CSR_SIGNING_FAILED";
    public static final String AUDIT_WEB_CERTIFICATE_REQUESTED = "WEB_CERTIFICATE_REQUESTED";
    public static final String AUDIT_WEB_CERTIFICATE_AUTO_ACCEPTED = "WEB_CERTIFICATE_AUTO_ACCEPTED";
    public static final String AUDIT_ACME_CERTIFICATE_REQUESTED = "ACME_CERTIFICATE_REQUESTED";
    public static final String AUDIT_ACME_CHALLENGE_FAILED = "ACME_CHALLENGE_FAILED";
    public static final String AUDIT_ACME_CHALLENGE_SUCCEEDED = "ACME_CHALLENGE_SUCCEEDED";
    public static final String AUDIT_ACME_ORDER_SUCCEEDED = "ACME_ORDER_SUCCEEDED";
    public static final String AUDIT_ACME_ORDER_INVALID = "ACME_ORDER_INVALID";
    public static final String AUDIT_ACME_ORDER_EXPIRED = "ACME_ORDER_EXPIRED";
    public static final String AUDIT_ACME_CERTIFICATE_CREATED = "ACME_CERTIFICATE_CREATED";
    public static final String AUDIT_SCEP_CERTIFICATE_REQUESTED = "SCEP_CERTIFICATE_REQUESTED";
    public static final String AUDIT_SCEP_CERTIFICATE_CREATED = "SCEP_CERTIFICATE_CREATED";
    public static final String AUDIT_RA_CERTIFICATE_CREATED = "RA_CERTIFICATE_CREATED";
    public static final String AUDIT_REQUEST_RESTRICTIONS_FAILED = "REQUEST_RESTRICTIONS_FAILED";
    public static final String AUDIT_WEB_CERTIFICATE_CREATED = "WEB_CERTIFICATE_CREATED";
    public static final String AUDIT_CERTIFICATE_REVOKED = "CERTIFICATE_REVOKED";
    public static final String AUDIT_CERTIFICATE_REVOKED_BY_CRL = "CERTIFICATE_REVOKED_BY_CRL";
    public static final String AUDIT_MANUAL_CERTIFICATE_IMPORTED = "MANUAL_CERTIFICATE_IMPORTED";
    public static final String AUDIT_ADCS_CERTIFICATE_IMPORTED = "ADCS_CERTIFICATE_IMPORTED";
    public static final String AUDIT_TLS_CERTIFICATE_IMPORTED = "TLS_CERTIFICATE_IMPORTED";
    public static final String AUDIT_TLS_INTERMEDIATE_CERTIFICATE_IMPORTED = "TLS_INTERMEDIATE_CERTIFICATE_IMPORTED";
    public static final String AUDIT_CERTIFICATE_SET_TRUSTED_BY_DIRECTORY_IMPORT = "CERTIFICATE_SET_TRUSTED_BY_DIRECTORY_IMPORT";
    public static final String AUDIT_CERTIFICATE_SET_TRUSTED = "CERTIFICATE_SET_TRUSTED";
    public static final String AUDIT_CERTIFICATE_UNSET_TRUSTED = "CERTIFICATE_UNSET_TRUSTED";
    public static final String AUDIT_PIPELINE_ATTRIBUTE_CHANGED = "PIPELINE_ATTRIBUTE_CHANGED";
    public static final String AUDIT_PIPELINE_PROXY_ADDED = "PIPELINE_PROXY_ADDED";
    public static final String AUDIT_PIPELINE_PROXY_REMOVED = "PIPELINE_PROXY_REMOVED";
    public static final String AUDIT_CSR_ATTRIBUTE_CHANGED = "CSR_ATTRIBUTE_CHANGED";
    public static final String AUDIT_CSR_COMMENT_CHANGED = "CSR_COMMENT_CHANGED";
    public static final String AUDIT_CERTIFICATE_IMPORTED = "CERTIFICATE_IMPORTED";
    public static final String AUDIT_CERTIFICATE_ATTRIBUTE_CHANGED = "CERTIFICATE_ATTRIBUTE_CHANGED";
    public static final String AUDIT_EMAIL_SEND_NOTIFICATION_SENT = "EMAIL_SEND_NOTIFICATION_SENT";
    public static final String AUDIT_EMAIL_SEND_NOTIFICATION_FAILED = "EMAIL_SEND_NOTIFICATION_FAILED";
    public static final String AUDIT_PREFERENCE_CREATED = "PREFERENCE_CREATED";
    public static final String AUDIT_PREFERENCE_UPDATED = "PREFERENCE_UPDATED";
    public static final String AUDIT_PIPELINE_CREATED = "PIPELINE_CREATED";
    public static final String AUDIT_PIPELINE_COPIED = "PIPELINE_COPIED";
    public static final String AUDIT_PIPELINE_DELETED = "PIPELINE_DELETED";
    public static final String AUDIT_PIPELINE_NAME_CHANGED = "PIPELINE_NAME_CHANGED";
    public static final String AUDIT_PIPELINE_DESCRIPTION_CHANGED = "PIPELINE_DESCRIPTION_CHANGED";
    public static final String AUDIT_PIPELINE_TYPE_CHANGED = "PIPELINE_TYPE_CHANGED";
    public static final String AUDIT_PIPELINE_URLPART_CHANGED = "PIPELINE_URLPART_CHANGED";
    public static final String AUDIT_PIPELINE_APPROVAL_REQUIRED_CHANGED = "PIPELINE_APPROVAL_REQUIRED_CHANGED";
    public static final String AUDIT_PIPELINE_ACTIVE_CHANGED = "PIPELINE_ACTIVE_CHANGED";
    public static final String AUDIT_CRAWLER_CERTIFICATE_IMPORTED = "CRAWLER_CERTIFICATE_IMPORTED";
    public static final String AUDIT_DIRECTORY_CERTIFICATE_IMPORTED = "DIRECTORY_CERTIFICATE_IMPORTED";
    public static final String AUDIT_CA_CONNECTOR_CREATED = "CA_CONNECTOR_CREATED";
    public static final String AUDIT_CA_CONNECTOR_COPIED = "CA_CONNECTOR_COPIED";
    public static final String AUDIT_CA_CONNECTOR_DELETED = "CA_CONNECTOR_DELETED";
    public static final String AUDIT_CA_CONNECTOR_ATTRIBUTE_CHANGED = "CA_CONNECTOR_ATTRIBUTE_CHANGED";
    public static final String AUDIT_REQUEST_PROXY_ATTRIBUTE_CHANGED = "REQUEST_PROXY_ATTRIBUTE_CHANGED";
    public static final String AUDIT_CERTIFICATE_SCHEMA_UPDATED = "CERTIFICATE_SCHEMA_UPDATED";
    public static final String AUDIT_CERTIFICATE_PKCS12_DOWNLOAD = "AUDIT_CERTIFICATE_PKCS12_DOWNLOAD";
    public static final String AUDIT_ACME_ORDER_PIPELINE_UPDATED = "AUDIT_ACME_ORDER_PIPELINE_UPDATED";
    public static final String AUDIT_ACME_ACCOUNT_CREATED_OR_UPDATED = "AUDIT_ACME_ACCOUNT_CREATED_OR_UPDATED";
    public static final String AUDIT_CA_CONNECTOR_NAME_CHANGED = "AUDIT_ACME_ACCOUNT_CREATED_OR_UPDATED";
    public static final String AUDIT_CA_CONNECTOR_TYPE_CHANGED = "AUDIT_CA_CONNECTOR_TYPE_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_ACTIVE_CHANGED = "AUDIT_CA_CONNECTOR_ACTIVE_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_CA_URL_CHANGED = "AUDIT_CA_CONNECTOR_CA_URL_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_INTERVAL_CHANGED = "AUDIT_CA_CONNECTOR_INTERVAL_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_IS_DEFAULT_CHANGED = "AUDIT_CA_CONNECTOR_IS_DEFAULT_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_POLLING_OFFSET_CHANGED = "AUDIT_CA_CONNECTOR_POLLING_OFFSET_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_SELECTOR_CHANGED = "AUDIT_CA_CONNECTOR_SELECTOR_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_TRUST_SELFSIGNED_CHANGED = "AUDIT_CA_CONNECTOR_TRUST_SELFSIGNED_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_TLS_AUTHENTICATION_CHANGED = "AUDIT_CA_CONNECTOR_TLS_AUTHENTICATION_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_MESSAGE_PROTECTION_CHANGED = "AUDIT_CA_CONNECTOR_MESSAGE_PROTECTION_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_SECRET_CHANGED = "AUDIT_CA_CONNECTOR_SECRET_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_SECRET_DELETED = "AUDIT_CA_CONNECTOR_SECRET_DELETED";
    public static final String AUDIT_CA_CONNECTOR_ISSUER_NAME_CHANGED = "AUDIT_CA_CONNECTOR_ISSUER_NAME_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_MULTIPLE_MESSAGES_CHANGED = "AUDIT_CA_CONNECTOR_MULTIPLE_MESSAGES_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_IMPLICIT_CONFIRM_CHANGED = "AUDIT_CA_CONNECTOR_IMPLICIT_CONFIRM_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_MSG_CONTENT_TYPE_CHANGED = "AUDIT_CA_CONNECTOR_MSG_CONTENT_TYPE_CHANGED";
    public static final String AUDIT_BPMN_CREATED = "AUDIT_BPMN_CREATED";
    public static final String AUDIT_BPMN_NAME_CHANGED = "AUDIT_BPMN_NAME_CHANGED";
    public static final String AUDIT_BPMN_TYPE_CHANGED = "AUDIT_BPMN_TYPE_CHANGED";
    public static final String AUDIT_BPMN_AUTHOR_CHANGED = "AUDIT_BPMN_AUTHOR_CHANGED";
    public static final String AUDIT_BPMN_VERSION_CHANGED = "AUDIT_BPMN_VERSION_CHANGED";
    public static final String AUDIT_BPMN_PROCESS_ID_CHANGED = "AUDIT_BPMN_PROCESS_ID_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_SNI_CHANGED = "AUDIT_CA_CONNECTOR_SNI_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_DISABLE_HOST_NAME_VERIFIER_CHANGED = "AUDIT_CA_CONNECTOR_DISABLE_HOST_NAME_VERIFIER_CHANGED";
    public static final String AUDIT_CA_CONNECTOR_IGNORE_RESPONSE_MESSAGE_VERIFICATION_CHANGED = "AUDIT_CA_CONNECTOR_IGNORE_RESPONSE_MESSAGE_VERIFICATION_CHANGED";
    public static final String AUDIT_CERTIFICATE_ADMINISTRATION_FAILED = "AUDIT_CERTIFICATE_ADMINISTRATION_FAILED";
    public static final String AUDIT_FILL_EMPTY_SUBJECT_WITH_SAN_CHANGED = "AUDIT_FILL_EMPTY_SUBJECT_WITH_SAN_CHANGED";
    public static final String AUDIT_BPMN_ATTRIBUTE_CHANGED = "AUDIT_BPMN_ATTRIBUTE_CHANGED";
    private static final String AUDIT_USER_LOGIN_SUCEEDED = "AUDIT_USER_LOGIN_SUCEEDED";
    private static final String AUDIT_USER_LOGIN_FAILED = "AUDIT_USER_LOGIN_FAILED";
    private static final String AUDIT_USER_LOGIN_BLOCKED = "AUDIT_USER_LOGIN_BLOCKED";
    private static final String AUDIT_USER_LOGIN_FOR_IP_BLOCKED = "AUDIT_USER_LOGIN_FOR_IP_BLOCKED";
    private final Logger log = LoggerFactory.getLogger(AuditService.class);
    private final AuditTraceRepository auditTraceRepository;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final NameAndRoleUtil nameAndRoleUtil;

    public AuditService(AuditTraceRepository auditTraceRepository, ApplicationEventPublisher applicationEventPublisher, NameAndRoleUtil nameAndRoleUtil) {
        this.auditTraceRepository = auditTraceRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.nameAndRoleUtil = nameAndRoleUtil;
    }

    public AuditTrace createAuditTraceStarted() {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CA3S_STARTED, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceStopped() {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CA3S_STOPPED, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceExpiryNotificationSent(int nExpiringCertificates) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_EXPIRY_NOTIFICATION_SENT, null, null, "" + nExpiringCertificates, null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceCsrAccepted(CSR csr) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTraceRequest(nar.getName(), nar.getRole(), AUDIT_CSR_ACCEPTED, csr);
    }

    public AuditTrace createAuditTraceCsrRejected(CSR csr) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTraceRequest(nar.getName(), nar.getRole(), AUDIT_CSR_REJECTED, csr);
    }

    public AuditTrace createAuditTraceCsrRejected(CSR csr, String reason) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CSR_REJECTED, reason, null, null, csr, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceCsrSigningFailed(CSR csr, String reason) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CSR_SIGNING_FAILED, reason, null, null, csr, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceACMERequest(CSR csr) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTraceRequest(nar.getName(), nar.getRole(), AUDIT_ACME_CERTIFICATE_REQUESTED, csr);
    }

    public AuditTrace createAuditTraceAcmeOrderSucceeded(AcmeAccount acmeAccount, AcmeOrder acmeOrder) {
        return this.createAuditTraceACMEInfo(acmeAccount, acmeOrder, null, AUDIT_ACME_ORDER_SUCCEEDED, null);
    }

    public AuditTrace createAuditTraceACMEOrderExpired(AcmeOrder acmeOrder) {
        return this.createAuditTraceACMEInfo(acmeOrder.getAccount(), acmeOrder, null, AUDIT_ACME_ORDER_EXPIRED, null);
    }

    public AuditTrace createAuditTraceAcmeChallengeSucceeded(AcmeAccount acmeAccount, AcmeOrder acmeOrder, String msg) {
        return this.createAuditTraceACMEInfo(acmeAccount, acmeOrder, null, AUDIT_ACME_CHALLENGE_SUCCEEDED, msg);
    }

    public AuditTrace createAuditTraceAcmeChallengeFailed(AcmeAccount acmeAccount, AcmeOrder acmeOrder, String msg) {
        return this.createAuditTraceACMEInfo(acmeAccount, acmeOrder, null, AUDIT_ACME_CHALLENGE_FAILED, msg);
    }

    public AuditTrace createAuditTraceAcmeOrderExpired(AcmeAccount acmeAccount, AcmeOrder acmeOrder) {
        return this.createAuditTraceACMEInfo(acmeAccount, acmeOrder, null, AUDIT_ACME_ORDER_EXPIRED, null);
    }

    public AuditTrace createAuditTraceAcmeOrderInvalid(AcmeAccount acmeAccount, AcmeOrder acmeOrder, CSR csr, String msg) {
        return this.createAuditTraceACMEInfo(acmeAccount, acmeOrder, csr, AUDIT_ACME_ORDER_INVALID, msg);
    }

    public AuditTrace createAuditTraceACMEInfo(AcmeAccount acmeAccount, AcmeOrder acmeOrder, CSR csr, String template, String msg) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, null, null, msg, csr, null, null, null, null, acmeAccount, acmeOrder, null);
    }

    public AuditTrace createAuditTraceWebRequest(CSR csr) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTraceRequest(nar.getName(), nar.getRole(), AUDIT_WEB_CERTIFICATE_REQUESTED, csr);
    }

    public AuditTrace createAuditTraceWebAutoAccepted(CSR csr) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTraceRequest(nar.getName(), nar.getRole(), AUDIT_WEB_CERTIFICATE_AUTO_ACCEPTED, csr);
    }

    public AuditTrace createAuditTraceCsrRestrictionFailed(CSR csr) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTraceRequest(nar.getName(), nar.getRole(), AUDIT_REQUEST_RESTRICTIONS_FAILED, csr);
    }

    public AuditTrace createAuditTraceRequest(String actor, String actorRole, String template, CSR csr) {
        return this.createAuditTrace(actor, actorRole, template, csr, null, null, null, null);
    }

    public AuditTrace createAuditTraceRequest(String template, CSR csr) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, csr, null, null, null, null);
    }

    public AuditTrace createAuditTraceCertificate(String template, Certificate certificate) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, null, certificate, null, null, null);
    }

    public AuditTrace createAuditTraceCertificate(String template, String info, Certificate certificate) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, info, null, null, null, certificate, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceSystemPreferenceCreated(String name, String value) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_PREFERENCE_CREATED, name, null, value, null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceSystemPreferenceUpdated(String name, String oldValue, String newValue) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_PREFERENCE_CREATED, name, oldValue, newValue, null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceCAConfigCreated(CAConnectorConfig caConnectorConfig) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CA_CONNECTOR_CREATED, null, caConnectorConfig.getName(), null, null, null, caConnectorConfig, null);
    }

    public AuditTrace createAuditTraceCAConfigDeleted(CAConnectorConfig caConnectorConfig) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CA_CONNECTOR_DELETED, null, caConnectorConfig.getName(), null, null, null, caConnectorConfig, null);
    }

    public AuditTrace createAuditTraceCAConfigSecretChanged(CAConnectorConfig caConnectorConfig) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), caConnectorConfig.getName(), null, null, null, caConnectorConfig, null);
    }

    public AuditTrace createAuditTraceCaConnectorConfig(String template, CAConnectorConfig caConnectorConfig) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, null, caConnectorConfig.getName(), null, null, null, caConnectorConfig, null);
    }

    public AuditTrace createAuditTraceCaConnectorConfig(String template, String oldVal, String newVal, CAConnectorConfig caConnectorConfig) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, null, oldVal, newVal, null, null, null, caConnectorConfig, null, null, null, null);
    }

    public AuditTrace createAuditTraceBPMNProcessInfo(String template, String oldVal, String newVal, BPMNProcessInfo bpmnProcessInfo) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, null, oldVal, newVal, null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceBPMNProcessInfo(String template, String attributeName, String oldVal, String newVal, BPMNProcessInfo bpmnProcessInfo) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, attributeName, oldVal, newVal, null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceRequestProxyConfigChange(String attributeName, String oldVal, String newVal, RequestProxyConfig requestProxyConfig) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CA_CONNECTOR_ATTRIBUTE_CHANGED, attributeName, oldVal, newVal, null, null, null, null, null, null, null, requestProxyConfig);
    }

    public AuditTrace createAuditTraceRequestProxyConfigSecretChanged(RequestProxyConfig requestProxyConfig) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), requestProxyConfig.getName(), null, null, null, null, null, null, null, null, null, null, requestProxyConfig);
    }

    public AuditTrace createAuditTraceNotificationSent(String email, String notificationType) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_EMAIL_SEND_NOTIFICATION_SENT, email, null, notificationType, null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceNotificationFailed(String email) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_EMAIL_SEND_NOTIFICATION_FAILED, email, null, null, null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceCertificateTrusted(String filename, Certificate certificate, CAConnectorConfig caConnectorConfig) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CERTIFICATE_SET_TRUSTED_BY_DIRECTORY_IMPORT, filename, null, null, null, certificate, null, caConnectorConfig, null, null, null, null);
    }

    public AuditTrace createAuditTraceCAConfigCreatedChange(String attributeName, String oldVal, String newVal, CAConnectorConfig caConnectorConfig) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CA_CONNECTOR_ATTRIBUTE_CHANGED, attributeName, oldVal, newVal, null, null, null, caConnectorConfig, null, null, null, null);
    }

    public AuditTrace createAuditTracePipeline(String template, Pipeline pipeline) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, null, null, pipeline, null, null);
    }

    public AuditTrace createAuditTracePipeline(String template, String oldVal, String newVal, Pipeline pipeline) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, oldVal, newVal, null, null, pipeline, null, null);
    }

    public AuditTrace createAuditTracePipelineAttribute(String attributeName, String oldVal, String newVal, Pipeline pipeline) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_PIPELINE_ATTRIBUTE_CHANGED, attributeName, oldVal, newVal, null, null, pipeline, null, null, null, null, null);
    }

    public AuditTrace createAuditTracePipelineProxyAdded(String proxyName, Pipeline pipeline) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_PIPELINE_PROXY_ADDED, proxyName, null, null, null, null, pipeline, null, null, null, null, null);
    }

    public AuditTrace createAuditTracePipelineProxyRemoved(String proxyName, Pipeline pipeline) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_PIPELINE_PROXY_REMOVED, proxyName, null, null, null, null, pipeline, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceCsrAttribute(String attributeName, String oldVal, String newVal, CSR csr) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CSR_ATTRIBUTE_CHANGED, attributeName, oldVal, newVal, csr, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceCertificateAttribute(String attributeName, String oldVal, String newVal, Certificate certificate) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CERTIFICATE_ATTRIBUTE_CHANGED, attributeName, oldVal, newVal, null, certificate, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceCertificateImported(String source, Certificate certificate, CAConnectorConfig caConfig) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CERTIFICATE_IMPORTED, source, null, null, null, certificate, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceCertificateSchemaUpdated(int nUpdated, int version) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CERTIFICATE_SCHEMA_UPDATED, "" + nUpdated, null, "" + version, null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTracePKCS12CertificateDownload(Certificate certificate) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CERTIFICATE_PKCS12_DOWNLOAD, null, null, null, null, certificate, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceAcmeOrderPipelineUpdated(int nUpdated) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_ACME_ORDER_PIPELINE_UPDATED, "" + nUpdated, null, "", null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceAcmeAcountCreatedOnUpdated(int nUpdated) {
        NameAndRole nar = this.nameAndRoleUtil.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), "AUDIT_ACME_ACCOUNT_CREATED_OR_UPDATED", "" + nUpdated, null, "", null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceLoginSucceeded(User user, String secondFactor, String clientIP) {
        return this.createAuditTrace(user.getLogin(), null, AUDIT_USER_LOGIN_SUCEEDED, clientIP, null, secondFactor, null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceLoginFailed(String loginName, String clientIP) {
        return this.createAuditTrace(loginName, null, AUDIT_USER_LOGIN_FAILED, clientIP, null, "", null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceLoginBlocked(String loginName, String clientIP, int duration) {
        return this.createAuditTrace(loginName, null, AUDIT_USER_LOGIN_BLOCKED, clientIP, null, "" + duration, null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTraceLoginForIPBlocked(String loginName, String clientIP) {
        return this.createAuditTrace(loginName, null, AUDIT_USER_LOGIN_FOR_IP_BLOCKED, clientIP, null, "", null, null, null, null, null, null, null, null);
    }

    public AuditTrace createAuditTrace(String actor, String actorRole, String template, CSR csr, Certificate certificate, Pipeline pipeline, CAConnectorConfig caConnector, BPMNProcessInfo processInfo) {
        return this.createAuditTrace(actor, actorRole, template, null, null, csr, certificate, pipeline, caConnector, processInfo);
    }

    public AuditTrace createAuditTrace(String actor, String actorRole, String template, String oldVal, String newVal, CSR csr, Certificate certificate, Pipeline pipeline, CAConnectorConfig caConnector, BPMNProcessInfo processInfo) {
        return this.createAuditTrace(actor, actorRole, template, null, oldVal, newVal, csr, certificate, pipeline, caConnector, processInfo, null, null, null);
    }

    public AuditTrace createAuditTrace(String actor, String actorRole, String template, String attributeName, String oldVal, String newVal, CSR csr, Certificate certificate, Pipeline pipeline, CAConnectorConfig caConnector, BPMNProcessInfo processInfo, AcmeAccount acmeAccount, AcmeOrder acmeOrder, RequestProxyConfig requestProxyConfig) {
        Object msg = "";
        Object content = "";
        if (oldVal != null || newVal != null) {
            msg = this.limitAndEscapeContent(attributeName, 30);
            content = this.limitAndEscapeContent(attributeName, 50);
            msg = (String)msg + "," + this.limitAndEscapeContent(oldVal, 100) + "," + this.limitAndEscapeContent(newVal, 100);
            content = (String)content + "," + this.limitAndEscapeContent(oldVal, 1000) + "," + this.limitAndEscapeContent(newVal, 1000);
        } else if (attributeName != null) {
            msg = this.limitAndEscapeContent(attributeName, 100);
            content = this.limitAndEscapeContent(attributeName, 1000);
        }
        HashMap<String, String> eventData = new HashMap<String, String>();
        if (!((String)msg).isEmpty()) {
            eventData.put("content", CryptoUtil.limitLength((String)msg, (int)250));
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuditApplicationEvent(actor, template, eventData));
        this.log.debug("Audit trace for {}, attribute {}, oldVal {}, newVal {} ", new Object[]{template, attributeName, oldVal, newVal});
        AuditTrace auditTrace = new AuditTrace();
        auditTrace.setActorName(CryptoUtil.limitLength((String)actor, (int)50));
        auditTrace.setActorRole(CryptoUtil.limitLength((String)actorRole, (int)50));
        auditTrace.setPlainContent((String)content);
        auditTrace.setContentTemplate(template);
        auditTrace.setCreatedOn(Instant.now());
        auditTrace.setCsr(csr);
        auditTrace.setCertificate(certificate);
        auditTrace.setPipeline(pipeline);
        auditTrace.setCaConnector(caConnector);
        auditTrace.setProcessInfo(processInfo);
        auditTrace.setRequestProxyConfig(requestProxyConfig);
        auditTrace.setAcmeAccount(acmeAccount);
        auditTrace.setAcmeOrder(acmeOrder);
        return auditTrace;
    }

    private String limitAndEscapeContent(String in, int maxLen) {
        if (in == null) {
            return "";
        }
        if (((String)in).length() > maxLen) {
            in = CryptoUtil.limitLength((String)in, (int)(maxLen - 3)) + "...";
        }
        return ((String)in).replace("%", "%25").replace(",", "%2C");
    }

    public void saveAuditTrace(AuditTrace auditTrace) {
        this.auditTraceRepository.save((Object)auditTrace);
    }

    public void saveAuditTrace(List<AuditTrace> auditTraceList) {
        this.auditTraceRepository.saveAll(auditTraceList);
    }
}

