/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.puppetlabs.ssl_utils.ExtensionsUtils;
import de.trustable.ca3s.core.service.dto.CsrReqAttribute;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.util.AlgorithmInfo;
import de.trustable.util.OidNameMapper;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pkcs10RequestHolderShallow {
    private final Logger LOG = LoggerFactory.getLogger(Pkcs10RequestHolderShallow.class);
    @JsonProperty(value="signingAlgorithmName")
    private String signingAlgorithmName;
    @JsonProperty(value="isCSRValid")
    private boolean isCSRValid;
    @JsonProperty(value="x509KeySpec")
    private String x509KeySpec;
    @JsonProperty(value="hashAlgName")
    private String hashAlgName;
    @JsonProperty(value="sigAlgName")
    private String sigAlgName;
    @JsonProperty(value="keyAlgName")
    private String keyAlgName;
    @JsonProperty(value="paddingAlgName")
    private String paddingAlgName;
    @JsonProperty(value="mfgName")
    private String mfgName;
    @JsonProperty(value="keyLength")
    private int keyLength;
    @JsonProperty(value="sans")
    private String[] sans;
    @JsonProperty(value="subject")
    private String subject;
    @JsonProperty(value="csrExtensionRequests")
    private CsrReqAttribute[] csrExtensionRequests;
    @JsonProperty(value="publicKeyAlgorithmName")
    private String publicKeyAlgorithmName;

    public Pkcs10RequestHolderShallow(Pkcs10RequestHolder p10ReqHolder) {
        this.isCSRValid = p10ReqHolder.isCSRValid();
        this.x509KeySpec = p10ReqHolder.getX509KeySpec();
        this.subject = p10ReqHolder.getSubject();
        this.publicKeyAlgorithmName = p10ReqHolder.getPublicKeyAlgorithm();
        this.sigAlgName = OidNameMapper.lookupOid((String)p10ReqHolder.getSigningAlgorithm());
        AlgorithmInfo algorithmInfo = p10ReqHolder.getAlgorithmInfo();
        this.signingAlgorithmName = OidNameMapper.lookupOid((String)algorithmInfo.getSigAlgName());
        this.hashAlgName = OidNameMapper.lookupOid((String)algorithmInfo.getHashAlgName());
        this.keyAlgName = OidNameMapper.lookupOid((String)algorithmInfo.getSigAlgName());
        this.keyLength = CertificateUtil.getAlignedKeyLength((PublicKey)p10ReqHolder.getPublicSigningKey());
        this.paddingAlgName = algorithmInfo.getPaddingAlgName();
        this.mfgName = "pss".equalsIgnoreCase(this.paddingAlgName) ? OidNameMapper.lookupOid((String)algorithmInfo.getMfgName()) : null;
        Set sanSet = CSRUtil.getSANList((Attribute[])p10ReqHolder.getReqAttributes());
        this.sans = new String[sanSet.size()];
        int i = 0;
        for (GeneralName gn : sanSet) {
            this.sans[i++] = CSRUtil.getGeneralNameDescription((GeneralName)gn);
        }
        ArrayList<CsrReqAttribute> csrReqAttributeList = new ArrayList<CsrReqAttribute>();
        try {
            List extList = ExtensionsUtils.getExtensionList((PKCS10CertificationRequest)p10ReqHolder.getP10Req());
            if (extList != null) {
                for (Map extMap : extList) {
                    csrReqAttributeList.add(new CsrReqAttribute(extMap));
                }
            }
        }
        catch (IOException e) {
            this.LOG.info("problem parsing CSR extensions", (Throwable)e);
        }
        this.setCsrExtensionRequests(csrReqAttributeList.toArray(new CsrReqAttribute[0]));
    }

    public String getSigningAlgorithmName() {
        return this.signingAlgorithmName;
    }

    public boolean isCSRValid() {
        return this.isCSRValid;
    }

    public String getX509KeySpec() {
        return this.x509KeySpec;
    }

    public String[] getSans() {
        return this.sans;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getPublicKeyAlgorithmName() {
        return this.publicKeyAlgorithmName;
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    public String getKeyAlgName() {
        return this.keyAlgName;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public String getHashAlgName() {
        return this.hashAlgName;
    }

    public String getPaddingAlgName() {
        return this.paddingAlgName;
    }

    public String getMfgName() {
        return this.mfgName;
    }

    public CsrReqAttribute[] getCsrExtensionRequests() {
        return this.csrExtensionRequests;
    }

    public void setCsrExtensionRequests(CsrReqAttribute[] csrExtensionRequests) {
        this.csrExtensionRequests = csrExtensionRequests;
    }
}

