/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto;

import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.RequestProxyConfig;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class RemoteRequestProxyConfigView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String requestProxyUrl;
    private Boolean active;
    private String[] acmeRealmArr;

    public RemoteRequestProxyConfigView() {
    }

    public RemoteRequestProxyConfigView(RequestProxyConfig requestProxyConfig) {
        this.setId(requestProxyConfig.getId());
        this.setName(requestProxyConfig.getName());
        this.setActive(requestProxyConfig.isActive());
        this.setRequestProxyUrl(requestProxyConfig.getRequestProxyUrl());
        ArrayList<String> realmList = new ArrayList<String>();
        for (Pipeline p : requestProxyConfig.getPipelines()) {
            if (!p.isActive().booleanValue() || !PipelineType.ACME.equals((Object)p.getType())) continue;
            realmList.add(p.getUrlPart());
        }
        this.setAcmeRealmArr(realmList.toArray(new String[0]));
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRequestProxyUrl() {
        return this.requestProxyUrl;
    }

    public void setRequestProxyUrl(String requestProxyUrl) {
        this.requestProxyUrl = requestProxyUrl;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String[] getAcmeRealmArr() {
        return this.acmeRealmArr;
    }

    public void setAcmeRealmArr(String[] acmeRealmArr) {
        this.acmeRealmArr = acmeRealmArr;
    }

    public String toString() {
        return "RemoteRequestProxyConfigView{id=" + this.id + ", name='" + this.name + "', requestProxyUrl='" + this.requestProxyUrl + "', active=" + this.active + ", acmeRealmArr=" + Arrays.toString(this.acmeRealmArr) + "}";
    }
}

