/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto.acme;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.domain.enumeration.ChallengeStatus;
import de.trustable.ca3s.core.service.util.DateUtil;
import java.time.Instant;
import java.util.Date;
import javax.annotation.concurrent.Immutable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public class ChallengeResponse {
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="status")
    private ChallengeStatus status;
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="validated")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss'Z'")
    private Date validated = null;

    public ChallengeResponse() {
    }

    public ChallengeResponse(AcmeChallenge challengeDao, String url) {
        this.setStatus(challengeDao.getStatus());
        this.setToken(challengeDao.getToken());
        this.setType(challengeDao.getType());
        this.setUrl(url);
        if (challengeDao.getValidated() == null) {
            this.setValidated(null);
        } else {
            this.setValidated(DateUtil.asDate((Instant)challengeDao.getValidated()));
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ChallengeStatus getStatus() {
        return this.status;
    }

    public void setStatus(ChallengeStatus status) {
        this.status = status;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Date getValidated() {
        return this.validated;
    }

    public void setValidated(Date validated) {
        if (validated != null) {
            this.validated = validated;
        }
    }
}

