/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.AlgorithmRestriction;
import de.trustable.ca3s.core.repository.AlgorithmRestrictionRepository;
import de.trustable.ca3s.core.service.AlgorithmRestrictionService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AlgorithmRestrictionServiceImpl
implements AlgorithmRestrictionService {
    private final Logger log = LoggerFactory.getLogger(AlgorithmRestrictionServiceImpl.class);
    private final AlgorithmRestrictionRepository algorithmRestrictionRepository;

    public AlgorithmRestrictionServiceImpl(AlgorithmRestrictionRepository algorithmRestrictionRepository) {
        this.algorithmRestrictionRepository = algorithmRestrictionRepository;
    }

    public AlgorithmRestriction save(AlgorithmRestriction algorithmRestriction) {
        this.log.debug("Request to save AlgorithmRestriction : {}", (Object)algorithmRestriction);
        return (AlgorithmRestriction)this.algorithmRestrictionRepository.save((Object)algorithmRestriction);
    }

    public Optional<AlgorithmRestriction> partialUpdate(AlgorithmRestriction algorithmRestriction) {
        this.log.debug("Request to partially update AlgorithmRestriction : {}", (Object)algorithmRestriction);
        return this.algorithmRestrictionRepository.findById((Object)algorithmRestriction.getId()).map(existingAlgorithmRestriction -> {
            if (algorithmRestriction.getType() != null) {
                existingAlgorithmRestriction.setType(algorithmRestriction.getType());
            }
            if (algorithmRestriction.getNotAfter() != null) {
                existingAlgorithmRestriction.setNotAfter(algorithmRestriction.getNotAfter());
            }
            if (algorithmRestriction.getIdentifier() != null) {
                existingAlgorithmRestriction.setIdentifier(algorithmRestriction.getIdentifier());
            }
            if (algorithmRestriction.getName() != null) {
                existingAlgorithmRestriction.setName(algorithmRestriction.getName());
            }
            if (algorithmRestriction.getAcceptable() != null) {
                existingAlgorithmRestriction.setAcceptable(algorithmRestriction.getAcceptable());
            }
            return existingAlgorithmRestriction;
        }).map(arg_0 -> ((AlgorithmRestrictionRepository)this.algorithmRestrictionRepository).save(arg_0));
    }

    @Transactional(readOnly=true)
    public List<AlgorithmRestriction> findAll() {
        this.log.debug("Request to get all AlgorithmRestrictions");
        return this.algorithmRestrictionRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<AlgorithmRestriction> findOne(Long id) {
        this.log.debug("Request to get AlgorithmRestriction : {}", (Object)id);
        return this.algorithmRestrictionRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AlgorithmRestriction : {}", (Object)id);
        this.algorithmRestrictionRepository.deleteById((Object)id);
    }
}

