/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import java.util.HashMap;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BPMNAsyncUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BPMNAsyncUtil.class);
    private final RuntimeService runtimeService;

    public BPMNAsyncUtil(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @Transactional
    public void onChange(String processName, Long certificateId, Authentication auth) {
        String currentAuthName;
        LOG.info("******************  Async call to onChange( '{}', {})", (Object)processName, (Object)certificateId);
        if (certificateId == null) {
            return;
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("certificateId", certificateId.toString());
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication currentAuth = securityContext.getAuthentication();
        try {
            if (auth != null) {
                LOG.info("Setting authentication to : {}", (Object)auth.getName());
                securityContext.setAuthentication(auth);
            }
            ProcessInstanceWithVariables processInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processName).setVariables(variables)).executeWithVariablesInReturn();
            String processInstanceId = processInstance.getId();
            String status = processInstance.getVariables().get((Object)"status").toString();
            LOG.info("ProcessInstance '{}' terminates with status {}", (Object)processInstanceId, (Object)status);
            currentAuthName = currentAuth == null ? null : currentAuth.getName();
        }
        catch (RuntimeException processException) {
            String currentAuthName2;
            try {
                if (LOG.isDebugEnabled()) {
                    String msg = "Exception while calling bpmn process '" + processName + "'";
                    LOG.debug(msg, (Throwable)processException);
                }
                currentAuthName2 = currentAuth == null ? null : currentAuth.getName();
            }
            catch (Throwable throwable) {
                String currentAuthName3 = currentAuth == null ? null : currentAuth.getName();
                LOG.info("Restoring authentication to : {}", (Object)currentAuthName3);
                securityContext.setAuthentication(currentAuth);
                throw throwable;
            }
            LOG.info("Restoring authentication to : {}", (Object)currentAuthName2);
            securityContext.setAuthentication(currentAuth);
        }
        LOG.info("Restoring authentication to : {}", (Object)currentAuthName);
        securityContext.setAuthentication(currentAuth);
    }
}

