/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AuditTrace;
import de.trustable.ca3s.core.domain.UserPreference;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.UserPreferenceService;
import de.trustable.ca3s.core.service.dto.Preferences;
import de.trustable.ca3s.core.service.util.PreferenceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;

@RestController
@RequestMapping(value={"/api"})
public class PreferenceResource {
    private final Logger log = LoggerFactory.getLogger(PreferenceResource.class);
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private static final String ENTITY_NAME = "preference";
    private final PreferenceUtil preferenceUtil;
    private final UserPreferenceService userPreferenceService;
    private final AuditService auditService;

    public PreferenceResource(PreferenceUtil preferenceUtil, UserPreferenceService userPreferenceService, AuditService auditService) {
        this.preferenceUtil = preferenceUtil;
        this.userPreferenceService = userPreferenceService;
        this.auditService = auditService;
    }

    @GetMapping(value={"/preference/{userId}"})
    public ResponseEntity<Preferences> getPreference(@PathVariable Long userId) {
        Preferences prefs = this.preferenceUtil.getPrefs(userId);
        return new ResponseEntity((Object)prefs, HttpStatus.OK);
    }

    @PutMapping(value={"/preference/{userId}"})
    public ResponseEntity<Preferences> updatePreference(@Valid @RequestBody Preferences preferences, @PathVariable Long userId) {
        this.log.debug("REST request to update Preferences for user {} : {}", (Object)userId, (Object)preferences);
        Preferences oldPrefs = this.preferenceUtil.getPrefs(userId);
        if (preferences.getAcmeHTTP01TimeoutMilliSec() < 100L || preferences.getAcmeHTTP01TimeoutMilliSec() > 60000L) {
            this.log.warn("unexpected Preference value for ACME_HTTP01_TIMEOUT_MILLI_SEC '{}'", (Object)preferences.getAcmeHTTP01TimeoutMilliSec());
            return ResponseEntity.badRequest().build();
        }
        int[] portsArr = preferences.getAcmeHTTP01CallbackPortArr();
        if (portsArr.length == 0 || portsArr.length > 10) {
            this.log.warn("unexpected Preference number for ACME_HTTP01_CALLBACK_PORTS '{}'", (Object)portsArr.length);
            return ResponseEntity.badRequest().body((Object)oldPrefs);
        }
        Object portsCommaSeparatedList = "";
        for (int nPort : portsArr) {
            if (nPort == 0) continue;
            try {
                if (nPort <= 0 || nPort > 65535) {
                    this.log.warn("unexpected Preference value for port in ACME_HTTP01_CALLBACK_PORTS '{}'", (Object)nPort);
                    return ResponseEntity.badRequest().body((Object)oldPrefs);
                }
            }
            catch (NumberFormatException nfe) {
                this.log.warn("unexpected Preference value for ACME_HTTP01_TIMEOUT_MILLI_SEC '{}'", (Object)nfe.getMessage());
                return ResponseEntity.badRequest().body((Object)oldPrefs);
            }
            if (!((String)portsCommaSeparatedList).trim().isEmpty()) {
                portsCommaSeparatedList = (String)portsCommaSeparatedList + ",";
            }
            portsCommaSeparatedList = (String)portsCommaSeparatedList + nPort;
        }
        List upList = this.userPreferenceService.findAllForUserId(userId);
        HashMap<String, UserPreference> upMap = new HashMap<String, UserPreference>();
        for (UserPreference up : upList) {
            upMap.put(up.getName(), up);
        }
        ArrayList auditList = new ArrayList();
        this.updateValue(upMap, "CheckCRL", String.valueOf(preferences.isCheckCRL()), userId, auditList);
        this.updateValue(upMap, "NotifyRAOnRequest", String.valueOf(preferences.isNotifyRAOnRequest()), userId, auditList);
        this.updateValue(upMap, "MaxNextUpdatePeriodCrlSec", String.valueOf(preferences.getMaxNextUpdatePeriodCRLHour() * 3600L), userId, auditList);
        this.updateValue(upMap, "ServerSideKeyCreationAllowed", String.valueOf(preferences.isServerSideKeyCreationAllowed()), userId, auditList);
        this.updateValue(upMap, "ServerSideKeyDeleteAfterDays", String.valueOf(preferences.getDeleteKeyAfterDays()), userId, auditList);
        this.updateValue(upMap, "ServerSideKeyDeleteAfterUses", String.valueOf(preferences.getDeleteKeyAfterUses()), userId, auditList);
        this.updateValue(upMap, "AcmeHTTP01CallbackPorts", (String)portsCommaSeparatedList, userId, auditList);
        this.updateValue(upMap, "AcmeHTTP01TimeoutMilliSec", String.valueOf(preferences.getAcmeHTTP01TimeoutMilliSec()), userId, auditList);
        CharSequence[] selectedHashArr = preferences.getSelectedHashes();
        this.updateValue(upMap, "SelectedHashes", String.join((CharSequence)",", selectedHashArr), userId, auditList);
        CharSequence[] selectedSigningAlgoArr = preferences.getSelectedSigningAlgos();
        this.updateValue(upMap, "SelectedSigningAlgos", String.join((CharSequence)",", selectedSigningAlgoArr), userId, auditList);
        this.updateValue(upMap, "AuthClientCert", String.valueOf(preferences.isAuthClientCert()), userId, auditList);
        this.updateValue(upMap, "AuthTotp", String.valueOf(preferences.isAuthTotp()), userId, auditList);
        this.updateValue(upMap, "AuthEmail", String.valueOf(preferences.isAuthEmail()), userId, auditList);
        this.updateValue(upMap, "AuthSms", String.valueOf(preferences.isSms()), userId, auditList);
        this.auditService.saveAuditTrace(auditList);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)userId.toString()))).body((Object)preferences);
    }

    private void updateValue(Map<String, UserPreference> upMap, String key, String value, Long userId, List<AuditTrace> auditList) {
        if (upMap.containsKey(key)) {
            UserPreference up = upMap.get(key);
            if (!value.equalsIgnoreCase(up.getContent().trim())) {
                this.log.debug("New preferences value '{}' != current value '{}'", (Object)value, (Object)up.getContent().trim());
                auditList.add(this.auditService.createAuditTraceSystemPreferenceUpdated(key, up.getContent(), value));
                up.setContent(value);
                this.userPreferenceService.save(up);
            }
        } else {
            this.log.debug("Ceating new preferences for key '{}' and value '{}'", (Object)key, (Object)value);
            auditList.add(this.auditService.createAuditTraceSystemPreferenceCreated(key, value));
            UserPreference up = new UserPreference();
            up.setUserId(userId);
            up.setName(key);
            up.setContent(value);
            this.userPreferenceService.save(up);
        }
    }
}

