/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.security.jwt.TokenProvider;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.UserUtil;
import de.trustable.ca3s.core.web.rest.JWTToken;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/publicapi"})
public class ClientAuthController {
    private final Logger LOG = LoggerFactory.getLogger(ClientAuthController.class);
    private final CertificateUtil certificateUtil;
    private final TokenProvider tokenProvider;
    private final UserUtil userUtil;

    public ClientAuthController(CertificateUtil certificateUtil, TokenProvider tokenProvider, UserUtil userUtil) {
        this.certificateUtil = certificateUtil;
        this.tokenProvider = tokenProvider;
        this.userUtil = userUtil;
    }

    @CrossOrigin(methods={RequestMethod.POST, RequestMethod.GET})
    @RequestMapping(value={"/clientAuth"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseEntity checkUserCertificate(HttpServletRequest request, HttpSession httpSession) {
        Iterator it = httpSession.getAttributeNames().asIterator();
        while (it.hasNext()) {
            String att = (String)it.next();
            this.LOG.info("att {} : {}", (Object)att, httpSession.getAttribute(att));
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("jakarta.servlet.request.X509Certificate");
        if (certs == null || certs.length == 0) {
            certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        }
        if (certs == null || certs.length == 0) {
            this.LOG.warn("no client certificate at client auth endpoint");
            return ResponseEntity.notFound().headers(httpHeaders).build();
        }
        try {
            this.LOG.info("user authenticated by client cert with subject '{}' / swrial {}", (Object)certs[0].getSubjectX500Principal().getName(), (Object)certs[0].getSerialNumber());
            JcaX509ExtensionUtils util = new JcaX509ExtensionUtils();
            SubjectKeyIdentifier ski = util.createSubjectKeyIdentifier(certs[0].getPublicKey());
            String b46Ski = Base64.encodeBase64String((byte[])ski.getKeyIdentifier());
            String jwt = this.tokenProvider.createToken(certs[0].getSubjectX500Principal().getName(), b46Ski);
            httpHeaders.add("client_cert_token", jwt);
            return new ResponseEntity((Object)new JWTToken(jwt), (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (GeneralSecurityException e) {
            this.LOG.info("problem processing client certificate", (Throwable)e);
            return ResponseEntity.notFound().headers(httpHeaders).build();
        }
    }
}

