/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.security.SecurityUtils;
import de.trustable.ca3s.core.service.SMSService;
import de.trustable.ca3s.core.service.UserCredentialService;
import de.trustable.ca3s.core.service.util.BPMNUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.UserUtil;
import de.trustable.ca3s.core.web.rest.errors.AccountResourceException;
import de.trustable.ca3s.core.web.rest.vm.LoginData;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/publicapi"})
public class SMSController {
    private final Logger LOG = LoggerFactory.getLogger(SMSController.class);
    private final CertificateUtil certificateUtil;
    private final UserCredentialService userCredentialService;
    private final UserRepository userRepository;
    private final UserUtil userUtil;
    private final BPMNUtil bpmnUtil;
    private final SMSService smsService;

    public SMSController(CertificateUtil certificateUtil, UserCredentialService userCredentialService, UserRepository userRepository, UserUtil userUtil, BPMNUtil bpmnUtil, SMSService smsService) {
        this.certificateUtil = certificateUtil;
        this.userCredentialService = userCredentialService;
        this.userRepository = userRepository;
        this.userUtil = userUtil;
        this.bpmnUtil = bpmnUtil;
        this.smsService = smsService;
    }

    @RequestMapping(value={"/smsDelivery"}, method={RequestMethod.POST})
    public ResponseEntity<String> sendSMS() {
        String userLogin = (String)SecurityUtils.getCurrentUserLogin().orElseThrow(() -> new AccountResourceException("Current user login not found"));
        Optional userOpt = this.userRepository.findOneByLogin(userLogin);
        if (userOpt.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        String msg = this.smsService.sendPIN_SMS((User)userOpt.get());
        return ResponseEntity.ok((Object)msg);
    }

    @RequestMapping(value={"/smsDelivery/{user}"}, method={RequestMethod.POST})
    public ResponseEntity<Void> sendSMS(@PathVariable String user, @RequestBody LoginData loginData) {
        this.userUtil.checkIPBlocked(loginData.getUsername());
        try {
            this.userCredentialService.validateUserPassword(loginData.getUsername(), loginData.getPassword());
            Optional userOpt = this.userRepository.findOneByLogin(loginData.getUsername());
            if (userOpt.isEmpty()) {
                this.LOG.warn("user '{}' unknown", (Object)loginData.getUsername());
                return ResponseEntity.noContent().build();
            }
            this.smsService.sendPIN_SMS((User)userOpt.get());
        }
        catch (RuntimeException rte) {
            this.LOG.warn("invalid SMS sending request", (Throwable)rte);
        }
        return ResponseEntity.noContent().build();
    }
}

