/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.websocket;

import de.trustable.ca3s.core.web.websocket.dto.AcmeRequestContainer;
import de.trustable.ca3s.core.web.websocket.dto.AcmeResponseContainer;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.stereotype.Controller;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;

@Controller
public class AcmeProxyService
implements ApplicationListener<SessionDisconnectEvent> {
    private static final Logger log = LoggerFactory.getLogger(AcmeProxyService.class);

    @MessageMapping(value={"/acmeProxy"})
    @SendTo(value={"/topic/acmeProxied"})
    public AcmeResponseContainer processACMERequest(@Payload AcmeRequestContainer arc, StompHeaderAccessor stompHeaderAccessor, Principal principal) {
        log.info("received proxied ACME call to '{}' (path '{}', realm '{}') with principal '{}'", new Object[]{stompHeaderAccessor.getDestination(), arc.getPath(), arc.getRealm(), principal});
        AcmeResponseContainer acmeResp = new AcmeResponseContainer(303);
        log.info("returning ACME response '{}'", (Object)acmeResp.getStatus());
        return acmeResp;
    }

    @MessageExceptionHandler
    public String handleException(Throwable exception) {
        log.warn("received exception", exception);
        return exception.getMessage();
    }

    public void onApplicationEvent(SessionDisconnectEvent event) {
        log.debug("application event received : {}", (Object)event);
    }
}

