"use strict";
(self["webpackChunkca_3_s"] = self["webpackChunkca_3_s"] || []).push([["src_main_webapp_app_account_change-password_edit-credential_vue"],{

/***/ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/account/change-password/edit-credential.component.ts?vue&type=script&lang=ts&":
/*!*********************************************************************************************************************************************************************!*\
  !*** ./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/account/change-password/edit-credential.component.ts?vue&type=script&lang=ts& ***!
  \*********************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vuelidate/lib/validators */ "./node_modules/vuelidate/lib/validators/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var vue_class_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vue-class-component */ "./node_modules/vue-class-component/dist/vue-class-component.esm.js");
/* harmony import */ var _shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/shared/alert/alert.mixin */ "./src/main/webapp/app/shared/alert/alert.mixin.ts");
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (undefined && undefined.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};






var validations = {
    resetPassword: {
        currentPassword: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.required,
        },
        newPassword: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.required,
            minLength: (0,vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.minLength)(4),
            maxLength: (0,vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.maxLength)(254),
        },
        confirmPassword: {
            // prettier-ignore
            sameAsPassword: (0,vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.sameAs)(function (vm) {
                return vm.newPassword;
            }),
        },
    },
    clientAuthSecret: {
        minLength: (0,vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.minLength)(4),
        maxLength: (0,vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.maxLength)(254),
    },
};
var EditCredential = /** @class */ (function (_super) {
    __extends(EditCredential, _super);
    function EditCredential() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.base32RegEx = '^(?:[A-Z2-7]{8})*(?:[A-Z2-7]{2}={6}|[A-Z2-7]{4}={4}|[A-Z2-7]{5}={3}|[A-Z2-7]{7}=)?$';
        _this.totpRegEx = '^([0-9]{6})$';
        _this.success = null;
        _this.error = null;
        _this.doNotMatch = null;
        _this.oldPasswordMismatch = false;
        _this.updateCounter = 1;
        _this.smsSent = '';
        _this.credentialChange = { credentialUpdateType: 'TOTP' };
        _this.resetPassword = {
            currentPassword: null,
            newPassword: null,
            confirmPassword: null,
        };
        _this.clientAuthSecret = null;
        _this.qrCodeImgUrl = null;
        _this.accountCredentialArr = [];
        _this.currentAccountCredentialId = -1;
        _this.useGivenSeed = false;
        return _this;
    }
    EditCredential.prototype.beforeRouteEnter = function (to, from, next) {
        next(function (vm) {
            if (to.params.credentialType) {
                vm.credentialChange.credentialUpdateType = to.params.credentialType;
            }
            if (to.params.accountCredentialId) {
                vm.currentAccountCredentialId = to.params.accountCredentialId;
            }
        });
    };
    EditCredential.prototype.mounted = function () {
        this.getCredentials();
        if (this.credentialChange.credentialUpdateType === 'TOTP') {
            this.initOtp();
        }
        this.credentialChange.clientAuthCertId = 0;
    };
    EditCredential.prototype.saveCredentials = function () {
        var _this = this;
        this.credentialChange.currentPassword = this.resetPassword.currentPassword;
        var self = this;
        this.oldPasswordMismatch = false;
        axios__WEBPACK_IMPORTED_MODULE_0___default().post('api/account/change-password', this.credentialChange)
            .then(function () {
            self.success = 'OK';
            self.credentialChange.clientAuthCertId = 0;
            self.error = null;
            self.$router.push('/account/password');
            var message = _this.$t('ca3SApp.messages.credential.created');
            self.alertService().showAlert(message, 'success');
        })
            .catch(function (error) {
            self.success = null;
            self.error = 'ERROR';
            var err = error;
            if (err.response.status === 400) {
                if (err.response.data.type === 'https://trustable.eu/problem/invalid-password') {
                    self.credentialChange.currentPassword = '';
                    document.getElementById('currentPassword').focus();
                    self.oldPasswordMismatch = true;
                }
                else if (err.response.data.type === 'https://trustable.eu/problem/problem-with-message') {
                    self.credentialChange.otpTestValue = '';
                    document.getElementById('otp-test-value').focus();
                }
                self.alertService().showAlert(err.response.data.message, 'warn');
            }
            else {
                self.alertService().showAlert('error', 'warn');
            }
            self.getAlertFromStore();
        });
    };
    EditCredential.prototype.getCredentials = function () {
        window.console.info('calling getCredentials');
        var self = this;
        axios__WEBPACK_IMPORTED_MODULE_0___default()({
            method: 'get',
            url: 'api/account/credentials',
            responseType: 'stream',
        })
            .then(function (response) {
            window.console.info('getCredentials returns ' + response.data);
            self.accountCredentialArr = response.data;
        })
            .catch(function (error) {
            console.log(error);
            var message = self.$t('problem processing request: ' + error);
            var err = error;
            if (err.response) {
                console.log(err.response.status);
                console.log(err.response.data);
                if (err.response.status === 401) {
                    self.alertService().showAlert('Action not allowed', 'warn');
                }
                else {
                    self.alertService().showAlert(message, 'info');
                }
            }
            else {
                self.alertService().showAlert(message, 'info');
            }
            self.getAlertFromStore();
        });
    };
    Object.defineProperty(EditCredential.prototype, "username", {
        get: function () {
            var _a, _b;
            return (_b = (_a = this.$store.getters.account) === null || _a === void 0 ? void 0 : _a.login) !== null && _b !== void 0 ? _b : '';
        },
        enumerable: false,
        configurable: true
    });
    EditCredential.prototype.keystoreFilename = function () {
        return 'personalClientCertificate.p12';
    };
    EditCredential.prototype.downloadPersonalCertificate = function (secret) {
        var mimetype = 'application/x-pkcs12';
        var pbeAlgo = this.$store.state.uiConfigStore.config.cryptoConfigView.defaultPBEAlgo;
        var url = '/publicapi/clientAuthKeystore/' + this.username + '/' + encodeURIComponent(this.keystoreFilename());
        var headers = {
            //      Accept: mimetype,
            X_pbeAlgo: pbeAlgo,
            X_keyEx: false,
        };
        this.download(url, secret, this.keystoreFilename(), mimetype, headers);
        this.success = ''; // refresh
    };
    EditCredential.prototype.download = function (url, secret, filename, mimetype, headers) {
        this.credentialChange.clientAuthCertId = 0;
        var self = this;
        var config = {};
        config['responseType'] = 'blob';
        config['headers'] = headers;
        var data = {};
        data['secret'] = secret;
        axios__WEBPACK_IMPORTED_MODULE_0___default().post(url, data, config)
            .then(function (response) {
            self.credentialChange.clientAuthCertId = parseInt(response.headers['x-cert-id']);
            self.updateCounter++;
            var blob = new Blob([response.data], { type: mimetype, endings: 'transparent' });
            var link = document.createElement('a');
            link.href = URL.createObjectURL(blob);
            link.download = filename;
            link.type = mimetype;
            window.console.info('cert ' + self.credentialChange.clientAuthCertId + ' downloaded, tmp download lnk : ' + link.href);
            link.click();
            URL.revokeObjectURL(link.href);
        })
            .catch(function (error) {
            console.log(error);
            var message = self.$t('problem processing request: ' + error);
            var err = error;
            if (err.response) {
                console.log(err.response.status);
                console.log(err.response.data);
                if (err.response.status === 401) {
                    self.alertService().showAlert('Action not allowed', 'warn');
                }
                else {
                    self.alertService().showAlert(message, 'info');
                }
            }
            else {
                self.alertService().showAlert(message, 'info');
            }
            self.getAlertFromStore();
        });
    };
    EditCredential.prototype.requestClientCert = function () {
        var clientAuthTarget = this.$store.state.uiConfigStore.config.cryptoConfigView.clientAuthTarget;
        var self = this;
        axios__WEBPACK_IMPORTED_MODULE_0___default().get(clientAuthTarget + '/publicapi/clientAuth')
            .then(function (result) {
            console.info('connected to client auth port');
            if (result.data && result.data.id_token) {
                console.info('client_cert_token: ' + result.data.id_token);
            }
        })
            .catch(function (error) {
            // Handle the error response
            console.error('----' + error);
        });
    };
    EditCredential.prototype.showBase32RegExpFieldWarning = function (value) {
        var regexp = new RegExp(this.base32RegEx);
        var valid = regexp.test(value);
        console.log('showBase32RegExpFieldWarning( ' + this.base32RegEx + ', "' + value + '") -> ' + valid);
        return !valid;
    };
    EditCredential.prototype.showTOTPExpFieldWarning = function (value) {
        var regexp = new RegExp(this.totpRegEx);
        var valid = regexp.test(value);
        console.log('showTOTPExpFieldWarning( ' + this.totpRegEx + ', "' + value + '") -> ' + valid);
        return !valid;
    };
    EditCredential.prototype.updateSeedMode = function () {
        this.credentialChange.seed = '';
        if (!this.useGivenSeed) {
            this.initOtp();
        }
    };
    EditCredential.prototype.initOtp = function () {
        var self = this;
        axios__WEBPACK_IMPORTED_MODULE_0___default().post('/api/account/initOTP')
            .then(function (response) {
            self.credentialChange.seed = response.data['seed'];
            self.qrCodeImgUrl = 'data:image/png;base64,' + response.data['qrCodeImg'];
        })
            .catch(function (error) {
            console.log(error);
            var message = self.$t('problem processing request: ' + error);
            var err = error;
            if (err.response) {
                console.log(err.response.status);
                console.log(err.response.data);
                if (err.response.status === 401) {
                    self.alertService().showAlert('Action not allowed', 'warn');
                }
                else {
                    self.alertService().showAlert(message, 'info');
                }
            }
            else {
                self.alertService().showAlert(message, 'info');
            }
            self.getAlertFromStore();
        });
    };
    EditCredential.prototype.sendSMS = function () {
        this.smsSent = '';
        var self = this;
        axios__WEBPACK_IMPORTED_MODULE_0___default().post('/publicapi/smsDelivery')
            .then(function (response) {
            self.smsSent = response.data.toString();
            //        document.getElementById("sms-test-value").focus();
        })
            .catch(function (error) {
            console.log(error);
            var message = self.$t('problem processing request: ' + error);
            var err = error;
            if (err.response) {
                console.log(err.response.status);
                console.log(err.response.data);
                if (err.response.status === 401) {
                    self.alertService().showAlert('Action not allowed', 'warn');
                }
                else {
                    self.alertService().showAlert(message, 'info');
                }
            }
            else {
                self.alertService().showAlert(message, 'info');
            }
            self.getAlertFromStore();
        });
    };
    EditCredential.prototype.showRequiredWarning = function (isRequired, value) {
        console.log('showRequiredWarning( ' + isRequired + ', "' + value + '")');
        if (isRequired) {
            if (!value) {
                return true;
            }
            if (value.trim().length === 0) {
                return true;
            }
        }
        return false;
    };
    EditCredential.prototype.showRegExpFieldWarning = function (value, regEx) {
        var regexp = new RegExp(regEx);
        var valid = regexp.test(value);
        console.log('showRegExpFieldWarning( ' + regEx + ', "' + value + '") -> ' + valid);
        return !valid;
    };
    EditCredential.prototype.regExpSecret = function () {
        if (this.$store.state.uiConfigStore.config.cryptoConfigView !== undefined &&
            this.$store.state.uiConfigStore.config.cryptoConfigView.passwordRegexp !== undefined) {
            return this.$store.state.uiConfigStore.config.cryptoConfigView.passwordRegexp;
        }
        return '';
    };
    EditCredential.prototype.regExpSecretDescription = function () {
        if (this.$store.state.uiConfigStore.config.cryptoConfigView !== undefined &&
            this.$store.state.uiConfigStore.config.cryptoConfigView.regexpPasswordDescription !== undefined) {
            console.log('regExpSecretDescription : ' + this.$store.state.uiConfigStore.config.cryptoConfigView.regexpPasswordDescription);
            return this.$store.state.uiConfigStore.config.cryptoConfigView.regexpPasswordDescription;
        }
        return '';
    };
    EditCredential.prototype.canCreateCertificate = function () {
        var canCreateCertificate = !this.showRegExpFieldWarning(this.$v.clientAuthSecret.$model, this.regExpSecret());
        console.log('canCreateCertificate: ' + canCreateCertificate);
        return canCreateCertificate;
    };
    EditCredential.prototype.canSubmit = function () {
        if (this.credentialChange.credentialUpdateType === 'CLIENT_CERT') {
            if (this.credentialChange.clientAuthCertId === 0) {
                console.log('canSubmit, CLIENT_CERT : clientAuthCertId === 0');
                return false;
            }
        }
        else if (this.credentialChange.credentialUpdateType === 'TOTP') {
            if (this.showBase32RegExpFieldWarning(this.credentialChange.seed) ||
                this.showTOTPExpFieldWarning(this.credentialChange.otpTestValue)) {
                console.log('canSubmit TOTP: seed or test value invalid');
                return false;
            }
            console.log('canSubmit TOTP: values OK');
        }
        else if (this.credentialChange.credentialUpdateType === 'SMS') {
            if (this.smsSent.length === 0) {
                console.log('canSubmit SMS: no test SMS sent');
                return false;
            }
            if (this.showTOTPExpFieldWarning(this.credentialChange.otpTestValue)) {
                console.log('canSubmit SMS: seed or test value invalid');
                return false;
            }
            if (this.credentialChange.otpTestValue.trim() !== this.smsSent.trim()) {
                console.log('canSubmit SMS: test value and SMS value do nat match');
                return false;
            }
            console.log('canSubmit SMS: values OK');
        }
        console.log('canSubmit: currentPassword.$invalid: ' + this.$v.resetPassword.currentPassword.$invalid);
        return !this.$v.resetPassword.currentPassword.$invalid;
    };
    EditCredential.prototype.previousState = function () {
        this.$router.go(-1);
    };
    EditCredential = __decorate([
        (0,vue_class_component__WEBPACK_IMPORTED_MODULE_4__["default"])({
            validations: validations,
            computed: __assign({}, (0,vuex__WEBPACK_IMPORTED_MODULE_5__.mapGetters)(['account'])),
        })
    ], EditCredential);
    return EditCredential;
}((0,vue_class_component__WEBPACK_IMPORTED_MODULE_4__.mixins)(_shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_1__["default"], vue_property_decorator__WEBPACK_IMPORTED_MODULE_2__.Vue)));
/* harmony default export */ __webpack_exports__["default"] = (EditCredential);


/***/ }),

/***/ "./src/main/webapp/app/shared/alert/alert.mixin.ts":
/*!*********************************************************!*\
  !*** ./src/main/webapp/app/shared/alert/alert.mixin.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};

var AlertMixin = /** @class */ (function (_super) {
    __extends(AlertMixin, _super);
    function AlertMixin() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.dismissCountDown = _this.$store.getters.dismissCountDown;
        _this.dismissSecs = _this.$store.getters.dismissSecs;
        _this.alertType = _this.$store.getters.alertType;
        _this.alertMessage = _this.$store.getters.alertMessage;
        return _this;
    }
    AlertMixin.prototype.getAlertFromStore = function () {
        this.dismissCountDown = this.$store.getters.dismissCountDown;
        this.dismissSecs = this.$store.getters.dismissSecs;
        this.alertType = this.$store.getters.alertType;
        this.alertMessage = this.$store.getters.alertMessage;
    };
    AlertMixin.prototype.countDownChanged = function (dismissCountDown) {
        this.alertService().countDownChanged(dismissCountDown);
        this.getAlertFromStore();
    };
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('alertService'),
        __metadata("design:type", Function)
    ], AlertMixin.prototype, "alertService", void 0);
    AlertMixin = __decorate([
        vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component
    ], AlertMixin);
    return AlertMixin;
}(vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Vue));
/* harmony default export */ __webpack_exports__["default"] = (AlertMixin);


/***/ }),

/***/ "./src/main/webapp/app/account/change-password/edit-credential.vue":
/*!*************************************************************************!*\
  !*** ./src/main/webapp/app/account/change-password/edit-credential.vue ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _edit_credential_vue_vue_type_template_id_3b60a83e___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./edit-credential.vue?vue&type=template&id=3b60a83e& */ "./src/main/webapp/app/account/change-password/edit-credential.vue?vue&type=template&id=3b60a83e&");
/* harmony import */ var _edit_credential_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./edit-credential.component.ts?vue&type=script&lang=ts& */ "./src/main/webapp/app/account/change-password/edit-credential.component.ts?vue&type=script&lang=ts&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");





/* normalize component */
;
var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  _edit_credential_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__["default"],
  _edit_credential_vue_vue_type_template_id_3b60a83e___WEBPACK_IMPORTED_MODULE_0__.render,
  _edit_credential_vue_vue_type_template_id_3b60a83e___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/main/webapp/app/account/change-password/edit-credential.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./src/main/webapp/app/account/change-password/edit-credential.component.ts?vue&type=script&lang=ts&":
/*!***********************************************************************************************************!*\
  !*** ./src/main/webapp/app/account/change-password/edit-credential.component.ts?vue&type=script&lang=ts& ***!
  \***********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_edit_credential_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./edit-credential.component.ts?vue&type=script&lang=ts& */ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/account/change-password/edit-credential.component.ts?vue&type=script&lang=ts&");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_edit_credential_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./src/main/webapp/app/account/change-password/edit-credential.vue?vue&type=template&id=3b60a83e&":
/*!********************************************************************************************************!*\
  !*** ./src/main/webapp/app/account/change-password/edit-credential.vue?vue&type=template&id=3b60a83e& ***!
  \********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_edit_credential_vue_vue_type_template_id_3b60a83e___WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   "staticRenderFns": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_edit_credential_vue_vue_type_template_id_3b60a83e___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_edit_credential_vue_vue_type_template_id_3b60a83e___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./edit-credential.vue?vue&type=template&id=3b60a83e& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/account/change-password/edit-credential.vue?vue&type=template&id=3b60a83e&");


/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/account/change-password/edit-credential.vue?vue&type=template&id=3b60a83e&":
/*!************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/account/change-password/edit-credential.vue?vue&type=template&id=3b60a83e& ***!
  \************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* binding */ render; },
/* harmony export */   "staticRenderFns": function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c,
    _setup = _vm._self._setupProxy
  return _c(
    "div",
    [
      _c(
        "b-alert",
        {
          attrs: {
            show: _vm.dismissCountDown,
            dismissible: "",
            variant: _vm.alertType,
          },
          on: {
            dismissed: function ($event) {
              _vm.dismissCountDown = 0
            },
            "dismiss-count-down": _vm.countDownChanged,
          },
        },
        [_vm._v("\n        " + _vm._s(_vm.alertMessage) + "\n    ")]
      ),
      _vm._v(" "),
      _c("br"),
      _vm._v(" "),
      _c("div", { staticClass: "row justify-content-center" }, [
        _c("div", { staticClass: "col-md-8 toastify-container" }, [
          _vm.account
            ? _c("h2", { attrs: { id: "password-title" } }, [
                _c("span", {
                  domProps: {
                    innerHTML: _vm._s(
                      _vm.$t("password.title", { username: _vm.username })
                    ),
                  },
                }),
              ])
            : _vm._e(),
          _vm._v(" "),
          _vm.credentialChange.credentialUpdateType === "CLIENT_CERT"
            ? _c("h3", { attrs: { id: "client-cert-title" } }, [
                _c("span", {
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("global.messages.client.cert.title")
                    ),
                  },
                }),
              ])
            : _vm._e(),
          _vm._v(" "),
          _vm.credentialChange.credentialUpdateType === "TOTP"
            ? _c("h3", { attrs: { id: "totp-title" } }, [
                _c("span", {
                  domProps: {
                    textContent: _vm._s(_vm.$t("global.messages.totp.title")),
                  },
                }),
              ])
            : _vm._e(),
          _vm._v(" "),
          _vm.credentialChange.credentialUpdateType === "SMS"
            ? _c("h3", { attrs: { id: "sms-title" } }, [
                _c("span", {
                  domProps: {
                    textContent: _vm._s(_vm.$t("global.messages.totp.title")),
                  },
                }),
              ])
            : _vm._e(),
          _vm._v(" "),
          _vm.oldPasswordMismatch
            ? _c(
                "div",
                {
                  staticClass: "alert alert-danger",
                  attrs: { role: "alert" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("global.messages.error.oldPasswordMismatch")
                    ),
                  },
                },
                [
                  _vm._v(
                    "\n                The password and its confirmation do not match!\n            "
                  ),
                ]
              )
            : _vm._e(),
          _vm._v(" "),
          _c(
            "form",
            {
              attrs: { name: "form", role: "form", id: "password-form" },
              on: {
                submit: function ($event) {
                  $event.preventDefault()
                  return _vm.saveCredentials()
                },
              },
            },
            [
              _c("div", { staticClass: "row justify-content-start" }, [
                _c("div", { staticClass: "col-sm" }, [
                  _c("label", {
                    staticClass: "form-control-label",
                    attrs: { for: "currentPassword" },
                    domProps: {
                      textContent: _vm._s(
                        _vm.$t("global.form.currentpassword.label")
                      ),
                    },
                  }),
                ]),
                _vm._v(" "),
                _c("div", { staticClass: "col-6" }, [
                  _c("input", {
                    directives: [
                      {
                        name: "model",
                        rawName: "v-model",
                        value: _vm.$v.resetPassword.currentPassword.$model,
                        expression: "$v.resetPassword.currentPassword.$model",
                      },
                    ],
                    staticClass: "form-control form-check-inline w-50",
                    class: {
                      valid: !_vm.$v.resetPassword.currentPassword.$invalid,
                      invalid: _vm.$v.resetPassword.currentPassword.$invalid,
                    },
                    attrs: {
                      type: "password",
                      id: "currentPassword",
                      name: "currentPassword",
                      placeholder: _vm.$t(
                        "global.form.currentpassword.placeholder"
                      ),
                      required: "",
                    },
                    domProps: {
                      value: _vm.$v.resetPassword.currentPassword.$model,
                    },
                    on: {
                      input: function ($event) {
                        if ($event.target.composing) return
                        _vm.$set(
                          _vm.$v.resetPassword.currentPassword,
                          "$model",
                          $event.target.value
                        )
                      },
                    },
                  }),
                  _vm._v(" "),
                  _vm.showRequiredWarning(
                    true,
                    _vm.$v.resetPassword.currentPassword.$model
                  )
                    ? _c("small", {
                        staticClass: "form-text text-danger",
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("entity.validation.required")
                          ),
                        },
                      })
                    : _vm._e(),
                ]),
                _vm._v(" "),
                _c("div", { staticClass: "col" }),
              ]),
              _vm._v(" "),
              _vm.credentialChange.credentialUpdateType === "CLIENT_CERT"
                ? _c("div", { staticClass: "row justify-content-start" }, [
                    _c("div", { staticClass: "col-sm" }, [
                      _c("label", {
                        staticClass: "form-control-label",
                        attrs: { for: "client-auth-secret" },
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("global.form.client.cert")
                          ),
                        },
                      }),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col-6" }, [
                      _c("input", {
                        directives: [
                          {
                            name: "model",
                            rawName: "v-model",
                            value: _vm.$v.clientAuthSecret.$model,
                            expression: "$v.clientAuthSecret.$model",
                          },
                        ],
                        staticClass: "form-control form-check-inline w-50",
                        class: _vm.showRequiredWarning(
                          true,
                          _vm.$v.clientAuthSecret.$model
                        )
                          ? "invalid"
                          : " valid",
                        attrs: {
                          type: "password",
                          name: "client-auth-secret",
                          id: "client-auth-secret",
                          autocomplete: "off",
                          autocorrect: "off",
                          autocapitalize: "off",
                          spellcheck: "false",
                          required: "",
                          placeholder: _vm.$t(
                            "global.form.keystorepassword.placeholder"
                          ),
                        },
                        domProps: { value: _vm.$v.clientAuthSecret.$model },
                        on: {
                          input: function ($event) {
                            if ($event.target.composing) return
                            _vm.$set(
                              _vm.$v.clientAuthSecret,
                              "$model",
                              $event.target.value
                            )
                          },
                        },
                      }),
                      _vm._v(" "),
                      _vm.showRequiredWarning(
                        true,
                        _vm.$v.clientAuthSecret.$model
                      )
                        ? _c("small", {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          })
                        : _vm._e(),
                      _vm._v(" "),
                      _vm.showRegExpFieldWarning(
                        _vm.$v.clientAuthSecret.$model,
                        _vm.regExpSecret()
                      )
                        ? _c("small", {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t(
                                  "ca3SApp.messages.password.requirement." +
                                    _vm.regExpSecretDescription()
                                )
                              ),
                            },
                          })
                        : _vm._e(),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col" }, [
                      _c(
                        "button",
                        {
                          staticClass: "btn btn-primary",
                          attrs: { disabled: !_vm.canCreateCertificate() },
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.form.create.client.certificate")
                            ),
                          },
                          on: {
                            click: function ($event) {
                              $event.preventDefault()
                              return _vm.downloadPersonalCertificate(
                                _vm.$v.clientAuthSecret.$model
                              )
                            },
                          },
                        },
                        [_c("font-awesome-icon", { attrs: { icon: "plus" } })],
                        1
                      ),
                    ]),
                  ])
                : _vm._e(),
              _vm._v(" "),
              _vm.credentialChange.clientAuthCertId !== 0
                ? _c("div", { staticClass: "row justify-content-start" }, [
                    _c("div", { staticClass: "col-sm" }, [
                      _c("label", {
                        staticClass: "form-control-label",
                        attrs: { for: "jhi-test-clientAuthCert" },
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.form.client.cert.install")
                          ),
                        },
                      }),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col-6" }),
                    _vm._v(" "),
                    _c("div", { staticClass: "col" }),
                  ])
                : _vm._e(),
              _vm._v(" "),
              _vm.credentialChange.credentialUpdateType === "TOTP"
                ? _c("div", { staticClass: "row justify-content-start" }, [
                    _c("div", { staticClass: "col-sm" }, [
                      _c("label", {
                        staticClass: "form-control-label",
                        attrs: { for: "otp-useGivenSeed" },
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.form.client.otp.useGivenSeed")
                          ),
                        },
                      }),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col-6" }, [
                      _c("input", {
                        directives: [
                          {
                            name: "model",
                            rawName: "v-model",
                            value: _vm.useGivenSeed,
                            expression: "useGivenSeed",
                          },
                        ],
                        staticClass: "form-check-inline",
                        attrs: {
                          type: "checkbox",
                          name: "otp-useGivenSeed",
                          id: "otp-useGivenSeed",
                        },
                        domProps: {
                          checked: Array.isArray(_vm.useGivenSeed)
                            ? _vm._i(_vm.useGivenSeed, null) > -1
                            : _vm.useGivenSeed,
                        },
                        on: {
                          change: [
                            function ($event) {
                              var $$a = _vm.useGivenSeed,
                                $$el = $event.target,
                                $$c = $$el.checked ? true : false
                              if (Array.isArray($$a)) {
                                var $$v = null,
                                  $$i = _vm._i($$a, $$v)
                                if ($$el.checked) {
                                  $$i < 0 &&
                                    (_vm.useGivenSeed = $$a.concat([$$v]))
                                } else {
                                  $$i > -1 &&
                                    (_vm.useGivenSeed = $$a
                                      .slice(0, $$i)
                                      .concat($$a.slice($$i + 1)))
                                }
                              } else {
                                _vm.useGivenSeed = $$c
                              }
                            },
                            function ($event) {
                              return _vm.updateSeedMode()
                            },
                          ],
                        },
                      }),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col" }),
                  ])
                : _vm._e(),
              _vm._v(" "),
              _vm.credentialChange.credentialUpdateType === "TOTP"
                ? _c("div", { staticClass: "row justify-content-start" }, [
                    _c("div", { staticClass: "col-sm" }, [
                      _c("label", {
                        staticClass: "form-control-label",
                        attrs: { for: "otp-seed" },
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.form.client.otp.seed")
                          ),
                        },
                      }),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col-6" }, [
                      _c("input", {
                        directives: [
                          {
                            name: "model",
                            rawName: "v-model",
                            value: _vm.credentialChange.seed,
                            expression: "credentialChange.seed",
                          },
                        ],
                        staticClass: "form-control form-check-inline w-50",
                        attrs: {
                          type: "text",
                          disabled: !_vm.useGivenSeed,
                          name: "otp-seed",
                          id: "otp-seed",
                          autocomplete: "off",
                          autocorrect: "off",
                          autocapitalize: "off",
                          spellcheck: "false",
                        },
                        domProps: { value: _vm.credentialChange.seed },
                        on: {
                          input: function ($event) {
                            if ($event.target.composing) return
                            _vm.$set(
                              _vm.credentialChange,
                              "seed",
                              $event.target.value
                            )
                          },
                        },
                      }),
                      _vm._v(" "),
                      _vm.showBase32RegExpFieldWarning(
                        _vm.credentialChange.seed
                      )
                        ? _c("small", {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("ca3SApp.messages.seed.base32Expected")
                              ),
                            },
                          })
                        : _vm._e(),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col" }),
                  ])
                : _vm._e(),
              _vm._v(" "),
              _vm.credentialChange.credentialUpdateType === "TOTP" &&
              !_vm.useGivenSeed
                ? _c("div", { staticClass: "row justify-content-start" }, [
                    _c("div", { staticClass: "col-sm" }, [
                      _c("label", {
                        staticClass: "form-control-label",
                        attrs: { for: "request-otp-qrcode" },
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.form.client.otp.qrcode")
                          ),
                        },
                      }),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col-6" }, [
                      _c("img", { attrs: { src: _vm.qrCodeImgUrl } }),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col" }),
                  ])
                : _vm._e(),
              _vm._v(" "),
              _vm.credentialChange.credentialUpdateType === "TOTP"
                ? _c("div", { staticClass: "row justify-content-start" }, [
                    _c("div", { staticClass: "col-sm" }, [
                      _c("label", {
                        staticClass: "form-control-label",
                        attrs: { for: "otp-test-value" },
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.form.client.otp.value")
                          ),
                        },
                      }),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col-6" }, [
                      _c("input", {
                        directives: [
                          {
                            name: "model",
                            rawName: "v-model",
                            value: _vm.credentialChange.otpTestValue,
                            expression: "credentialChange.otpTestValue",
                          },
                        ],
                        staticClass: "form-check-inline",
                        class: _vm.showTOTPExpFieldWarning(
                          _vm.credentialChange.otpTestValue
                        )
                          ? "invalid"
                          : " valid",
                        attrs: {
                          type: "text",
                          name: "otp-test-value",
                          id: "otp-test-value",
                          autocomplete: "off",
                          autocorrect: "off",
                          autocapitalize: "off",
                          spellcheck: "false",
                          required: "",
                        },
                        domProps: { value: _vm.credentialChange.otpTestValue },
                        on: {
                          input: function ($event) {
                            if ($event.target.composing) return
                            _vm.$set(
                              _vm.credentialChange,
                              "otpTestValue",
                              $event.target.value
                            )
                          },
                        },
                      }),
                      _vm._v(" "),
                      _vm.showTOTPExpFieldWarning(
                        _vm.credentialChange.otpTestValue
                      )
                        ? _c("small", {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("ca3SApp.messages.sixNumbersExpected")
                              ),
                            },
                          })
                        : _vm._e(),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col" }),
                  ])
                : _vm._e(),
              _vm._v(" "),
              _vm.credentialChange.credentialUpdateType === "SMS"
                ? _c("div", { staticClass: "row justify-content-start" }, [
                    _c("div", { staticClass: "col-sm" }, [
                      _c("label", {
                        staticClass: "form-control-label",
                        attrs: { for: "sms-test-request" },
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.form.client.sms.test.label")
                          ),
                        },
                      }),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col-6" }, [
                      _c("button", {
                        staticClass: "btn btn-primary",
                        attrs: { type: "submit" },
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.form.client.credentials.sms.test")
                          ),
                        },
                        on: {
                          click: function ($event) {
                            $event.preventDefault()
                            return _vm.sendSMS()
                          },
                        },
                      }),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col" }),
                  ])
                : _vm._e(),
              _vm._v(" "),
              _vm.credentialChange.credentialUpdateType === "SMS" && _vm.smsSent
                ? _c("div", { staticClass: "row justify-content-start" }, [
                    _c("div", { staticClass: "col-sm" }, [
                      _c("label", {
                        staticClass: "form-control-label",
                        attrs: { for: "sms-test-value" },
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.form.client.sms.value")
                          ),
                        },
                      }),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col-6" }, [
                      _c("input", {
                        directives: [
                          {
                            name: "model",
                            rawName: "v-model",
                            value: _vm.credentialChange.otpTestValue,
                            expression: "credentialChange.otpTestValue",
                          },
                        ],
                        staticClass: "form-check-inline",
                        class: _vm.showTOTPExpFieldWarning(
                          _vm.credentialChange.otpTestValue
                        )
                          ? "invalid"
                          : " valid",
                        attrs: {
                          type: "text",
                          name: "sms-test-value",
                          id: "sms-test-value",
                          autocomplete: "off",
                          autocorrect: "off",
                          autocapitalize: "off",
                          spellcheck: "false",
                          required: "",
                        },
                        domProps: { value: _vm.credentialChange.otpTestValue },
                        on: {
                          input: function ($event) {
                            if ($event.target.composing) return
                            _vm.$set(
                              _vm.credentialChange,
                              "otpTestValue",
                              $event.target.value
                            )
                          },
                        },
                      }),
                      _vm._v(" "),
                      _vm.showTOTPExpFieldWarning(
                        _vm.credentialChange.otpTestValue
                      )
                        ? _c("small", {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("ca3SApp.messages.sixNumbersExpected")
                              ),
                            },
                          })
                        : _vm._e(),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "col" }),
                  ])
                : _vm._e(),
              _vm._v(" "),
              _c("div", [
                _c(
                  "button",
                  {
                    staticClass: "btn btn-info",
                    attrs: { type: "submit", id: _vm.updateCounter },
                    on: {
                      click: function ($event) {
                        $event.preventDefault()
                        return _vm.previousState()
                      },
                    },
                  },
                  [
                    _c("font-awesome-icon", { attrs: { icon: "arrow-left" } }),
                    _vm._v(" "),
                    _c(
                      "span",
                      {
                        domProps: {
                          textContent: _vm._s(_vm.$t("entity.action.back")),
                        },
                      },
                      [_vm._v(" Back")]
                    ),
                  ],
                  1
                ),
                _vm._v(" "),
                _c(
                  "button",
                  {
                    staticClass: "btn btn-primary",
                    attrs: { type: "submit", disabled: !_vm.canSubmit() },
                    domProps: {
                      textContent: _vm._s(_vm.$t("password.form.button")),
                    },
                  },
                  [_vm._v("Save\n                    ")]
                ),
              ]),
            ]
          ),
        ]),
      ]),
    ],
    1
  )
}
var staticRenderFns = []
render._withStripped = true



/***/ })

}]);
//# sourceMappingURL=src_main_webapp_app_account_change-password_edit-credential_vue.48d04acdb0794179d7b4.chunk.js.map