"use strict";
(self["webpackChunkca_3_s"] = self["webpackChunkca_3_s"] || []).push([["src_main_webapp_app_admin_tenant_tenant-update_vue"],{

/***/ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/admin/tenant/tenant-update.component.ts?vue&type=script&lang=ts&":
/*!********************************************************************************************************************************************************!*\
  !*** ./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/admin/tenant/tenant-update.component.ts?vue&type=script&lang=ts& ***!
  \********************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
/* harmony import */ var vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vuelidate/lib/validators */ "./node_modules/vuelidate/lib/validators/index.js");
/* harmony import */ var _shared_model_tenant_model__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/shared/model/tenant.model */ "./src/main/webapp/app/shared/model/tenant.model.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



var validations = {
    tenant: {
        name: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_2__.required,
        },
        longname: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_2__.required,
        },
        active: {},
    },
};
var TenantUpdate = /** @class */ (function (_super) {
    __extends(TenantUpdate, _super);
    function TenantUpdate() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.tenant = new _shared_model_tenant_model__WEBPACK_IMPORTED_MODULE_1__.Tenant();
        _this.pipelines = [];
        _this.isSaving = false;
        _this.currentLanguage = '';
        return _this;
    }
    TenantUpdate.prototype.beforeRouteEnter = function (to, from, next) {
        next(function (vm) {
            if (to.params.tenantId) {
                vm.retrieveTenant(to.params.tenantId);
            }
            vm.initRelationships();
        });
    };
    TenantUpdate.prototype.created = function () {
        var _this = this;
        this.currentLanguage = this.$store.getters.currentLanguage;
        this.$store.watch(function () { return _this.$store.getters.currentLanguage; }, function () {
            _this.currentLanguage = _this.$store.getters.currentLanguage;
        });
    };
    TenantUpdate.prototype.save = function () {
        var self = this;
        this.isSaving = true;
        if (this.tenant.id) {
            this.tenantService()
                .update(this.tenant)
                .then(function (param) {
                self.isSaving = false;
                self.$router.push('/admin/tenant');
                var message = self.$t('ca3SApp.tenant.updated', { param: param.id });
                self.alertService().showAlert(message, 'info');
            })
                .catch(function (error) {
                self.isSaving = false;
                self.alertService().showAlert(error.response);
            });
        }
        else {
            this.tenantService()
                .create(this.tenant)
                .then(function (param) {
                self.isSaving = false;
                self.$router.push('/admin/tenant');
                var message = self.$t('ca3SApp.tenant.created', { param: param.id });
                self.alertService().showAlert(message, 'info');
            })
                .catch(function (error) {
                self.isSaving = false;
                self.alertService().showAlert(error.response);
            });
        }
    };
    TenantUpdate.prototype.retrieveTenant = function (tenantId) {
        var _this = this;
        this.tenantService()
            .find(tenantId)
            .then(function (res) {
            _this.tenant = res;
        })
            .catch(function (error) {
            _this.alertService().showAlert(error.response);
        });
    };
    TenantUpdate.prototype.previousState = function () {
        this.$router.push('/admin/tenant');
    };
    TenantUpdate.prototype.initRelationships = function () {
        /*
        this.pipelineService()
          .retrieve()
          .then(res => {
            this.pipelines = res.data;
          });
    
         */
    };
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('tenantService'),
        __metadata("design:type", Function)
    ], TenantUpdate.prototype, "tenantService", void 0);
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('alertService'),
        __metadata("design:type", Function)
    ], TenantUpdate.prototype, "alertService", void 0);
    TenantUpdate = __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component)({
            validations: validations,
        })
    ], TenantUpdate);
    return TenantUpdate;
}(vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Vue));
/* harmony default export */ __webpack_exports__["default"] = (TenantUpdate);


/***/ }),

/***/ "./src/main/webapp/app/shared/model/tenant.model.ts":
/*!**********************************************************!*\
  !*** ./src/main/webapp/app/shared/model/tenant.model.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Tenant": function() { return /* binding */ Tenant; }
/* harmony export */ });
var Tenant = /** @class */ (function () {
    function Tenant(id, name, longname, active, pipelines) {
        var _a;
        this.id = id;
        this.name = name;
        this.longname = longname;
        this.active = active;
        this.pipelines = pipelines;
        this.active = (_a = this.active) !== null && _a !== void 0 ? _a : false;
    }
    return Tenant;
}());



/***/ }),

/***/ "./src/main/webapp/app/admin/tenant/tenant-update.vue":
/*!************************************************************!*\
  !*** ./src/main/webapp/app/admin/tenant/tenant-update.vue ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _tenant_update_vue_vue_type_template_id_0f4ca65a___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./tenant-update.vue?vue&type=template&id=0f4ca65a& */ "./src/main/webapp/app/admin/tenant/tenant-update.vue?vue&type=template&id=0f4ca65a&");
/* harmony import */ var _tenant_update_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tenant-update.component.ts?vue&type=script&lang=ts& */ "./src/main/webapp/app/admin/tenant/tenant-update.component.ts?vue&type=script&lang=ts&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");





/* normalize component */
;
var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  _tenant_update_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__["default"],
  _tenant_update_vue_vue_type_template_id_0f4ca65a___WEBPACK_IMPORTED_MODULE_0__.render,
  _tenant_update_vue_vue_type_template_id_0f4ca65a___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/main/webapp/app/admin/tenant/tenant-update.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./src/main/webapp/app/admin/tenant/tenant-update.component.ts?vue&type=script&lang=ts&":
/*!**********************************************************************************************!*\
  !*** ./src/main/webapp/app/admin/tenant/tenant-update.component.ts?vue&type=script&lang=ts& ***!
  \**********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_tenant_update_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./tenant-update.component.ts?vue&type=script&lang=ts& */ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/admin/tenant/tenant-update.component.ts?vue&type=script&lang=ts&");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_tenant_update_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./src/main/webapp/app/admin/tenant/tenant-update.vue?vue&type=template&id=0f4ca65a&":
/*!*******************************************************************************************!*\
  !*** ./src/main/webapp/app/admin/tenant/tenant-update.vue?vue&type=template&id=0f4ca65a& ***!
  \*******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_tenant_update_vue_vue_type_template_id_0f4ca65a___WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   "staticRenderFns": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_tenant_update_vue_vue_type_template_id_0f4ca65a___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_tenant_update_vue_vue_type_template_id_0f4ca65a___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./tenant-update.vue?vue&type=template&id=0f4ca65a& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/admin/tenant/tenant-update.vue?vue&type=template&id=0f4ca65a&");


/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/admin/tenant/tenant-update.vue?vue&type=template&id=0f4ca65a&":
/*!***********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/admin/tenant/tenant-update.vue?vue&type=template&id=0f4ca65a& ***!
  \***********************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* binding */ render; },
/* harmony export */   "staticRenderFns": function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c,
    _setup = _vm._self._setupProxy
  return _c("div", { staticClass: "row justify-content-center" }, [
    _c("div", { staticClass: "col-8" }, [
      _c(
        "form",
        {
          attrs: { name: "editForm", role: "form", novalidate: "" },
          on: {
            submit: function ($event) {
              $event.preventDefault()
              return _vm.save()
            },
          },
        },
        [
          _c(
            "h2",
            {
              attrs: {
                id: "ca3SApp.tenant.home.createOrEditLabel",
                "data-cy": "TenantCreateUpdateHeading",
              },
              domProps: {
                textContent: _vm._s(
                  _vm.$t("ca3SApp.tenant.home.createOrEditLabel")
                ),
              },
            },
            [_vm._v("\n        Create or edit a Tenant\n      ")]
          ),
          _vm._v(" "),
          _c("div", [
            _vm.tenant.id
              ? _c("div", { staticClass: "form-group" }, [
                  _c(
                    "label",
                    {
                      attrs: { for: "id" },
                      domProps: {
                        textContent: _vm._s(_vm.$t("global.field.id")),
                      },
                    },
                    [_vm._v("ID")]
                  ),
                  _vm._v(" "),
                  _c("input", {
                    directives: [
                      {
                        name: "model",
                        rawName: "v-model",
                        value: _vm.tenant.id,
                        expression: "tenant.id",
                      },
                    ],
                    staticClass: "form-control",
                    attrs: { type: "text", id: "id", name: "id", readonly: "" },
                    domProps: { value: _vm.tenant.id },
                    on: {
                      input: function ($event) {
                        if ($event.target.composing) return
                        _vm.$set(_vm.tenant, "id", $event.target.value)
                      },
                    },
                  }),
                ])
              : _vm._e(),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "tenant-name" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.tenant.name")),
                  },
                },
                [_vm._v("Name")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.tenant.name.$model,
                    expression: "$v.tenant.name.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.tenant.name.$invalid,
                  invalid: _vm.$v.tenant.name.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "name",
                  id: "tenant-name",
                  "data-cy": "name",
                  required: "",
                },
                domProps: { value: _vm.$v.tenant.name.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(_vm.$v.tenant.name, "$model", $event.target.value)
                  },
                },
              }),
              _vm._v(" "),
              _vm.$v.tenant.name.$anyDirty && _vm.$v.tenant.name.$invalid
                ? _c("div", [
                    !_vm.$v.tenant.name.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n              This field is required.\n            "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "tenant-longname" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.tenant.longname")),
                  },
                },
                [_vm._v("Longname")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.tenant.longname.$model,
                    expression: "$v.tenant.longname.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.tenant.longname.$invalid,
                  invalid: _vm.$v.tenant.longname.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "longname",
                  id: "tenant-longname",
                  "data-cy": "longname",
                  required: "",
                },
                domProps: { value: _vm.$v.tenant.longname.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.tenant.longname,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
              _vm._v(" "),
              _vm.$v.tenant.longname.$anyDirty &&
              _vm.$v.tenant.longname.$invalid
                ? _c("div", [
                    !_vm.$v.tenant.longname.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n              This field is required.\n            "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "tenant-active" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.tenant.active")),
                  },
                },
                [_vm._v("Active")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.tenant.active.$model,
                    expression: "$v.tenant.active.$model",
                  },
                ],
                staticClass: "form-check",
                class: {
                  valid: !_vm.$v.tenant.active.$invalid,
                  invalid: _vm.$v.tenant.active.$invalid,
                },
                attrs: {
                  type: "checkbox",
                  name: "active",
                  id: "tenant-active",
                  "data-cy": "active",
                },
                domProps: {
                  checked: Array.isArray(_vm.$v.tenant.active.$model)
                    ? _vm._i(_vm.$v.tenant.active.$model, null) > -1
                    : _vm.$v.tenant.active.$model,
                },
                on: {
                  change: function ($event) {
                    var $$a = _vm.$v.tenant.active.$model,
                      $$el = $event.target,
                      $$c = $$el.checked ? true : false
                    if (Array.isArray($$a)) {
                      var $$v = null,
                        $$i = _vm._i($$a, $$v)
                      if ($$el.checked) {
                        $$i < 0 &&
                          _vm.$set(
                            _vm.$v.tenant.active,
                            "$model",
                            $$a.concat([$$v])
                          )
                      } else {
                        $$i > -1 &&
                          _vm.$set(
                            _vm.$v.tenant.active,
                            "$model",
                            $$a.slice(0, $$i).concat($$a.slice($$i + 1))
                          )
                      }
                    } else {
                      _vm.$set(_vm.$v.tenant.active, "$model", $$c)
                    }
                  },
                },
              }),
            ]),
          ]),
          _vm._v(" "),
          _c("div", [
            _c(
              "button",
              {
                staticClass: "btn btn-secondary",
                attrs: {
                  type: "button",
                  id: "cancel-save",
                  "data-cy": "entityCreateCancelButton",
                },
                on: {
                  click: function ($event) {
                    return _vm.previousState()
                  },
                },
              },
              [
                _c("font-awesome-icon", { attrs: { icon: "ban" } }),
                _vm._v(" "),
                _c(
                  "span",
                  {
                    domProps: {
                      textContent: _vm._s(_vm.$t("entity.action.cancel")),
                    },
                  },
                  [_vm._v("Cancel")]
                ),
              ],
              1
            ),
            _vm._v(" "),
            _c(
              "button",
              {
                staticClass: "btn btn-primary",
                attrs: {
                  type: "submit",
                  id: "save-entity",
                  "data-cy": "entityCreateSaveButton",
                  disabled: _vm.$v.tenant.$invalid || _vm.isSaving,
                },
              },
              [
                _c("font-awesome-icon", { attrs: { icon: "save" } }),
                _vm._v(" "),
                _c(
                  "span",
                  {
                    domProps: {
                      textContent: _vm._s(_vm.$t("entity.action.save")),
                    },
                  },
                  [_vm._v("Save")]
                ),
              ],
              1
            ),
          ]),
        ]
      ),
    ]),
  ])
}
var staticRenderFns = []
render._withStripped = true



/***/ })

}]);
//# sourceMappingURL=src_main_webapp_app_admin_tenant_tenant-update_vue.e7d121667fdfba72ace5.chunk.js.map