"use strict";
(self["webpackChunkca_3_s"] = self["webpackChunkca_3_s"] || []).push([["src_main_webapp_app_admin_tenant_tenant_vue"],{

/***/ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/admin/tenant/tenant.component.ts?vue&type=script&lang=ts&":
/*!*************************************************************************************************************************************************!*\
  !*** ./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/admin/tenant/tenant.component.ts?vue&type=script&lang=ts& ***!
  \*************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
/* harmony import */ var vue2_filters__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue2-filters */ "./node_modules/vue2-filters/dist/vue2-filters.js");
/* harmony import */ var vue2_filters__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(vue2_filters__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var vue_class_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vue-class-component */ "./node_modules/vue-class-component/dist/vue-class-component.esm.js");
/* harmony import */ var _shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/shared/alert/alert.mixin */ "./src/main/webapp/app/shared/alert/alert.mixin.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




var Tenant = /** @class */ (function (_super) {
    __extends(Tenant, _super);
    function Tenant() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.removeId = null;
        _this.tenants = [];
        _this.isFetching = false;
        return _this;
    }
    Tenant.prototype.mounted = function () {
        this.retrieveAllTenants();
    };
    Tenant.prototype.clear = function () {
        this.retrieveAllTenants();
    };
    Tenant.prototype.retrieveAllTenants = function () {
        var self = this;
        this.isFetching = true;
        this.tenantService()
            .retrieve()
            .then(function (res) {
            self.tenants = res.data;
            self.isFetching = false;
        }, function (err) {
            self.isFetching = false;
            self.alertService().showAlert(err.response, 'warn');
        });
    };
    Tenant.prototype.handleSyncList = function () {
        this.clear();
    };
    Tenant.prototype.prepareRemove = function (instance) {
        this.removeId = instance.id;
        if (this.$refs.removeEntity) {
            this.$refs.removeEntity.show();
        }
    };
    Tenant.prototype.removeTenant = function () {
        var self = this;
        this.tenantService()
            .delete(this.removeId)
            .then(function () {
            var message = self.$t('ca3SApp.tenant.deleted', { param: self.removeId });
            self.alertService().showAlert(message, 'info');
            self.removeId = null;
            self.retrieveAllTenants();
            self.closeDialog();
        })
            .catch(function (error) {
            self.alertService().showAlert(error.response, 'error');
        });
    };
    Tenant.prototype.closeDialog = function () {
        this.$refs.removeEntity.hide();
    };
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('tenantService'),
        __metadata("design:type", Function)
    ], Tenant.prototype, "tenantService", void 0);
    Tenant = __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component)({
            mixins: [(vue2_filters__WEBPACK_IMPORTED_MODULE_1___default().mixin)],
        })
    ], Tenant);
    return Tenant;
}((0,vue_class_component__WEBPACK_IMPORTED_MODULE_3__.mixins)(_shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_2__["default"], vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Vue)));
/* harmony default export */ __webpack_exports__["default"] = (Tenant);


/***/ }),

/***/ "./src/main/webapp/app/shared/alert/alert.mixin.ts":
/*!*********************************************************!*\
  !*** ./src/main/webapp/app/shared/alert/alert.mixin.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};

var AlertMixin = /** @class */ (function (_super) {
    __extends(AlertMixin, _super);
    function AlertMixin() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.dismissCountDown = _this.$store.getters.dismissCountDown;
        _this.dismissSecs = _this.$store.getters.dismissSecs;
        _this.alertType = _this.$store.getters.alertType;
        _this.alertMessage = _this.$store.getters.alertMessage;
        return _this;
    }
    AlertMixin.prototype.getAlertFromStore = function () {
        this.dismissCountDown = this.$store.getters.dismissCountDown;
        this.dismissSecs = this.$store.getters.dismissSecs;
        this.alertType = this.$store.getters.alertType;
        this.alertMessage = this.$store.getters.alertMessage;
    };
    AlertMixin.prototype.countDownChanged = function (dismissCountDown) {
        this.alertService().countDownChanged(dismissCountDown);
        this.getAlertFromStore();
    };
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('alertService'),
        __metadata("design:type", Function)
    ], AlertMixin.prototype, "alertService", void 0);
    AlertMixin = __decorate([
        vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component
    ], AlertMixin);
    return AlertMixin;
}(vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Vue));
/* harmony default export */ __webpack_exports__["default"] = (AlertMixin);


/***/ }),

/***/ "./src/main/webapp/app/admin/tenant/tenant.vue":
/*!*****************************************************!*\
  !*** ./src/main/webapp/app/admin/tenant/tenant.vue ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _tenant_vue_vue_type_template_id_36b906e8___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./tenant.vue?vue&type=template&id=36b906e8& */ "./src/main/webapp/app/admin/tenant/tenant.vue?vue&type=template&id=36b906e8&");
/* harmony import */ var _tenant_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tenant.component.ts?vue&type=script&lang=ts& */ "./src/main/webapp/app/admin/tenant/tenant.component.ts?vue&type=script&lang=ts&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");





/* normalize component */
;
var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  _tenant_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__["default"],
  _tenant_vue_vue_type_template_id_36b906e8___WEBPACK_IMPORTED_MODULE_0__.render,
  _tenant_vue_vue_type_template_id_36b906e8___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/main/webapp/app/admin/tenant/tenant.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./src/main/webapp/app/admin/tenant/tenant.component.ts?vue&type=script&lang=ts&":
/*!***************************************************************************************!*\
  !*** ./src/main/webapp/app/admin/tenant/tenant.component.ts?vue&type=script&lang=ts& ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_tenant_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./tenant.component.ts?vue&type=script&lang=ts& */ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/admin/tenant/tenant.component.ts?vue&type=script&lang=ts&");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_tenant_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./src/main/webapp/app/admin/tenant/tenant.vue?vue&type=template&id=36b906e8&":
/*!************************************************************************************!*\
  !*** ./src/main/webapp/app/admin/tenant/tenant.vue?vue&type=template&id=36b906e8& ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_tenant_vue_vue_type_template_id_36b906e8___WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   "staticRenderFns": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_tenant_vue_vue_type_template_id_36b906e8___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_tenant_vue_vue_type_template_id_36b906e8___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./tenant.vue?vue&type=template&id=36b906e8& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/admin/tenant/tenant.vue?vue&type=template&id=36b906e8&");


/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/admin/tenant/tenant.vue?vue&type=template&id=36b906e8&":
/*!****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/admin/tenant/tenant.vue?vue&type=template&id=36b906e8& ***!
  \****************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* binding */ render; },
/* harmony export */   "staticRenderFns": function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c,
    _setup = _vm._self._setupProxy
  return _c(
    "div",
    [
      _c("h2", { attrs: { id: "page-heading", "data-cy": "TenantHeading" } }, [
        _c(
          "span",
          {
            attrs: { id: "tenant-heading" },
            domProps: {
              textContent: _vm._s(_vm.$t("ca3SApp.tenant.home.title")),
            },
          },
          [_vm._v("Tenants")]
        ),
        _vm._v(" "),
        _c(
          "div",
          { staticClass: "d-flex justify-content-end" },
          [
            _c(
              "router-link",
              {
                staticClass:
                  "btn btn-primary float-right jh-create-entity create-tenant",
                attrs: {
                  to: { name: "TenantNew" },
                  tag: "button",
                  id: "jh-create-tenant",
                },
              },
              [
                _c("font-awesome-icon", { attrs: { icon: "plus" } }),
                _vm._v(" "),
                _c(
                  "span",
                  {
                    domProps: {
                      textContent: _vm._s(
                        _vm.$t("ca3SApp.tenant.home.createLabel")
                      ),
                    },
                  },
                  [_vm._v(" Create a new Tenant ")]
                ),
              ],
              1
            ),
          ],
          1
        ),
      ]),
      _vm._v(" "),
      _c("br"),
      _vm._v(" "),
      !_vm.isFetching && _vm.tenants && _vm.tenants.length === 0
        ? _c("div", { staticClass: "alert alert-warning" }, [
            _c(
              "span",
              {
                domProps: {
                  textContent: _vm._s(_vm.$t("ca3SApp.tenant.home.notFound")),
                },
              },
              [_vm._v("No tenants found")]
            ),
          ])
        : _vm._e(),
      _vm._v(" "),
      _vm.tenants && _vm.tenants.length > 0
        ? _c("div", { staticClass: "table-responsive" }, [
            _c(
              "table",
              {
                staticClass: "table table-striped",
                attrs: { "aria-describedby": "tenants" },
              },
              [
                _c("thead", [
                  _c("tr", [
                    _c("th", { attrs: { scope: "row" } }, [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(_vm.$t("global.field.id")),
                          },
                        },
                        [_vm._v("ID")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("th", { attrs: { scope: "row" } }, [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(_vm.$t("ca3SApp.tenant.name")),
                          },
                        },
                        [_vm._v("Name")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("th", { attrs: { scope: "row" } }, [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.tenant.longname")
                            ),
                          },
                        },
                        [_vm._v("Longname")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("th", { attrs: { scope: "row" } }, [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.tenant.active")
                            ),
                          },
                        },
                        [_vm._v("Active")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("th", { attrs: { scope: "row" } }),
                  ]),
                ]),
                _vm._v(" "),
                _c(
                  "tbody",
                  _vm._l(_vm.tenants, function (tenant) {
                    return _c(
                      "tr",
                      { key: tenant.id, attrs: { "data-cy": "entityTable" } },
                      [
                        _c(
                          "td",
                          {
                            on: {
                              click: function ($event) {
                                return _vm.$router.push({
                                  name: "TenantEdit",
                                  params: { tenantId: tenant.id },
                                })
                              },
                            },
                          },
                          [_vm._v(_vm._s(tenant.id))]
                        ),
                        _vm._v(" "),
                        _c(
                          "td",
                          {
                            on: {
                              click: function ($event) {
                                return _vm.$router.push({
                                  name: "TenantEdit",
                                  params: { tenantId: tenant.id },
                                })
                              },
                            },
                          },
                          [_vm._v(_vm._s(tenant.name) + "\n                ")]
                        ),
                        _vm._v(" "),
                        _c(
                          "td",
                          {
                            on: {
                              click: function ($event) {
                                return _vm.$router.push({
                                  name: "TenantEdit",
                                  params: { tenantId: tenant.id },
                                })
                              },
                            },
                          },
                          [
                            _vm._v(
                              _vm._s(tenant.longname) + "\n                "
                            ),
                          ]
                        ),
                        _vm._v(" "),
                        _c(
                          "td",
                          {
                            on: {
                              click: function ($event) {
                                return _vm.$router.push({
                                  name: "TenantEdit",
                                  params: { tenantId: tenant.id },
                                })
                              },
                            },
                          },
                          [_vm._v(_vm._s(tenant.active) + "\n                ")]
                        ),
                        _vm._v(" "),
                        _c("td", { staticClass: "text-right" }, [
                          _c(
                            "div",
                            { staticClass: "btn-group" },
                            [
                              _c(
                                "b-button",
                                {
                                  directives: [
                                    {
                                      name: "b-modal",
                                      rawName: "v-b-modal.removeEntity",
                                      modifiers: { removeEntity: true },
                                    },
                                  ],
                                  staticClass: "btn btn-sm",
                                  attrs: {
                                    variant: "danger",
                                    "data-cy": "entityDeleteButton",
                                  },
                                  on: {
                                    click: function ($event) {
                                      return _vm.prepareRemove(tenant)
                                    },
                                  },
                                },
                                [
                                  _c("font-awesome-icon", {
                                    attrs: { icon: "times" },
                                  }),
                                  _vm._v(" "),
                                  _c(
                                    "span",
                                    {
                                      staticClass: "d-none d-md-inline",
                                      domProps: {
                                        textContent: _vm._s(
                                          _vm.$t("entity.action.delete")
                                        ),
                                      },
                                    },
                                    [_vm._v("Delete")]
                                  ),
                                ],
                                1
                              ),
                            ],
                            1
                          ),
                        ]),
                      ]
                    )
                  }),
                  0
                ),
              ]
            ),
          ])
        : _vm._e(),
      _vm._v(" "),
      _c("b-modal", { ref: "removeEntity", attrs: { id: "removeEntity" } }, [
        _c("span", { attrs: { slot: "modal-title" }, slot: "modal-title" }, [
          _c(
            "span",
            {
              attrs: {
                id: "ca3SApp.tenant.delete.question",
                "data-cy": "tenantDeleteDialogHeading",
              },
              domProps: { textContent: _vm._s(_vm.$t("entity.delete.title")) },
            },
            [_vm._v("Confirm delete operation")]
          ),
        ]),
        _vm._v(" "),
        _c("div", { staticClass: "modal-body" }, [
          _c(
            "p",
            {
              attrs: { id: "jhi-delete-tenant-heading" },
              domProps: {
                textContent: _vm._s(
                  _vm.$t("ca3SApp.tenant.delete.question", { id: _vm.removeId })
                ),
              },
            },
            [
              _vm._v(
                "\n                Are you sure you want to delete this Tenant?\n            "
              ),
            ]
          ),
        ]),
        _vm._v(" "),
        _c("div", { attrs: { slot: "modal-footer" }, slot: "modal-footer" }, [
          _c(
            "button",
            {
              staticClass: "btn btn-secondary",
              attrs: { type: "button" },
              domProps: { textContent: _vm._s(_vm.$t("entity.action.cancel")) },
              on: {
                click: function ($event) {
                  return _vm.closeDialog()
                },
              },
            },
            [_vm._v("Cancel\n            ")]
          ),
          _vm._v(" "),
          _c(
            "button",
            {
              staticClass: "btn btn-primary",
              attrs: {
                type: "button",
                id: "jhi-confirm-delete-tenant",
                "data-cy": "entityConfirmDeleteButton",
              },
              domProps: { textContent: _vm._s(_vm.$t("entity.action.delete")) },
              on: {
                click: function ($event) {
                  return _vm.removeTenant()
                },
              },
            },
            [_vm._v("Delete")]
          ),
        ]),
      ]),
    ],
    1
  )
}
var staticRenderFns = []
render._withStripped = true



/***/ })

}]);
//# sourceMappingURL=src_main_webapp_app_admin_tenant_tenant_vue.ba25b540b92a9596a795.chunk.js.map